/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BitMaskUtil;

public class PropagationQueuingNode
extends ObjectSource
implements ObjectSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private static final int PROPAGATION_SLICE_LIMIT = 1000;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    private PropagateAction action;

    public PropagationQueuingNode() {
    }

    public PropagationQueuingNode(int id, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.action = new PropagateAction(this);
        this.initDeclaredMask(context);
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        return 0L;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.action = (PropagateAction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.action);
    }

    @Override
    public short getType() {
        return 50;
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        if (!memory.isEmpty()) {
            throw new RuntimeDroolsException("Error updating sink. Not safe to update sink as the PropagatingQueueingNode memory is not empty at node: " + this.toString());
        }
        this.source.updateSink(sink, context, workingMemory);
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public boolean isObjectMemoryEnabled() {
        return true;
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new AssertAction(factHandle, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new RetractAction(handle, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        for (ObjectSink s : this.sink.getSinks()) {
            BetaNode betaNode = (BetaNode)s;
            RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
            while (rightTuple != null && rightTuple.getRightTupleSink().getRightInputOtnId().before(betaNode.getRightInputOtnId())) {
                modifyPreviousTuples.removeRightTuple();
                rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
                rightTuple = modifyPreviousTuples.peekRightTuple();
            }
            if (rightTuple != null && rightTuple.getRightTupleSink().getRightInputOtnId().equals(betaNode.getRightInputOtnId())) {
                modifyPreviousTuples.removeRightTuple();
                rightTuple.reAdd();
                if (!BitMaskUtil.intersect(context.getModificationMask(), betaNode.getRightInferredMask())) continue;
                memory.addAction(new ModifyToSinkAction(rightTuple, context, betaNode));
                continue;
            }
            if (!BitMaskUtil.intersect(context.getModificationMask(), betaNode.getRightInferredMask())) continue;
            memory.addAction(new AssertToSinkAction(factHandle, context, betaNode));
        }
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void propagateActions(InternalWorkingMemory workingMemory) {
        Action next;
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.isQueued().compareAndSet(true, false);
        for (int counter = 0; counter < 1000 && (next = memory.getNextAction()) != null; ++counter) {
            next.execute(this.sink, workingMemory);
        }
        if (memory.hasNextAction() && memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void setObjectMemoryEnabled(boolean objectMemoryOn) {
        throw new UnsupportedOperationException("PropagationQueueingNode must have its node memory enabled.");
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new PropagationQueueingNodeMemory();
    }

    @Override
    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof PropagationQueuingNode)) {
            return false;
        }
        PropagationQueuingNode other = (PropagationQueuingNode)object;
        return this.source.equals(other.source);
    }

    public static class PropagateAction
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 6765029029501617115L;
        private PropagationQueuingNode node;

        public PropagateAction() {
        }

        public PropagateAction(PropagationQueuingNode node) {
            this.node = node;
        }

        public PropagateAction(MarshallerReaderContext context) throws IOException {
            this.node = (PropagationQueuingNode)context.sinks.get(context.readInt());
        }

        public PropagateAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.node = (PropagationQueuingNode)context.sinks.get(_action.getPropagate().getNodeId());
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(3);
            context.write(this.node.getId());
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.PROPAGATE).setPropagate(ProtobufMessages.ActionQueue.Propagate.newBuilder().setNodeId(this.node.getId()).build()).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.node = (PropagationQueuingNode)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.node);
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.node.propagateActions(workingMemory);
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }

    private static class ModifyToSinkAction
    extends Action {
        private static final long serialVersionUID = -8478488926430845209L;
        private RightTupleSink nodeSink;
        private RightTuple rightTuple;

        public ModifyToSinkAction(RightTuple rightTuple, PropagationContext context, RightTupleSink nodeSink) {
            super(rightTuple.getFactHandle(), context);
            this.nodeSink = nodeSink;
            this.rightTuple = rightTuple;
        }

        @Override
        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            this.nodeSink.modifyRightTuple(this.rightTuple, this.context, workingMemory);
            this.context.evaluateActionQueue(workingMemory);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.nodeSink = (RightTupleSink)in.readObject();
            this.rightTuple = (RightTuple)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.nodeSink);
            out.writeObject(this.rightTuple);
        }
    }

    private static class RetractAction
    extends Action {
        private static final long serialVersionUID = -84784886430845209L;

        public RetractAction(InternalFactHandle handle, PropagationContext context) {
            super(handle, context);
        }

        @Override
        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            for (RightTuple rightTuple = this.handle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
                rightTuple.getRightTupleSink().retractRightTuple(rightTuple, this.context, workingMemory);
            }
            this.handle.clearRightTuples();
            for (LeftTuple leftTuple = this.handle.getLastLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
                leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, this.context, workingMemory);
            }
            this.handle.clearLeftTuples();
            this.context.evaluateActionQueue(workingMemory);
        }
    }

    private static class AssertToSinkAction
    extends Action {
        private static final long serialVersionUID = -8478488926430845209L;
        private ObjectSink nodeSink;

        public AssertToSinkAction(InternalFactHandle handle, PropagationContext context, ObjectSink sink) {
            super(handle, context);
            this.nodeSink = sink;
        }

        @Override
        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            this.nodeSink.assertObject(this.handle, this.context, workingMemory);
            this.context.evaluateActionQueue(workingMemory);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.nodeSink = (ObjectSink)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.nodeSink);
        }
    }

    private static class AssertAction
    extends Action {
        private static final long serialVersionUID = -8478488926430845209L;

        public AssertAction(InternalFactHandle handle, PropagationContext context) {
            super(handle, context);
        }

        @Override
        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            sink.propagateAssertObject(this.handle, this.context, workingMemory);
            this.context.evaluateActionQueue(workingMemory);
        }
    }

    private static abstract class Action
    implements Externalizable {
        protected InternalFactHandle handle;
        protected PropagationContext context;

        public Action(InternalFactHandle handle, PropagationContext context) {
            this.handle = handle;
            this.context = context;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
        }

        public abstract void execute(ObjectSinkPropagator var1, InternalWorkingMemory var2);
    }

    public static class PropagationQueueingNodeMemory
    implements Memory {
        private static final long serialVersionUID = 7372028632974484023L;
        private ConcurrentLinkedQueue<Action> queue = new ConcurrentLinkedQueue();
        private AtomicBoolean isQueued = new AtomicBoolean(false);

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void addAction(Action action) {
            this.queue.add(action);
        }

        public Action getNextAction() {
            return this.queue.poll();
        }

        public boolean hasNextAction() {
            return this.queue.peek() != null;
        }

        public AtomicBoolean isQueued() {
            return this.isQueued;
        }

        public long getSize() {
            return this.queue.size();
        }

        @Override
        public short getNodeType() {
            return 65;
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void nullPrevNext() {
            throw new UnsupportedOperationException();
        }
    }
}

