/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithExpression;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.ThrowStmtMetaModel;
import org.drools.javaparser.utils.Utils;

public final class ThrowStmt
extends Statement
implements NodeWithExpression<ThrowStmt> {
    private Expression expression;

    public ThrowStmt() {
        this(null, new NameExpr());
    }

    @AllFieldsConstructor
    public ThrowStmt(Expression expression) {
        this(null, expression);
    }

    public ThrowStmt(TokenRange tokenRange, Expression expression) {
        super(tokenRange);
        this.setExpression(expression);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public ThrowStmt setExpression(Expression expression) {
        Utils.assertNotNull(expression);
        if (expression == this.expression) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expression);
        if (this.expression != null) {
            this.expression.setParentNode(null);
        }
        this.expression = expression;
        this.setAsParentNodeOf(expression);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public ThrowStmt clone() {
        return (ThrowStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ThrowStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.throwStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.expression) {
            this.setExpression((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isThrowStmt() {
        return true;
    }

    @Override
    public ThrowStmt asThrowStmt() {
        return this;
    }

    @Override
    public void ifThrowStmt(Consumer<ThrowStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<ThrowStmt> toThrowStmt() {
        return Optional.of(this);
    }
}

