/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNContextFEELCtxWrapper;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.FunctionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNFunctionDefinitionEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNFunctionDefinitionEvaluator.class);
    private final String name;
    private final FunctionDefinition functionDefinition;
    private List<FormalParameter> parameters = new ArrayList<FormalParameter>();
    private DMNExpressionEvaluator evaluator;

    public DMNFunctionDefinitionEvaluator(String name, FunctionDefinition fdef) {
        this.name = name;
        this.functionDefinition = fdef;
    }

    public DMNType getParameterType(String name) {
        for (FormalParameter fp : this.parameters) {
            if (!fp.name.equals(name)) continue;
            return fp.type;
        }
        return null;
    }

    public List<List<String>> getParameterNames() {
        return Collections.singletonList(this.parameters.stream().map(p -> p.name).collect(Collectors.toList()));
    }

    public List<List<DMNType>> getParameterTypes() {
        return Collections.singletonList(this.parameters.stream().map(p -> p.type).collect(Collectors.toList()));
    }

    public void addParameter(String name, DMNType dmnType) {
        this.parameters.add(new FormalParameter(name, dmnType));
    }

    public void setEvaluator(DMNExpressionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public DMNExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        DMNFunction function = new DMNFunction(this.name, this.parameters, this.functionDefinition, this.evaluator, eventManager, result);
        return new EvaluatorResultImpl((Object)function, EvaluatorResult.ResultType.SUCCESS);
    }

    public static class DMNFunction
    extends BaseFEELFunction {
        private final List<FormalParameter> parameters;
        private final DMNExpressionEvaluator evaluator;
        private final DMNRuntimeEventManager eventManager;
        private final DMNResultImpl resultContext;
        private final FunctionDefinition functionDefinition;

        public DMNFunction(String name, List<FormalParameter> parameters, FunctionDefinition functionDefinition, DMNExpressionEvaluator evaluator, DMNRuntimeEventManager eventManager, DMNResultImpl result) {
            super(name);
            this.functionDefinition = functionDefinition;
            this.parameters = parameters;
            this.evaluator = evaluator;
            this.eventManager = eventManager;
            this.resultContext = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(EvaluationContext ctx, Object[] params) {
            DMNContext previousContext = this.resultContext.getContext();
            DMNContextFEELCtxWrapper dmnContext = new DMNContextFEELCtxWrapper(ctx);
            dmnContext.enterFrame();
            try {
                if (this.evaluator != null) {
                    previousContext.getAll().forEach(dmnContext::set);
                    for (int i = 0; i < params.length; ++i) {
                        dmnContext.set(this.parameters.get((int)i).name, params[i]);
                    }
                    this.resultContext.setContext(dmnContext);
                    EvaluatorResult result = this.evaluator.evaluate(this.eventManager, this.resultContext);
                    if (result.getResultType() == EvaluatorResult.ResultType.SUCCESS) {
                        Object object = result.getResult();
                        return object;
                    }
                    Object var6_10 = null;
                    return var6_10;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.functionDefinition, this.resultContext, null, null, Msg.MISSING_EXPRESSION_FOR_FUNCTION, this.getName());
                Object result = null;
                return result;
            }
            catch (Exception e) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.functionDefinition, this.resultContext, e, null, Msg.ERR_INVOKING_FUNCTION_ON_NODE, this.getName(), this.getName());
                Object var6_11 = null;
                return var6_11;
            }
            finally {
                this.resultContext.setContext(previousContext);
                dmnContext.exitFrame();
            }
        }

        protected boolean isCustomFunction() {
            return true;
        }

        public List<List<String>> getParameterNames() {
            return Collections.singletonList(this.parameters.stream().map(p -> p.name).collect(Collectors.toList()));
        }

        public List<List<DMNType>> getParameterTypes() {
            return Collections.singletonList(this.parameters.stream().map(p -> p.type).collect(Collectors.toList()));
        }

        public String toString() {
            return "function " + this.getName() + "( " + this.parameters.stream().map(p -> p.name).collect(Collectors.joining(", ")) + " )";
        }
    }

    public static class FormalParameter {
        final String name;
        final DMNType type;

        public FormalParameter(String name, DMNType type) {
            this.name = name;
            this.type = type;
        }
    }
}

