/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNEvaluatorCompiler;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTable;
import org.kie.dmn.feel.runtime.events.InvalidInputEvent;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DecisionRule;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.UnaryTests;

public class DTableModel {
    private final DMNFEELHelper feel;
    private final DMNModelImpl model;
    private final org.kie.dmn.model.api.DecisionTable dt;
    private final String namespace;
    private final String dtName;
    private final String tableName;
    private final org.kie.dmn.feel.runtime.decisiontables.HitPolicy hitPolicy;
    private final List<DColumnModel> columns;
    private final List<DRowModel> rows;
    private final List<DOutputModel> outputs;
    private final Map<String, Type> variableTypes;
    private final DecisionTable dtable;

    public DTableModel(DMNFEELHelper feel, DMNModelImpl model, String dtName, String tableName, org.kie.dmn.model.api.DecisionTable dt) {
        this.feel = feel;
        this.model = model;
        this.dt = dt;
        this.dtName = dtName;
        this.namespace = CodegenStringUtil.escapeIdentifier((String)model.getNamespace());
        this.tableName = CodegenStringUtil.escapeIdentifier((String)tableName);
        this.hitPolicy = org.kie.dmn.feel.runtime.decisiontables.HitPolicy.fromString((String)(dt.getHitPolicy().value() + (dt.getAggregation() != null ? " " + dt.getAggregation().value() : "")));
        this.columns = dt.getInput().stream().map(DColumnModel::new).collect(Collectors.toList());
        this.outputs = dt.getOutput().stream().map(DOutputModel::new).collect(Collectors.toList());
        this.rows = dt.getRule().stream().map(DRowModel::new).collect(Collectors.toList());
        this.variableTypes = this.columns.stream().collect(Collectors.toMap(DColumnModel::getName, DColumnModel::getType));
        this.dtable = new DecisionTableImpl(dtName, this.outputs);
    }

    public DTableModel compileAll(DMNCompilerContext ctx) {
        CompilerContext feelctx = this.feel.newCompilerContext();
        feelctx.setDoCompile(true);
        ctx.getVariables().forEach((k, v) -> feelctx.addInputVariableType(k, ((BaseDMNTypeImpl)v).getFeelType()));
        HashMap<String, CompiledFEELExpression> compilationCache = new HashMap<String, CompiledFEELExpression>();
        this.initInputClauses(feelctx, compilationCache);
        this.initRows(feelctx, compilationCache);
        this.initOutputClauses(feelctx, compilationCache);
        this.validate();
        return this;
    }

    private void validate() {
        if (this.dt.getHitPolicy().equals((Object)HitPolicy.PRIORITY) && !this.hasOutputValues()) {
            MsgUtil.reportMessage(ExecModelDMNEvaluatorCompiler.logger, DMNMessage.Severity.ERROR, this.dt.getParent(), this.model, null, null, Msg.MISSING_OUTPUT_VALUES, this.dt.getParent());
        }
    }

    private boolean hasOutputValues() {
        return this.outputs.stream().map(o -> ((DOutputModel)o).outputValues).anyMatch(l -> !l.isEmpty());
    }

    public boolean hasDefaultValues() {
        return this.outputs.stream().allMatch(o -> ((DOutputModel)o).compiledDefault != null);
    }

    private void initInputClauses(CompilerContext feelctx, Map<String, CompiledFEELExpression> compilationCache) {
        int index = 1;
        for (DColumnModel column : this.columns) {
            String inputValuesText = DTableModel.getInputValuesText(column.inputClause);
            if (inputValuesText != null) {
                column.inputTests = this.feel.evaluateUnaryTests(inputValuesText, this.variableTypes);
            }
            column.compiledInputClause = this.compileFeelExpression((DMNElement)column.inputClause, this.feel, feelctx, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_INPUT_CLAUSE_IDX, compilationCache, column.getName(), index++);
        }
    }

    private void initRows(CompilerContext feelctx, Map<String, CompiledFEELExpression> compilationCache) {
        int index = 1;
        for (DRowModel row : this.rows) {
            int rowIndex = index++;
            row.compiledOutputs = row.outputs.stream().map(expr -> this.compileFeelExpression((DMNElement)this.dt, this.feel, feelctx, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_RULE_IDX, compilationCache, (String)expr, rowIndex)).collect(Collectors.toList());
        }
    }

    private CompiledFEELExpression compileFeelExpression(DMNElement element, DMNFEELHelper feel, CompilerContext feelctx, Msg.Message msg, Map<String, CompiledFEELExpression> compilationCache, String expr, int index) {
        return compilationCache.computeIfAbsent(expr, e -> e == null || e.isEmpty() ? ctx -> null : (CompiledFEELExpression)feel.compile(this.model, element, msg, this.dtName, (String)e, feelctx, index));
    }

    private void initOutputClauses(CompilerContext feelctx, Map<String, CompiledFEELExpression> compilationCache) {
        for (DOutputModel output : this.outputs) {
            output.outputValues = this.getOutputValuesTests(output);
            String defaultValue = output.outputClause.getDefaultOutputEntry() != null ? output.outputClause.getDefaultOutputEntry().getText() : null;
            if (defaultValue == null) continue;
            output.compiledDefault = this.compileFeelExpression((DMNElement)output.outputClause, this.feel, feelctx, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_OUTPUT_CLAUSE_IDX, compilationCache, defaultValue, 0);
        }
    }

    private List<UnaryTest> getOutputValuesTests(DOutputModel output) {
        String outputValuesText = Optional.ofNullable(output.outputClause.getOutputValues()).map(UnaryTests::getText).orElse(null);
        output.typeRef = DMNEvaluatorCompiler.inferTypeRef(this.model, this.dt, output.outputClause);
        if (outputValuesText != null) {
            return this.feel.evaluateUnaryTests(outputValuesText, this.variableTypes);
        }
        if (output.typeRef != this.model.getTypeRegistry().unknown() && output.typeRef.getAllowedValuesFEEL() != null) {
            return output.typeRef.getAllowedValuesFEEL();
        }
        return Collections.emptyList();
    }

    public Object defaultToOutput(EvaluationContext ctx) {
        if (this.outputs.size() == 1) {
            return this.outputs.get(0).compiledDefault.apply((Object)ctx);
        }
        return IntStream.range(0, this.outputs.size()).boxed().collect(Collectors.toMap(i -> this.outputs.get((int)i).getName(), i -> this.outputs.get((int)i).compiledDefault.apply((Object)ctx)));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDtName() {
        return this.dtName;
    }

    public Map<String, Type> getVariableTypes() {
        return this.variableTypes;
    }

    public List<DColumnModel> getColumns() {
        return this.columns;
    }

    public List<InputClause> getInputs() {
        return this.dt.getInput();
    }

    public List<DRowModel> getRows() {
        return this.rows;
    }

    public int getOutputSize() {
        return this.outputs.size();
    }

    public int getInputSize() {
        return this.columns.size();
    }

    public org.kie.dmn.feel.runtime.decisiontables.HitPolicy getHitPolicy() {
        return this.hitPolicy;
    }

    public DecisionTable asDecisionTable() {
        return this.dtable;
    }

    private static String getInputValuesText(InputClause inputClause) {
        return Optional.ofNullable(inputClause.getInputValues()).map(UnaryTests::getText).orElse(null);
    }

    private static class DecisionTableImpl
    implements DecisionTable {
        private final String name;
        private final List<DecisionTable.OutputClause> outputs;

        private DecisionTableImpl(String name, List<DOutputModel> outputs) {
            this.name = name;
            this.outputs = outputs.stream().map(DOutputModel::asOutputClause).collect(Collectors.toList());
        }

        public String getName() {
            return this.name;
        }

        public List<? extends DecisionTable.OutputClause> getOutputs() {
            return this.outputs;
        }
    }

    public static class DOutputModel {
        private final OutputClause outputClause;
        private List<UnaryTest> outputValues;
        private CompiledFEELExpression compiledDefault;
        private BaseDMNTypeImpl typeRef;

        DOutputModel(OutputClause outputClause) {
            this.outputClause = outputClause;
        }

        DecisionTable.OutputClause asOutputClause() {
            return new DecisionTable.OutputClause(){

                public String getName() {
                    return outputClause.getName();
                }

                public List<UnaryTest> getOutputValues() {
                    return outputValues;
                }

                public Type getType() {
                    return typeRef.getFeelType();
                }

                public boolean isCollection() {
                    return typeRef.isCollection();
                }
            };
        }

        public String getName() {
            return this.outputClause.getName();
        }
    }

    public static class DColumnModel {
        private final InputClause inputClause;
        private final String name;
        private final Type type;
        private List<UnaryTest> inputTests;
        private CompiledFEELExpression compiledInputClause;

        DColumnModel(InputClause inputClause) {
            this.inputClause = inputClause;
            LiteralExpression expr = inputClause.getInputExpression();
            this.name = expr.getText();
            this.type = BuiltInType.determineTypeFromName(expr.getTypeRef() != null ? expr.getTypeRef().getLocalPart() : null);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public FEELEvent validate(EvaluationContext ctx, Object parameter) {
            boolean satisfies;
            if (this.inputTests != null && !(satisfies = this.inputTests.stream().map(ut -> (Boolean)ut.apply((Object)ctx, parameter)).filter(Boolean::booleanValue).findAny().orElse(false).booleanValue())) {
                String values = DTableModel.getInputValuesText(this.inputClause);
                return new InvalidInputEvent(FEELEvent.Severity.ERROR, this.inputClause.getInputExpression() + "='" + parameter + "' does not match any of the valid values " + values + " for decision table '" + this.getName() + "'.", this.getName(), null, values);
            }
            return null;
        }

        public Object evaluate(EvaluationContext ctx) {
            return this.compiledInputClause.apply((Object)ctx);
        }
    }

    public static class DRowModel {
        private final List<String> inputs;
        private final List<String> outputs;
        private List<CompiledFEELExpression> compiledOutputs;

        DRowModel(DecisionRule dr) {
            this.inputs = dr.getInputEntry().stream().map(UnaryTests::getText).collect(Collectors.toList());
            this.outputs = dr.getOutputEntry().stream().map(LiteralExpression::getText).collect(Collectors.toList());
        }

        public List<String> getInputs() {
            return this.inputs;
        }

        public Object evaluate(EvaluationContext ctx, int pos) {
            return this.compiledOutputs.get(pos).apply((Object)ctx);
        }
    }
}

