/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelWriter;
import org.kie.api.builder.Message;
import org.kie.internal.builder.KnowledgeBuilder;

public class CanonicalModelKieProject
extends KieModuleKieProject {
    private final boolean isPattern;
    protected List<ModelBuilderImpl> modelBuilders = new ArrayList<ModelBuilderImpl>();

    public static BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> create(boolean isPattern) {
        return (internalKieModule, classLoader) -> new CanonicalModelKieProject(isPattern, (InternalKieModule)internalKieModule, (ClassLoader)classLoader);
    }

    public CanonicalModelKieProject(boolean isPattern, InternalKieModule kieModule, ClassLoader classLoader) {
        super((InternalKieModule)(kieModule instanceof CanonicalKieModule ? kieModule : new CanonicalKieModule(kieModule)), classLoader);
        this.isPattern = isPattern;
    }

    protected KnowledgeBuilder createKnowledgeBuilder(KieBaseModelImpl kBaseModel, InternalKieModule kModule) {
        ModelBuilderImpl modelBuilder = new ModelBuilderImpl(this.getBuilderConfiguration(kBaseModel, kModule), this.isPattern);
        this.modelBuilders.add(modelBuilder);
        return modelBuilder;
    }

    public void writeProjectOutput(MemoryFileSystem trgMfs, ResultsImpl messages) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        ModelWriter modelWriter = new ModelWriter();
        ArrayList<String> modelFiles = new ArrayList<String>();
        for (ModelBuilderImpl modelBuilder : this.modelBuilders) {
            ModelWriter.Result result = modelWriter.writeModel(srcMfs, modelBuilder.getPackageModels());
            modelFiles.addAll(result.getModelFiles());
            String[] sources = result.getSources();
            if (sources.length == 0) continue;
            CompilationResult res = JavaParserCompiler.getCompiler().compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClassLoader());
            Stream.of(res.getErrors()).collect(Collectors.groupingBy(CompilationProblem::getFileName)).forEach((name, errors) -> {
                errors.forEach(arg_0 -> ((ResultsImpl)messages).addMessage(arg_0));
                File srcFile = srcMfs.getFile(name);
                if (srcFile instanceof MemoryFile) {
                    String src = new String(srcMfs.getFileContents((MemoryFile)srcFile));
                    messages.addMessage(Message.Level.ERROR, name, "Java source of " + name + " in error:\n" + src);
                }
            });
            for (CompilationProblem problem : res.getWarnings()) {
                messages.addMessage(problem);
            }
        }
        modelWriter.writeModelFile(modelFiles, trgMfs);
    }
}

