/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.execmodelbased.DTableModel;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.execmodelbased.JavaParserSourceGenerator;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledCustomFEELFunction;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSemanticMappings;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSupport;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeelExpressionSourceGenerator
implements ExecModelDMNEvaluatorCompiler.SourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(FeelExpressionSourceGenerator.class);
    static final String INPUT_CLAUSE_NAMESPACE = "InputClause";
    static final String FEEL_EXPRESSION_ARRAY_NAME = "FEEL_EXPRESSION_ARRAY";
    static final String OUTPUT_NAME = "Output";
    private Class<?> COMPILED_FEEL_EXPRESSION_TYPE = CompiledFEELExpression.class;
    private JavaParserSourceGenerator sourceGenerator;

    @Override
    public String generate(DMNCompilerContext ctx, DMNFEELHelper feel, DTableModel dTableModel) {
        String pkgName = dTableModel.getNamespace();
        String dTableName = dTableModel.getTableName();
        this.sourceGenerator = new JavaParserSourceGenerator(dTableName, ExecModelDMNEvaluatorCompiler.GeneratorsEnum.FEEL_EXPRESSION.type, pkgName);
        this.sourceGenerator.addImports(CompiledCustomFEELFunction.class, CompiledFEELExpression.class, CompiledFEELSupport.class, EvaluationContext.class, CompiledFEELExpression.class);
        this.sourceGenerator.addStaticImportStar(CompiledFEELSemanticMappings.class);
        this.generateInitRows(ctx, dTableModel, dTableName);
        this.generateInputClauses(ctx, dTableModel);
        this.generateOutputClauses(ctx, dTableModel);
        String source = this.sourceGenerator.getSource();
        if (logger.isDebugEnabled()) {
            logger.debug(dTableName + ":\n" + source);
        }
        return source;
    }

    private void generateOutputClauses(DMNCompilerContext ctx, DTableModel dTableModel) {
        Map<String, ClassOrInterfaceDeclaration> classOrInterfaceDeclarations = dTableModel.generateOutputClauses(ctx.toCompilerContext());
        for (Map.Entry<String, ClassOrInterfaceDeclaration> output : classOrInterfaceDeclarations.entrySet()) {
            String className = FeelExpressionSourceGenerator.getOutputName(output.getKey());
            this.sourceGenerator.addInnerClassWithName(output.getValue(), className);
            this.sourceGenerator.addField(className, this.COMPILED_FEEL_EXPRESSION_TYPE, FeelExpressionSourceGenerator.instanceName(className));
        }
    }

    public static String getOutputName(String key) {
        return CodegenStringUtil.escapeIdentifier((String)(OUTPUT_NAME + key));
    }

    private void generateInitRows(DMNCompilerContext ctx, DTableModel dTableModel, String className) {
        ClassOrInterfaceDeclaration[][] rows = dTableModel.generateRows(ctx.toCompilerContext());
        ArrayList<List<String>> arrayInitializer = new ArrayList<List<String>>();
        for (int i = 0; i < rows.length; ++i) {
            ClassOrInterfaceDeclaration[] columns = rows[i];
            ArrayList<String> arrayInitializerInner = new ArrayList<String>();
            for (int j = 0; j < columns.length; ++j) {
                String testClass = className + "r" + i + "c" + j + "expression";
                String instanceName = FeelExpressionSourceGenerator.instanceName(testClass);
                this.sourceGenerator.addField(testClass, this.COMPILED_FEEL_EXPRESSION_TYPE, instanceName);
                this.sourceGenerator.addInnerClassWithName(columns[j], testClass);
                arrayInitializerInner.add(instanceName);
            }
            arrayInitializer.add(new ArrayList(arrayInitializerInner));
        }
        this.sourceGenerator.addTwoDimensionalArray(arrayInitializer, FEEL_EXPRESSION_ARRAY_NAME, this.COMPILED_FEEL_EXPRESSION_TYPE);
    }

    private void generateInputClauses(DMNCompilerContext ctx, DTableModel dTableModel) {
        List<ClassOrInterfaceDeclaration> inputClauses = dTableModel.generateInputClauses(ctx.toCompilerContext());
        for (int i = 0; i < inputClauses.size(); ++i) {
            String testClass = INPUT_CLAUSE_NAMESPACE + i;
            this.sourceGenerator.addField(testClass, this.COMPILED_FEEL_EXPRESSION_TYPE, FeelExpressionSourceGenerator.instanceName(testClass));
            this.sourceGenerator.addInnerClassWithName(inputClauses.get(i), testClass);
        }
    }

    public static String instanceName(String testClass) {
        return testClass + "_INSTANCE";
    }
}

