/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.List;

public class JavaParserSourceGenerator {
    private ClassOrInterfaceDeclaration firstClass;
    private CompilationUnit compilationUnit;
    public static NodeList<Modifier> PUBLIC_STATIC_FINAL = NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier(), Modifier.finalModifier()});

    public JavaParserSourceGenerator(String className, String namespace, String packageName) {
        this.compilationUnit = StaticJavaParser.parse((String)("public class " + className + namespace + "{ }"));
        this.compilationUnit.setPackageDeclaration(packageName);
        this.firstClass = (ClassOrInterfaceDeclaration)this.compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new RuntimeException("Cannot find Class"));
    }

    public void addImports(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.compilationUnit.addImport(clazz);
        }
    }

    public void addStaticImportStar(Class<?> clazz) {
        this.compilationUnit.addImport(clazz.getName(), true, true);
    }

    public void addInnerClassWithName(ClassOrInterfaceDeclaration feelExpressionSource, String name) {
        this.renameFeelExpressionClass(name, feelExpressionSource);
        this.firstClass.addMember((BodyDeclaration)feelExpressionSource);
    }

    public void addMember(FieldDeclaration feelExpressionSource) {
        this.firstClass.addMember((BodyDeclaration)feelExpressionSource);
    }

    public void addField(String testClass, Class<?> type, String instanceName) {
        ClassOrInterfaceType innerClassType = this.getType(testClass);
        ObjectCreationExpr newInstanceOfInnerClass = new ObjectCreationExpr(null, innerClassType, NodeList.nodeList((Node[])new Expression[0]));
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)this.getType(type), instanceName, (Expression)newInstanceOfInnerClass);
        this.firstClass.addMember((BodyDeclaration)new FieldDeclaration(PUBLIC_STATIC_FINAL, variableDeclarator));
    }

    public void addTwoDimensionalArray(List<List<String>> initializers, String arrayName, Class<?> type) {
        NodeList arrayCreationLevels = NodeList.nodeList((Node[])new ArrayCreationLevel[]{new ArrayCreationLevel(), new ArrayCreationLevel()});
        NodeList arrayInitializers = NodeList.nodeList((Node[])new Expression[0]);
        for (List<String> innerInitializer : initializers) {
            NodeList arrayInitializerInner = NodeList.nodeList((Node[])new Expression[0]);
            for (String instanceName : innerInitializer) {
                arrayInitializerInner.add((Node)new NameExpr(instanceName));
            }
            arrayInitializers.add((Node)new ArrayInitializerExpr(arrayInitializerInner));
        }
        ArrayInitializerExpr initializerMainArray = new ArrayInitializerExpr(arrayInitializers);
        ArrayCreationExpr arrayCreationExpr = new ArrayCreationExpr((Type)this.getType(type), arrayCreationLevels, initializerMainArray);
        VariableDeclarator variable = new VariableDeclarator((Type)new ArrayType((Type)new ArrayType((Type)this.getType(type), new AnnotationExpr[0]), new AnnotationExpr[0]), arrayName, (Expression)arrayCreationExpr);
        this.addMember(new FieldDeclaration(PUBLIC_STATIC_FINAL, variable));
    }

    private ClassOrInterfaceType getType(String canonicalName) {
        return StaticJavaParser.parseClassOrInterfaceType((String)canonicalName);
    }

    private ClassOrInterfaceType getType(Class<?> clazz) {
        return StaticJavaParser.parseClassOrInterfaceType((String)clazz.getCanonicalName());
    }

    private void renameFeelExpressionClass(String testClass, ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        String finalTestClass = testClass;
        classOrInterfaceDeclaration.setName(finalTestClass);
        classOrInterfaceDeclaration.findAll(ConstructorDeclaration.class).forEach(n -> n.replace((Node)new ConstructorDeclaration(finalTestClass)));
    }

    public String getSource() {
        return this.compilationUnit.toString();
    }
}

