/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.pmml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Interval;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Value;
import org.jpmml.model.PMMLUtil;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.pmml.DMNPMMLModelInfo;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.api.Import;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNImportPMMLInfo
extends PMMLInfo<DMNPMMLModelInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(DMNImportPMMLInfo.class);
    private final Import i;

    public DMNImportPMMLInfo(Import i, Collection<DMNPMMLModelInfo> models, PMMLInfo.PMMLHeaderInfo h) {
        super(models, h);
        this.i = i;
    }

    public static Either<Exception, DMNImportPMMLInfo> from(InputStream is, DMNCompilerConfigurationImpl cc, DMNModelImpl model, Import i) {
        try {
            PMML pmml = PMMLUtil.unmarshal((InputStream)is);
            PMMLInfo.PMMLHeaderInfo h = PMMLInfo.pmmlToHeaderInfo(pmml, pmml.getHeader());
            for (DataField df : pmml.getDataDictionary().getDataFields()) {
                String dfName = df.getName().getValue();
                BuiltInType ft = null;
                switch (df.getDataType()) {
                    case BOOLEAN: {
                        ft = BuiltInType.BOOLEAN;
                        break;
                    }
                    case DATE: {
                        ft = BuiltInType.DATE;
                        break;
                    }
                    case DATE_TIME: {
                        ft = BuiltInType.DATE_TIME;
                        break;
                    }
                    case DOUBLE: 
                    case FLOAT: 
                    case INTEGER: {
                        ft = BuiltInType.NUMBER;
                        break;
                    }
                    case STRING: {
                        ft = BuiltInType.STRING;
                        break;
                    }
                    case TIME: {
                        ft = BuiltInType.TIME;
                        break;
                    }
                    default: {
                        ft = BuiltInType.UNKNOWN;
                    }
                }
                List<FEELProfile> helperFEELProfiles = cc.getFeelProfiles();
                DMNFEELHelper feel = new DMNFEELHelper(cc.getRootClassLoader(), helperFEELProfiles);
                List<UnaryTest> av = new ArrayList<UnaryTest>();
                if (df.getValues() != null && !df.getValues().isEmpty() && ft != BuiltInType.UNKNOWN) {
                    BuiltInType feelType = ft;
                    String lov = df.getValues().stream().map(Value::getValue).map(o -> feelType == BuiltInType.STRING ? "\"" + o.toString() + "\"" : o.toString()).collect(Collectors.joining(","));
                    av = feel.evaluateUnaryTests(lov, Collections.emptyMap());
                } else if (df.getIntervals() != null && !df.getIntervals().isEmpty() && ft != BuiltInType.UNKNOWN) {
                    for (Interval interval : df.getIntervals()) {
                        String utString = null;
                        switch (interval.getClosure()) {
                            case CLOSED_CLOSED: {
                                utString = "[" + interval.getLeftMargin() + ".." + interval.getRightMargin() + "]";
                                break;
                            }
                            case CLOSED_OPEN: {
                                utString = "[" + interval.getLeftMargin() + ".." + interval.getRightMargin() + ")";
                                break;
                            }
                            case OPEN_CLOSED: {
                                utString = "(" + interval.getLeftMargin() + ".." + interval.getRightMargin() + "]";
                                break;
                            }
                            case OPEN_OPEN: {
                                utString = "(" + interval.getLeftMargin() + ".." + interval.getRightMargin() + ")";
                            }
                        }
                        List<UnaryTest> ut = feel.evaluateUnaryTests(utString, Collections.emptyMap());
                        av.addAll(ut);
                    }
                }
                SimpleTypeImpl type = new SimpleTypeImpl(i.getNamespace(), dfName, null, false, av, null, (Type)ft);
                model.getTypeRegistry().registerType(type);
            }
            List<DMNPMMLModelInfo> models = pmml.getModels().stream().map(m -> PMMLInfo.pmmlToModelInfo(m)).map(proto -> DMNPMMLModelInfo.from(proto, model, i)).collect(Collectors.toList());
            DMNImportPMMLInfo info = new DMNImportPMMLInfo(i, models, h);
            return Either.ofRight((Object)info);
        }
        catch (Throwable e) {
            return Either.ofLeft((Object)new Exception("Unable to process DMNImportPMMLInfo", e));
        }
    }

    public String getImportName() {
        return this.i.getName();
    }
}

