/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;

public class EventNodeInstance
extends ExtendedNodeInstanceImpl
implements EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    protected static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{([\\S&&[^\\}]]+)\\}", 32);
    private static final long serialVersionUID = 510L;

    @Override
    public void signalEvent(String type, Object event) {
        String variableName = this.getEventNode().getVariableName();
        if (variableName != null) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
            if (variableScopeInstance == null) {
                throw new IllegalArgumentException("Could not find variable for event node: " + variableName);
            }
            EventTransformer transformer = this.getEventNode().getEventTransformer();
            if (transformer != null) {
                event = transformer.transformEvent(event);
            }
            variableScopeInstance.setVariable(variableName, event);
        }
        this.triggerCompleted();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An EventNode only accepts default incoming connections!");
        }
        this.addEventListeners();
    }

    public EventNode getEventNode() {
        return (EventNode)this.getNode();
    }

    public void triggerCompleted() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void cancel() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        String eventType = this.getEventType();
        if (this.isVariableExpression(this.getEventNode().getType())) {
            this.getProcessInstance().addEventListener(eventType, new VariableExternalEventListener(eventType), true);
        } else {
            this.getProcessInstance().addEventListener(eventType, this.getEventListener(), true);
        }
    }

    @Override
    public void removeEventListeners() {
    }

    public String getEventType() {
        return this.resolveVariable(this.getEventNode().getType());
    }

    protected EventListener getEventListener() {
        return DummyEventListener.EMPTY_EVENT_LISTENER;
    }

    private boolean isVariableExpression(String eventType) {
        if (eventType == null) {
            return false;
        }
        Matcher matcher = PARAMETER_MATCHER.matcher(eventType);
        return matcher.find();
    }

    private String resolveVariable(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            VariableScopeInstance variableScopeInstance;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null || (variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName)) == null) continue;
            Object variableValue = variableScopeInstance.getVariable(paramName);
            String variableValueString = variableValue == null ? "" : variableValue.toString();
            replacements.put(paramName, variableValueString);
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    private void callSignal(String type, Object event) {
        this.signalEvent(type, event);
    }

    private class VariableExternalEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 5L;
        private String eventType;

        VariableExternalEventListener(String eventType) {
            this.eventType = eventType;
        }

        public String[] getEventTypes() {
            return new String[]{this.eventType};
        }

        public void signalEvent(String type, Object event) {
            EventNodeInstance.this.callSignal(type, event);
        }
    }
}

