/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.Trait;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitProxyClassBuilderImpl
implements TraitProxyClassBuilder {
    private ClassDefinition trait;
    private String wrapperName;
    private String proxyName;
    private String pack;

    @Override
    public void init(ClassDefinition trait) {
        this.trait = trait;
        this.pack = trait.getDefinedClass().getPackage().toString();
    }

    @Override
    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(0);
        long mask = TraitRegistry.getInstance().getFieldMask(this.trait.getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.trait, core);
        String masterName = TraitFactory.getProxyName(this.trait, core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String internalProxy = BuildUtils.getInternalType(masterName);
        String descrWrapper = BuildUtils.getTypeDescriptor(name);
        String descrProxy = BuildUtils.getTypeDescriptor(masterName);
        String internalCore = BuildUtils.getInternalType(core.getClassName());
        String descrCore = BuildUtils.getTypeDescriptor(core.getClassName());
        String internalTrait = BuildUtils.getInternalType(this.trait.getClassName());
        String descrTrait = BuildUtils.getTypeDescriptor(this.trait.getClassName());
        Class mixinClass = null;
        String mixin = null;
        HashSet<Method> mixinMethods = new HashSet<Method>();
        HashMap<String, Method> mixinGetSet = new HashMap<String, Method>();
        try {
            Trait annTrait;
            if (this.trait.getDefinedClass() != null && (annTrait = this.trait.getDefinedClass().getAnnotation(Trait.class)) != null && !annTrait.impl().equals(Trait.NullMixin.class)) {
                mixinClass = annTrait.impl();
                mixin = mixinClass.getSimpleName().substring(0, 1).toLowerCase() + mixinClass.getSimpleName().substring(1);
                ClassFieldInspector cfi = new ClassFieldInspector(mixinClass);
                for (Method m : mixinClass.getMethods()) {
                    try {
                        this.trait.getDefinedClass().getMethod(m.getName(), m.getParameterTypes());
                        if (cfi.getGetterMethods().containsValue(m) || cfi.getSetterMethods().containsValue(m)) {
                            mixinGetSet.put(m.getName(), m);
                            continue;
                        }
                        mixinMethods.add(m);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cw.visit(49, 33, internalProxy, null, "org/drools/factmodel/traits/TraitProxy", new String[]{internalTrait});
        FieldVisitor fv = cw.visitField(17, "object", descrCore, null, null);
        fv.visitEnd();
        fv = cw.visitField(17, "map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        fv.visitEnd();
        if (mixinClass != null) {
            fv = cw.visitField(2, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()), null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + descrCore + "Ljava/util/Map;)V", "(" + descrCore + "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TraitProxy", "<init>", "()V");
        if (mixinClass != null) {
            try {
                Constructor con = mixinClass.getConstructor(this.trait.getDefinedClass());
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, BuildUtils.getInternalType(mixinClass.getName()));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, BuildUtils.getInternalType(mixinClass.getName()), "<init>", "(" + BuildUtils.getTypeDescriptor(this.trait.getDefinedClass().getName()) + ")V");
                mv.visitFieldInsn(181, internalProxy, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()));
            }
            catch (NoSuchMethodException nsme) {
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, BuildUtils.getInternalType(mixinClass.getName()));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, BuildUtils.getInternalType(mixinClass.getName()), "<init>", "()V");
                mv.visitFieldInsn(181, internalProxy, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()));
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalProxy, "map", "Ljava/util/Map;");
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, internalWrapper);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, internalWrapper, "<init>", "(" + descrCore + "Ljava/util/Map;)V");
        mv.visitFieldInsn(181, internalProxy, "fields", "Ljava/util/Map;");
        mv.visitInsn(177);
        mv.visitMaxs(5, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getCore", "()" + descrCore + "", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getObject", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getCore", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getCore", "()" + descrCore + "");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        int j = 0;
        for (FieldDefinition field : this.trait.getFieldsDefinitions()) {
            boolean isSoftField;
            boolean bl = isSoftField = (mask & (long)(1 << j++)) == 0L;
            if (isSoftField) {
                if (mixinGetSet.containsKey(BuildUtils.getterName(field.getName(), field.getTypeName()))) continue;
                this.buildSoftGetter(cw, field.getName(), field.getTypeName(), masterName, core.getName());
                this.buildSoftSetter(cw, field.getName(), field.getTypeName(), masterName, core.getName());
                continue;
            }
            fv = cw.visitField(9, field.getName() + "_reader", "Lorg/drools/spi/InternalReadAccessor;", null, null);
            fv.visitEnd();
            fv = cw.visitField(9, field.getName() + "_writer", "Lorg/drools/spi/WriteAccessor;", null, null);
            fv.visitEnd();
            this.buildHardGetter(cw, field, masterName, this.trait, core);
            this.buildHardSetter(cw, field, masterName, this.trait, core);
        }
        this.buildEqualityMethods(cw, masterName, core.getClassName());
        if (mixinClass != null) {
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinMethods);
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinGetSet.values());
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void buildMixinMethods(ClassWriter cw, String wrapperName, String mixin, Class mixinClass, Collection<Method> mixinMethods) {
        for (Method method : mixinMethods) {
            String signature = TraitFactory.buildSignature(method);
            MethodVisitor mv = cw.visitMethod(1, method.getName(), signature, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapperName), mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()));
            int j = 1;
            for (Class<?> arg : method.getParameterTypes()) {
                mv.visitVarInsn(BuildUtils.varType(arg.getName()), j++);
            }
            mv.visitMethodInsn(182, BuildUtils.getInternalType(mixinClass.getName()), method.getName(), signature);
            mv.visitInsn(BuildUtils.returnType(method.getReturnType().getName()));
            int stack = TraitFactory.getStackSize(method);
            mv.visitMaxs(stack, stack);
            mv.visitEnd();
        }
    }

    private void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        String getter = BuildUtils.getterName(fieldName, fieldType);
        MethodVisitor mv = cw.visitMethod(1, getter, "()" + BuildUtils.getTypeDescriptor(fieldType), null, null);
        mv.visitCode();
        TraitFactory.invokeExtractor(mv, masterName, proxy, core, field);
        if (!BuildUtils.isPrimitive(fieldType)) {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(fieldType));
        }
        mv.visitInsn(BuildUtils.returnType(fieldType));
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        String setter = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        MethodVisitor mv = cw.visitMethod(1, BuildUtils.setterName(fieldName, fieldType), "(" + BuildUtils.getTypeDescriptor(fieldType) + ")V", null, null);
        mv.visitCode();
        TraitFactory.invokeInjector(mv, masterName, trait, core, field, false, 1);
        mv.visitInsn(177);
        mv.visitMaxs(2 + BuildUtils.sizeOf(fieldType), 1 + BuildUtils.sizeOf(fieldType));
        mv.visitEnd();
    }

    private void buildSoftSetter(ClassVisitor cw, String fieldName, String type, String proxy, String core) {
        String setter = BuildUtils.setterName(fieldName, type);
        MethodVisitor mv = cw.visitMethod(1, setter, "(" + BuildUtils.getTypeDescriptor(type) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "map", "Ljava/util/Map;");
        mv.visitLdcInsn(fieldName);
        mv.visitVarInsn(BuildUtils.varType(type), 1);
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.valueOf(mv, type);
        }
        mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(2 + BuildUtils.sizeOf(type), 1 + BuildUtils.sizeOf(type));
        mv.visitEnd();
    }

    private void buildSoftGetter(ClassVisitor cw, String fieldName, String type, String proxy, String core) {
        String getter = BuildUtils.getterName(fieldName, type);
        MethodVisitor mv = cw.visitMethod(1, getter, "()" + BuildUtils.getTypeDescriptor(type), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "map", "Ljava/util/Map;");
        mv.visitLdcInsn(fieldName);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        if (BuildUtils.isPrimitive(type)) {
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 1);
            Label l0 = new Label();
            mv.visitJumpInsn(198, l0);
            mv.visitVarInsn(25, 1);
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(type));
            TraitFactory.valueOf(mv, type);
            mv.visitLabel(l1);
            TraitFactory.promote(mv, type);
            mv.visitInsn(BuildUtils.returnType(type));
            mv.visitMaxs(2, 2);
        } else {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(type));
            mv.visitInsn(176);
            mv.visitMaxs(2, 1);
        }
        mv.visitEnd();
    }

    public void buildEqualityMethods(ClassVisitor cw, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        String coreType = BuildUtils.getTypeDescriptor(core);
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        Label l2 = new Label();
        mv.visitJumpInsn(154, l2);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "org/drools/factmodel/traits/TraitProxy");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()Ljava/util/Map;");
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/drools/factmodel/traits/TraitProxy", "getFields", "()Ljava/util/Map;");
        mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        mv.visitInsn(172);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyType, "object", coreType);
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mv.visitVarInsn(54, 1);
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(104);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyType, "map", "Ljava/util/Map;");
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mv.visitInsn(96);
        mv.visitVarInsn(54, 1);
        mv.visitLdcInsn(proxy);
        mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I");
        mv.visitVarInsn(21, 1);
        mv.visitInsn(104);
        mv.visitVarInsn(54, 1);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitLdcInsn("(@" + proxy + ") : ");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()Ljava/util/Map;");
        mv.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;");
        mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }
}

