/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.impl.ReaderInputStream;
import org.drools.io.internal.InternalResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderResource
extends BaseResource
implements InternalResource {
    private transient Reader reader;
    private String encoding;

    public ReaderResource(Reader reader) {
        this(reader, null);
    }

    public ReaderResource(Reader reader, String encoding) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        if (encoding == null && reader instanceof InputStreamReader) {
            this.encoding = ((InputStreamReader)reader).getEncoding();
        }
        this.reader = reader;
        this.encoding = encoding;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("reader cannot be resolved to URL");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.encoding != null) {
            return new ReaderInputStream(this.reader, this.encoding);
        }
        return new ReaderInputStream(this.reader);
    }

    @Override
    public long getLastModified() {
        throw new IllegalStateException("reader does have a modified date");
    }

    @Override
    public long getLastRead() {
        throw new IllegalStateException("reader does have a modified date");
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    public String toString() {
        return "[ReaderResource resource=" + this.reader + " encoding='" + this.encoding + "']";
    }
}

