/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.definition.KnowledgeDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.EntryPointDeclarationDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.rule.Namespaceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDescr
extends BaseDescr
implements Namespaceable,
KnowledgeDescr {
    private static final long serialVersionUID = 530L;
    private String namespace;
    private String documentation;
    private List<ImportDescr> imports = Collections.emptyList();
    private List<FunctionImportDescr> functionImports = Collections.emptyList();
    private List<AttributeDescr> attributes = Collections.emptyList();
    private List<GlobalDescr> globals = Collections.emptyList();
    private List<FunctionDescr> functions = Collections.emptyList();
    private List<RuleDescr> rules = Collections.emptyList();
    private List<TypeDeclarationDescr> typeDeclarations = Collections.emptyList();
    private Set<EntryPointDeclarationDescr> entryPointDeclarations = Collections.emptySet();

    public PackageDescr() {
    }

    public PackageDescr(String namespace) {
        this(namespace, "");
    }

    public PackageDescr(String namespace, String documentation) {
        this.namespace = namespace;
        this.documentation = documentation;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.namespace = in.readUTF();
        this.documentation = in.readUTF();
        this.imports = (List)in.readObject();
        this.functionImports = (List)in.readObject();
        this.attributes = (List)in.readObject();
        this.globals = (List)in.readObject();
        this.functions = (List)in.readObject();
        this.rules = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.namespace);
        out.writeUTF(this.documentation);
        out.writeObject(this.imports);
        out.writeObject(this.functionImports);
        out.writeObject(this.attributes);
        out.writeObject(this.globals);
        out.writeObject(this.functions);
        out.writeObject(this.rules);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.namespace == null ? "" : this.namespace;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addImport(ImportDescr importEntry) {
        if (this.imports == Collections.EMPTY_LIST) {
            this.imports = new ArrayList<ImportDescr>();
        }
        this.imports.add(importEntry);
    }

    public List<ImportDescr> getImports() {
        return this.imports;
    }

    public void addFunctionImport(FunctionImportDescr importFunction) {
        if (this.functionImports == Collections.EMPTY_LIST) {
            this.functionImports = new ArrayList<FunctionImportDescr>();
        }
        this.functionImports.add(importFunction);
    }

    public List<FunctionImportDescr> getFunctionImports() {
        return this.functionImports;
    }

    public void addGlobal(GlobalDescr global) {
        if (this.globals == Collections.EMPTY_LIST) {
            this.globals = new ArrayList<GlobalDescr>();
        }
        this.globals.add(global);
    }

    public List<GlobalDescr> getGlobals() {
        return this.globals;
    }

    public void addAttribute(AttributeDescr attribute) {
        if (this.attributes == Collections.EMPTY_LIST) {
            this.attributes = new ArrayList<AttributeDescr>();
        }
        this.attributes.add(attribute);
    }

    public List<AttributeDescr> getAttributes() {
        return this.attributes;
    }

    public AttributeDescr getAttribute(String name) {
        if (name != null) {
            for (AttributeDescr attr : this.attributes) {
                if (!name.equals(attr.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    public void addFunction(FunctionDescr function) {
        if (this.functions == Collections.EMPTY_LIST) {
            this.functions = new ArrayList<FunctionDescr>(1);
        }
        this.functions.add(function);
    }

    public List<FunctionDescr> getFunctions() {
        return this.functions;
    }

    public void addRule(RuleDescr rule) {
        if (this.rules == Collections.EMPTY_LIST) {
            this.rules = new ArrayList<RuleDescr>(1);
        }
        for (AttributeDescr at : this.attributes) {
            if (rule.getAttributes().containsKey(at.getName())) continue;
            rule.addAttribute(at);
        }
        this.rules.add(rule);
    }

    public List<RuleDescr> getRules() {
        return this.rules;
    }

    public void addTypeDeclaration(TypeDeclarationDescr declaration) {
        if (this.typeDeclarations == Collections.EMPTY_LIST) {
            this.typeDeclarations = new ArrayList<TypeDeclarationDescr>();
        }
        this.typeDeclarations.add(declaration);
    }

    public List<TypeDeclarationDescr> getTypeDeclarations() {
        return this.typeDeclarations;
    }

    public void addEntryPointDeclaration(EntryPointDeclarationDescr epDescr) {
        if (this.entryPointDeclarations == Collections.EMPTY_SET) {
            this.entryPointDeclarations = new HashSet<EntryPointDeclarationDescr>();
        }
        this.entryPointDeclarations.add(epDescr);
    }

    public Set<EntryPointDeclarationDescr> getEntryPointDeclarations() {
        return this.entryPointDeclarations;
    }
}

