/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.drools.compiler.ParserError;
import org.drools.lang.dsl.DSLMapLexer;
import org.drools.lang.dsl.DSLMapParser;
import org.drools.lang.dsl.DSLMapWalker;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLTokenizedMappingFile
extends DSLMappingFile {
    private static String nl = System.getProperty("line.separator");
    private static Pattern commentPat = Pattern.compile("^\\s*((#/?|//).*)?$");
    private static Pattern entryPat = Pattern.compile("^\\s*\\[.+$");
    private List<Integer> lineLengths;
    private Set<String> optionSet = new HashSet<String>();

    private String readFile(Reader reader) throws IOException {
        String line;
        this.lineLengths = new ArrayList<Integer>();
        this.lineLengths.add(null);
        LineNumberReader lnr = new LineNumberReader(reader);
        StringBuilder sb = new StringBuilder();
        int nlCount = 0;
        boolean inEntry = false;
        while ((line = lnr.readLine()) != null) {
            this.lineLengths.add(line.length());
            Matcher commentMat = commentPat.matcher(line);
            if (commentMat.matches()) {
                String[] options;
                if (inEntry) {
                    ++nlCount;
                } else {
                    sb.append('\n');
                }
                if (!"#/".equals(commentMat.group(2))) continue;
                for (String option : options = commentMat.group(1).substring(2).trim().split("\\s+")) {
                    this.optionSet.add(option);
                }
                continue;
            }
            if (entryPat.matcher(line).matches()) {
                if (inEntry) {
                    for (int i = 0; i < nlCount; ++i) {
                        sb.append('\n');
                    }
                }
                sb.append(line);
                nlCount = 1;
                inEntry = true;
                continue;
            }
            sb.append(' ').append(line);
            ++nlCount;
        }
        if (inEntry) {
            sb.append('\n');
        }
        lnr.close();
        return sb.toString();
    }

    @Override
    public boolean parseAndLoad(Reader dsl) throws IOException {
        ArrayList<ParserError> errors = new ArrayList<ParserError>();
        String text = this.readFile(dsl);
        dsl = new StringReader(text);
        try {
            DSLMapping mapping = this.buildFileMapping(errors, dsl);
            mapping.setOptions(this.optionSet);
            this.setMapping(mapping);
            ArrayList<ParserError> moderr = new ArrayList<ParserError>();
            for (ParserError err : errors) {
                int row = err.getRow();
                int col = err.getCol();
                if (row > 0) {
                    int len;
                    while ((len = this.lineLengths.get(row).intValue()) < col) {
                        col -= len + 1;
                        ++row;
                    }
                }
                moderr.add(new ParserError(err.getMessage(), row, col));
            }
            errors = moderr;
        }
        catch (Exception e) {
            String msg = "Error parsing DSL mapping: " + e.getMessage();
            ParserError parserError = new ParserError(msg, -1, 0);
            errors.add(parserError);
        }
        this.setErrors(errors);
        return errors.isEmpty();
    }

    private DSLMapping buildFileMapping(List<ParserError> errors, Reader dsl) throws IOException, RecognitionException {
        ANTLRReaderStream reader = new ANTLRReaderStream(dsl);
        DSLMapWalker walker = this.buildFileMappingWalker(errors, reader);
        DSLMapping mapping = walker.mapping_file();
        return mapping;
    }

    private DSLMapWalker buildFileMappingWalker(List<ParserError> errors, CharStream stream) throws RecognitionException {
        DSLMapLexer lexer = new DSLMapLexer(stream);
        CommonTokenStream tokens = new CommonTokenStream();
        tokens.setTokenSource(lexer);
        DSLMapParser parser = new DSLMapParser(tokens);
        DSLMapParser.mapping_file_return example = parser.mapping_file();
        CommonTree tree = (CommonTree)example.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(tree);
        DSLMapWalker walker = new DSLMapWalker(nodes);
        errors.addAll(lexer.getErrors());
        errors.addAll(parser.getErrors());
        return walker;
    }
}

