/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.CategorisableItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;
import org.drools.repository.events.StorageEventManager;
import org.drools.repository.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetItem
extends CategorisableItem {
    private Logger log = LoggerFactory.getLogger(AssetItem.class);
    public static final String RULE_NODE_TYPE_NAME = "drools:assetNodeType";
    public static final String CONTENT_PROPERTY_NAME = "drools:content";
    public static final String CONTENT_PROPERTY_BINARY_NAME = "drools:binaryContent";
    public static final String CONTENT_PROPERTY_ATTACHMENT_FILENAME = "drools:attachmentFileName";
    public static final String DATE_EFFECTIVE_PROPERTY_NAME = "drools:dateEffective";
    public static final String DISABLED_PROPERTY_NAME = "drools:disabled";
    public static final String DATE_EXPIRED_PROPERTY_NAME = "drools:dateExpired";
    public static final String PACKAGE_NAME_PROPERTY = "drools:packageName";

    public AssetItem(RulesRepository rulesRepository, Node node) throws RulesRepositoryException {
        super(rulesRepository, node);
        try {
            if (!this.node.getPrimaryNodeType().getName().equals(RULE_NODE_TYPE_NAME) && !this.isHistoricalVersion()) {
                String message = this.node.getName() + " is not a node of type " + RULE_NODE_TYPE_NAME + " nor nt:version. It is a node of type: " + this.node.getPrimaryNodeType().getName();
                this.log.error(message);
                throw new RulesRepositoryException(message);
            }
        }
        catch (Exception e) {
            this.log.error("Caught exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem() {
        super(null, null);
    }

    public String getContent() throws RulesRepositoryException {
        return this.getContent(false);
    }

    public String getContent(Boolean fromRepo) throws RulesRepositoryException {
        try {
            if (StorageEventManager.hasLoadEvent() && !fromRepo.booleanValue()) {
                return IOUtils.toString(StorageEventManager.getLoadEvent().loadContent(this));
            }
            if (this.isBinary()) {
                return new String(this.getBinaryContentAsBytes());
            }
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_NAME);
                return data.getValue().getString();
            }
            return "";
        }
        catch (Exception e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public long getContentLength() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                return data.getLength();
            }
            if (ruleNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_NAME);
                return data.getLength();
            }
            return 0L;
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), e);
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isBinary() {
        try {
            Node ruleNode = this.getVersionContentNode();
            return ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME);
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), e);
            throw new RulesRepositoryException(e);
        }
    }

    public InputStream getBinaryContentAttachment() {
        try {
            if (StorageEventManager.hasLoadEvent()) {
                return StorageEventManager.getLoadEvent().loadContent(this);
            }
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                return data.getBinary().getStream();
            }
            if (ruleNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_NAME);
                return data.getBinary().getStream();
            }
            return null;
        }
        catch (Exception e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getBinaryContentAttachmentFileName() {
        return this.getStringProperty(CONTENT_PROPERTY_ATTACHMENT_FILENAME);
    }

    public byte[] getBinaryContentAsBytes() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (StorageEventManager.hasLoadEvent()) {
                return IOUtils.toByteArray(StorageEventManager.getLoadEvent().loadContent(this));
            }
            if (this.isBinary()) {
                int offset;
                Property data = ruleNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                InputStream in = data.getBinary().getStream();
                byte[] bytes = new byte[(int)data.getLength()];
                int numRead = 0;
                for (offset = 0; offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
                if (offset < bytes.length) {
                    throw new RulesRepositoryException("Could not completely read asset " + this.getName());
                }
                in.close();
                return bytes;
            }
            return this.getContent().getBytes();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public Calendar getDateEffective() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            Property dateEffectiveProperty = ruleNode.getProperty(DATE_EFFECTIVE_PROPERTY_NAME);
            return dateEffectiveProperty.getDate();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public boolean getDisabled() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            Property disabled = ruleNode.getProperty(DISABLED_PROPERTY_NAME);
            return disabled.getBoolean();
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDateEffective(Calendar newDateEffective) throws RulesRepositoryException {
        this.checkIsUpdateable();
        this.checkout();
        try {
            if (newDateEffective != null || this.node.hasProperty(DATE_EFFECTIVE_PROPERTY_NAME)) {
                this.node.setProperty(DATE_EFFECTIVE_PROPERTY_NAME, newDateEffective);
            }
        }
        catch (RepositoryException e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDisabled(boolean disabled) throws RulesRepositoryException {
        this.checkIsUpdateable();
        this.checkout();
        try {
            this.node.setProperty(DISABLED_PROPERTY_NAME, disabled);
        }
        catch (RepositoryException e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public Calendar getDateExpired() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            Property dateExpiredProperty = ruleNode.getProperty(DATE_EXPIRED_PROPERTY_NAME);
            return dateExpiredProperty.getDate();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateDateExpired(Calendar newDateExpired) throws RulesRepositoryException {
        this.checkout();
        try {
            if (newDateExpired != null || this.node.hasProperty(DATE_EXPIRED_PROPERTY_NAME)) {
                this.node.setProperty(DATE_EXPIRED_PROPERTY_NAME, newDateExpired);
            }
        }
        catch (Exception e) {
            this.log.error("Caught Exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem updateContent(String newRuleContent) throws RulesRepositoryException {
        this.checkout();
        try {
            if (this.isBinary()) {
                this.updateBinaryContentAttachment(new ByteArrayInputStream(newRuleContent.getBytes()));
            }
            this.node.setProperty(CONTENT_PROPERTY_NAME, newRuleContent);
            return this;
        }
        catch (RepositoryException e) {
            this.log.error("Unable to update the asset content", e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem updateBinaryContentAttachment(InputStream data) {
        this.checkout();
        try {
            Binary is = this.node.getSession().getValueFactory().createBinary(data);
            this.node.setProperty(CONTENT_PROPERTY_BINARY_NAME, is);
            return this;
        }
        catch (RepositoryException e) {
            this.log.error("Unable to update the assets binary content", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void updateBinaryContentAttachmentFileName(String name) {
        this.updateStringProperty(name, CONTENT_PROPERTY_ATTACHMENT_FILENAME);
    }

    public void updateUserProperty(String propertyName, String value) {
        if (propertyName.startsWith("drools:")) {
            throw new IllegalArgumentException("Can only set the pre defined fields using the appropriate methods.");
        }
        this.updateStringProperty(value, propertyName);
    }

    public String toString() {
        try {
            StringBuilder returnString = new StringBuilder();
            returnString.append("Content of rule item named '").append(this.getName()).append("':\n");
            returnString.append("Content: ").append(this.getContent()).append("\n");
            returnString.append("------\n");
            returnString.append("Archived: ").append(this.isArchived()).append("\n");
            returnString.append("------\n");
            returnString.append("Version: ").append(this.getVersionNumber()).append("\n");
            returnString.append("------\n");
            returnString.append("Date Effective: ").append(this.getDateEffective()).append("\n");
            returnString.append("Date Expired: ").append(this.getDateExpired()).append("\n");
            returnString.append("------\n");
            returnString.append("Rule state: ");
            StateItem stateItem = this.getState();
            if (stateItem != null) {
                returnString.append(this.getState().getName()).append("\n");
            } else {
                returnString.append("NO STATE SET FOR THIS NODE\n");
            }
            returnString.append("------\n");
            returnString.append("Rule tags:\n");
            for (CategoryItem currentTag : this.getCategories()) {
                returnString.append(currentTag.getName()).append("\n");
            }
            returnString.append("--------------\n");
            return returnString.toString();
        }
        catch (Exception e) {
            throw new RulesRepositoryException(e);
        }
    }

    public VersionableItem getPrecedingVersion() throws RulesRepositoryException {
        try {
            Node precedingVersionNode = this.getPrecedingVersionNode();
            if (precedingVersionNode != null) {
                return new AssetItem(this.rulesRepository, precedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            this.log.error("Caught exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public VersionableItem getSucceedingVersion() throws RulesRepositoryException {
        try {
            Node succeedingVersionNode = this.getSucceedingVersionNode();
            if (succeedingVersionNode != null) {
                return new AssetItem(this.rulesRepository, succeedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            this.log.error("Caught exception", e);
            throw new RulesRepositoryException(e);
        }
    }

    public String getPackageName() {
        return super.getStringProperty(PACKAGE_NAME_PROPERTY);
    }

    public String getUserProperty(String property) {
        return this.getStringProperty(property);
    }

    public void remove() {
        if (StorageEventManager.hasSaveEvent()) {
            StorageEventManager.getSaveEvent().onAssetDelete(this);
        }
        this.checkIsUpdateable();
        if (this.getDateExpired() != null && Calendar.getInstance().before(this.getDateExpired())) {
            throw new RulesRepositoryException("Can't delete an item before its expiry date.");
        }
        try {
            this.node.remove();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetHistoryIterator getHistory() {
        if (this.isHistoricalVersion()) {
            Node frozenNode = this.getNode();
            try {
                Node headNode = frozenNode.getSession().getNodeByIdentifier(frozenNode.getProperty("jcr:frozenUuid").getString());
                return new AssetHistoryIterator(this.rulesRepository, headNode);
            }
            catch (RepositoryException e) {
                throw new RulesRepositoryException(e);
            }
        }
        return new AssetHistoryIterator(this.rulesRepository, this.node);
    }

    public PackageItem getPackage() {
        try {
            if (this.isHistoricalVersion()) {
                return this.rulesRepository.loadPackage(this.getPackageName());
            }
            return new PackageItem(this.rulesRepository, this.node.getParent().getParent());
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public static String[] getAssetNameFromFileName(String fileName) {
        String[] r = new String[]{"", ""};
        if (!fileName.contains(".")) {
            r[0] = fileName;
        } else if (fileName.endsWith(".bpel.jar")) {
            r[0] = fileName.substring(0, fileName.lastIndexOf(".bpel.jar"));
            r[1] = "bpel.jar";
        } else if (fileName.endsWith(".model.drl")) {
            r[0] = fileName.substring(0, fileName.lastIndexOf(".model.drl"));
            r[1] = "model.drl";
        } else {
            r[0] = fileName.substring(0, fileName.lastIndexOf("."));
            r[1] = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return r;
    }

    protected String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }
}

