/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.concurrent.AssertObject;
import org.drools.concurrent.AssertObjects;
import org.drools.concurrent.ExecutorService;
import org.drools.concurrent.FireAllRules;
import org.drools.concurrent.Future;
import org.drools.concurrent.RetractObject;
import org.drools.concurrent.UpdateObject;
import org.drools.impl.EnvironmentFactory;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerFactory;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.AgendaFilter;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.RuleBaseUpdateListener;
import org.drools.spi.RuleBaseUpdateListenerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteooStatefulSession
extends ReteooWorkingMemory
implements StatefulSession,
Externalizable {
    private static final long serialVersionUID = 510L;
    private transient ExecutorService executor;
    private transient List ruleBaseListeners;
    public byte[] bytes;

    public ReteooStatefulSession() {
    }

    public ReteooStatefulSession(int id, InternalRuleBase ruleBase, ExecutorService executorService) {
        this(id, ruleBase, executorService, SessionConfiguration.getDefaultInstance(), EnvironmentFactory.newEnvironment());
    }

    public ReteooStatefulSession(int id, InternalRuleBase ruleBase, ExecutorService executorService, SessionConfiguration config, Environment environment) {
        super(id, ruleBase, config, environment);
        this.executor = executorService;
    }

    public ReteooStatefulSession(int id, InternalRuleBase ruleBase, ExecutorService executorService, FactHandleFactory handleFactory, InternalFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        super(id, ruleBase, handleFactory, initialFactHandle, propagationContext, config, agenda, environment);
        this.executor = executorService;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((Object)this.getKnowledgeRuntime());
        Marshaller marshaller = MarshallerFactory.newMarshaller(ksession.getKnowledgeBase(), new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()});
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        marshaller.marshall(stream, (StatefulKnowledgeSession)((Object)this.getKnowledgeRuntime()));
        stream.close();
        byte[] bytes = stream.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
    }

    @Override
    public Future asyncInsert(Object object) {
        AssertObject assertObject = new AssertObject(object);
        this.executor.submit(assertObject);
        return assertObject;
    }

    @Override
    public Future asyncRetract(FactHandle factHandle) {
        return this.executor.submit(new RetractObject(factHandle));
    }

    @Override
    public Future asyncUpdate(FactHandle factHandle, Object object) {
        return this.executor.submit(new UpdateObject(factHandle, object));
    }

    @Override
    public Future asyncInsert(Object[] array) {
        AssertObjects assertObjects = new AssertObjects(array);
        this.executor.submit(assertObjects);
        return assertObjects;
    }

    @Override
    public Future asyncInsert(Collection collection) {
        AssertObjects assertObjects = new AssertObjects(collection);
        this.executor.submit(assertObjects);
        return assertObjects;
    }

    public Future asyncInsert(Iterable<?> iterable) {
        AssertObjects assertObjects = new AssertObjects(iterable);
        this.executor.submit(assertObjects);
        return assertObjects;
    }

    @Override
    public Future asyncFireAllRules(AgendaFilter agendaFilter) {
        FireAllRules fireAllRules = new FireAllRules(agendaFilter);
        this.executor.submit(fireAllRules);
        return fireAllRules;
    }

    @Override
    public Future asyncFireAllRules() {
        FireAllRules fireAllRules = new FireAllRules(null);
        this.executor.submit(fireAllRules);
        return fireAllRules;
    }

    @Override
    public void dispose() {
        this.ruleBase.disposeStatefulSession(this);
        super.dispose();
        this.executor.shutDown();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    @Override
    public List getRuleBaseUpdateListeners() {
        if (this.ruleBaseListeners == null || this.ruleBaseListeners == Collections.EMPTY_LIST) {
            String listenerName = this.ruleBase.getConfiguration().getRuleBaseUpdateHandler();
            if (listenerName != null && listenerName.length() > 0) {
                RuleBaseUpdateListener listener = RuleBaseUpdateListenerFactory.createListener(listenerName, this);
                this.ruleBaseListeners = Collections.singletonList(listener);
            } else {
                this.ruleBaseListeners = Collections.EMPTY_LIST;
            }
        }
        return this.ruleBaseListeners;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }
}

