/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.RightTuple;
import org.drools.spi.PropagationContext;

public class SingleLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    protected LeftTupleSink sink;

    public SingleLeftTupleSinkAdapter() {
        this(RuleBasePartitionId.MAIN_PARTITION, null);
    }

    public SingleLeftTupleSinkAdapter(RuleBasePartitionId partitionId, LeftTupleSink sink) {
        super(partitionId);
        this.sink = sink;
    }

    public void createChildLeftTuplesforQuery(LeftTuple leftTuple, RightTuple rightTuple, boolean leftTupleMemoryEnabled, boolean linkRightTuple) {
        LeftTuple child = this.sink.createLeftTuple(leftTuple, rightTuple, this.sink);
    }

    public void modifyChildLeftTuplesforQuery(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple childLeftTuple = rightTuple.firstChild;
        childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
    }

    public void propagateAssertLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, this.sink.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, this.sink, leftTupleMemoryEnabled));
    }

    public void propagateAssertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        this.doPropagateAssertLeftTuple(context, workingMemory, this.sink.createLeftTuple(tuple, this.sink, leftTupleMemoryEnabled));
    }

    public void propagateRetractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    public void propagateRetractLeftTupleDestroyRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    public void propagateRetractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = rightTuple.firstChild;
        while (child != null) {
            LeftTuple temp = child.getRightParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = temp;
        }
    }

    public void createAndPropagateAssertLeftTuple(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled, LeftInputAdapterNode liaNode) {
        this.doPropagateAssertLeftTuple(context, workingMemory, this.sink.createLeftTuple(factHandle, this.sink, leftTupleMemoryEnabled));
    }

    public BaseNode getMatchingNode(BaseNode candidate) {
        if (candidate.equals(this.sink)) {
            return (BaseNode)((Object)this.sink);
        }
        return null;
    }

    public LeftTupleSink[] getSinks() {
        return new LeftTupleSink[]{this.sink};
    }

    public int size() {
        return this.sink != null ? 1 : 0;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (LeftTupleSink)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
    }

    public void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, LeftTupleSink sink) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    protected void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple newLeftTuple) {
        this.sink.assertLeftTuple(newLeftTuple, context, workingMemory);
    }

    protected void doPropagateModifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    protected void doPropagateRetractLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple child, LeftTupleSink tupleSink) {
        tupleSink.retractLeftTuple(child, context, workingMemory);
    }

    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.doPropagateModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
        childLeftTuple.reAddRight();
        return childLeftTuple.getLeftParentNext();
    }

    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
        childLeftTuple.reAddLeft();
        return childLeftTuple.getRightParentNext();
    }

    public void propagateModifyChildLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        leftTuple.getFirstChild().getLeftTupleSink().modifyLeftTuple(leftTuple.getFirstChild(), context, workingMemory);
    }

    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple temp = childLeftTuple.getLeftParentNext();
        this.doPropagateRetractLeftTuple(context, workingMemory, childLeftTuple, childLeftTuple.getLeftTupleSink());
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return temp;
    }

    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple temp = childLeftTuple.getRightParentNext();
        this.doPropagateRetractLeftTuple(context, workingMemory, childLeftTuple, childLeftTuple.getLeftTupleSink());
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return temp;
    }
}

