/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.asm;

import java.util.Arrays;
import java.util.Map;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.java.JavaRuleBuilderHelper;
import org.drools.spi.DeclarationScopeResolver;

public abstract class AbstractASMEvalBuilder
implements RuleConditionBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        EvalDescr evalDescr = (EvalDescr)descr;
        String className = "eval" + context.getNextId();
        evalDescr.setClassMethodName(className);
        Map<String, Declaration> decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        Dialect dialect = context.getDialect();
        Object object = evalDescr.getContent();
        context.getDeclarationResolver();
        AnalysisResult analysis = dialect.analyzeExpression(context, evalDescr, object, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses(decls), context.getPackageBuilder().getGlobals()));
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        Declaration[] declarations = decls.values().toArray(new Declaration[decls.size()]);
        Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
        EvalCondition eval = new EvalCondition(declarations);
        Map<String, Object> vars = JavaRuleBuilderHelper.createVariableContext(className, (String)evalDescr.getContent(), context, declarations, null, usedIdentifiers.getGlobals());
        JavaRuleBuilderHelper.generateMethodTemplate("evalMethod", context, vars);
        byte[] bytecode = this.createEvalBytecode(context, vars);
        JavaRuleBuilderHelper.registerInvokerBytecode(context, vars, bytecode, eval);
        return eval;
    }

    protected abstract byte[] createEvalBytecode(RuleBuildContext var1, Map var2);
}

