/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.core.cluster.NamespaceEventChannel;
import org.apache.jackrabbit.core.cluster.NamespaceEventListener;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceRegistryImpl
implements NamespaceRegistry,
NamespaceEventListener,
StringIndex {
    private static Logger log = LoggerFactory.getLogger(NamespaceRegistryImpl.class);
    private static final String EMPTY_KEY = ".empty.key";
    private static final String NS_REG_RESOURCE = "ns_reg.properties";
    private static final String NS_IDX_RESOURCE = "ns_idx.properties";
    private static final HashSet<String> reservedPrefixes = new HashSet();
    private static final HashSet<String> reservedURIs = new HashSet();
    private HashMap<String, String> prefixToURI = new HashMap();
    private HashMap<String, String> uriToPrefix = new HashMap();
    private HashMap<Integer, String> indexToURI = new HashMap();
    private HashMap<String, Integer> uriToIndex = new HashMap();
    private final FileSystem nsRegStore;
    private NamespaceEventChannel eventChannel;

    public NamespaceRegistryImpl(FileSystem fs) throws RepositoryException {
        this.nsRegStore = new BasedFileSystem(fs, "/namespaces");
        this.load();
    }

    private void clear() {
        this.prefixToURI.clear();
        this.uriToPrefix.clear();
        this.indexToURI.clear();
        this.uriToIndex.clear();
    }

    private void map(String prefix, String uri) {
        this.map(prefix, uri, null);
    }

    private void map(String prefix, String uri, Integer idx) {
        this.prefixToURI.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
        if (!this.uriToIndex.containsKey(uri)) {
            if (idx == null) {
                idx = uri.hashCode() & 0xFFFFFF;
                while (this.indexToURI.containsKey(idx)) {
                    idx = idx + 1 & 0xFFFFFF;
                }
            }
            this.indexToURI.put(idx, uri);
            this.uriToIndex.put(uri, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.nsRegStore, NS_REG_RESOURCE);
        FileSystemResource idxFile = new FileSystemResource(this.nsRegStore, NS_IDX_RESOURCE);
        try {
            InputStream in;
            if (!propFile.exists()) {
                this.clear();
                this.map("", "");
                this.map("rep", "internal");
                this.map("jcr", "http://www.jcp.org/jcr/1.0");
                this.map("nt", "http://www.jcp.org/jcr/nt/1.0");
                this.map("mix", "http://www.jcp.org/jcr/mix/1.0");
                this.map("sv", "http://www.jcp.org/jcr/sv/1.0");
                this.map("xml", "http://www.w3.org/XML/1998/namespace");
                this.store();
                return;
            }
            Properties indexes = new Properties();
            if (idxFile.exists()) {
                in = idxFile.getInputStream();
                try {
                    indexes.load(in);
                }
                finally {
                    in.close();
                }
            }
            in = propFile.getInputStream();
            try {
                Properties props = new Properties();
                props.load(in);
                this.clear();
                for (Object p : props.keySet()) {
                    String prefix = (String)p;
                    String uri = props.getProperty(prefix);
                    String idx = indexes.getProperty(this.escapePropertyKey(uri));
                    if (idx == null && uri.equals("")) {
                        idx = indexes.getProperty(uri);
                    }
                    if (idx != null) {
                        this.map(this.unescapePropertyKey(prefix), uri, Integer.decode(idx));
                        continue;
                    }
                    this.map(this.unescapePropertyKey(prefix), uri);
                }
            }
            finally {
                in.close();
            }
            if (!idxFile.exists()) {
                this.store();
            }
        }
        catch (Exception e) {
            String msg = "failed to load namespace registry";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.nsRegStore, NS_REG_RESOURCE);
        try {
            propFile.makeParentDirs();
            OutputStream os = propFile.getOutputStream();
            Properties props = new Properties();
            for (String prefix : this.prefixToURI.keySet()) {
                String uri = this.prefixToURI.get(prefix);
                props.setProperty(this.escapePropertyKey(prefix), uri);
            }
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to persist namespace registry";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        FileSystemResource indexFile = new FileSystemResource(this.nsRegStore, NS_IDX_RESOURCE);
        try {
            indexFile.makeParentDirs();
            OutputStream os = indexFile.getOutputStream();
            Properties props = new Properties();
            for (String uri : this.uriToIndex.keySet()) {
                String index = this.uriToIndex.get(uri).toString();
                props.setProperty(this.escapePropertyKey(uri), index);
            }
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to persist namespace registry index.";
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
    }

    private String escapePropertyKey(String key) {
        if (key.equals("")) {
            return EMPTY_KEY;
        }
        return key;
    }

    private String unescapePropertyKey(String key) {
        if (key.equals(EMPTY_KEY)) {
            return "";
        }
        return key;
    }

    public void setEventChannel(NamespaceEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    public int stringToIndex(String uri) {
        Integer idx = this.uriToIndex.get(uri);
        if (idx == null) {
            throw new IllegalArgumentException("Namespace not registered: " + uri);
        }
        return idx;
    }

    public String indexToString(int idx) {
        String uri = this.indexToURI.get(idx);
        if (uri == null) {
            throw new IllegalArgumentException("Invalid namespace index: " + idx);
        }
        return uri;
    }

    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("prefix/uri can not be null");
        }
        if ("".equals(prefix) || "".equals(uri)) {
            throw new NamespaceException("default namespace is reserved and can not be changed");
        }
        if (reservedURIs.contains(uri)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved URI");
        }
        if (reservedPrefixes.contains(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        if (!XMLChar.isValidNCName(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": invalid prefix");
        }
        String oldPrefix = this.uriToPrefix.get(uri);
        if (prefix.equals(oldPrefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": mapping already exists");
        }
        if (this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": remapping existing prefixes is not supported.");
        }
        if (oldPrefix != null) {
            this.prefixToURI.remove(oldPrefix);
            this.uriToPrefix.remove(uri);
        }
        this.map(prefix, uri);
        if (this.eventChannel != null) {
            this.eventChannel.remapped(oldPrefix, prefix, uri);
        }
        this.store();
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (reservedPrefixes.contains(prefix)) {
            throw new NamespaceException("reserved prefix: " + prefix);
        }
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException("unknown prefix: " + prefix);
        }
        throw new NamespaceException("unregistering namespaces is not supported.");
    }

    public String[] getPrefixes() throws RepositoryException {
        return this.prefixToURI.keySet().toArray(new String[this.prefixToURI.keySet().size()]);
    }

    public String[] getURIs() throws RepositoryException {
        return this.uriToPrefix.keySet().toArray(new String[this.uriToPrefix.keySet().size()]);
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = this.prefixToURI.get(prefix);
        if (uri == null) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return uri;
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.uriToPrefix.get(uri);
        if (prefix == null) {
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
        return prefix;
    }

    public void externalRemap(String oldPrefix, String newPrefix, String uri) throws RepositoryException {
        if (newPrefix == null) {
            throw new NamespaceException("unregistering namespaces is not supported.");
        }
        if (oldPrefix != null) {
            this.prefixToURI.remove(oldPrefix);
            this.uriToPrefix.remove(uri);
        }
        this.map(newPrefix, uri);
        this.store();
    }

    static {
        reservedPrefixes.add("xml");
        reservedPrefixes.add("xmlns");
        reservedPrefixes.add("rep");
        reservedPrefixes.add("jcr");
        reservedPrefixes.add("nt");
        reservedPrefixes.add("mix");
        reservedPrefixes.add("sv");
        reservedURIs.add("http://www.w3.org/XML/1998/namespace");
        reservedURIs.add("http://www.w3.org/2000/xmlns/");
        reservedURIs.add("internal");
        reservedURIs.add("http://www.jcp.org/jcr/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/nt/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/mix/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/sv/1.0");
    }
}

