/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipCache
implements UserConstants,
SynchronousEventListener,
SessionListener {
    private static final Logger log = LoggerFactory.getLogger(MembershipCache.class);
    private final SessionImpl systemSession;
    private final String groupsPath;
    private final boolean useMembersNode;
    private final String pMembers;
    private final Map<String, Collection<String>> cache;

    MembershipCache(SessionImpl systemSession, String groupsPath, boolean useMembersNode) throws RepositoryException {
        this.systemSession = systemSession;
        this.groupsPath = groupsPath == null ? "/rep:security/rep:authorizables/rep:groups" : groupsPath;
        this.useMembersNode = useMembersNode;
        this.pMembers = systemSession.getJCRName(UserManagerImpl.P_MEMBERS);
        this.cache = new GrowingLRUMap(1024, 5000);
        String[] ntNames = new String[]{systemSession.getJCRName(UserConstants.NT_REP_GROUP), systemSession.getJCRName(UserConstants.NT_REP_MEMBERS)};
        systemSession.getWorkspace().getObservationManager().addEventListener(this, 28, groupsPath, true, null, ntNames, false);
        systemSession.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(EventIterator eventIterator) {
        boolean clear = false;
        while (eventIterator.hasNext() && !clear) {
            Event ev = eventIterator.nextEvent();
            try {
                if (this.pMembers.equals(Text.getName(ev.getPath()))) {
                    clear = true;
                    continue;
                }
                if (!this.useMembersNode) continue;
                int type = ev.getType();
                if (type == 4 || type == 16) {
                    Property p = this.systemSession.getProperty(ev.getPath());
                    Name declNtName = ((NodeTypeImpl)p.getDefinition().getDeclaringNodeType()).getQName();
                    clear = NT_REP_MEMBERS.equals(declNtName);
                    continue;
                }
                String parentId = ev.getIdentifier();
                Node n = this.systemSession.getNodeByIdentifier(parentId);
                Name ntName = ((NodeTypeImpl)n.getPrimaryNodeType()).getQName();
                clear = UserConstants.NT_REP_MEMBERS.equals(ntName);
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
                clear = true;
            }
        }
        if (clear) {
            Map<String, Collection<String>> map = this.cache;
            synchronized (map) {
                this.cache.clear();
            }
        }
    }

    @Override
    public void loggingOut(SessionImpl session) {
        try {
            this.systemSession.getWorkspace().getObservationManager().removeEventListener(this);
        }
        catch (RepositoryException e) {
            log.error("Unexpected error: Failed to stop event listening of MembershipCache.", e);
        }
    }

    @Override
    public void loggedOut(SessionImpl session) {
    }

    synchronized Collection<String> getDeclaredMemberOf(String authorizableNodeIdentifier) throws RepositoryException {
        return this.declaredMemberOf(authorizableNodeIdentifier);
    }

    synchronized Collection<String> getMemberOf(String authorizableNodeIdentifier) throws RepositoryException {
        HashSet<String> groupNodeIds = new HashSet<String>();
        this.memberOf(authorizableNodeIdentifier, groupNodeIds);
        return Collections.unmodifiableCollection(groupNodeIds);
    }

    Collection<String> collectDeclaredMembership(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        Collection<String> groupNodeIds = this.collectDeclaredMembershipFromReferences(authorizableNodeIdentifier, session);
        if (groupNodeIds == null) {
            groupNodeIds = this.collectDeclaredMembershipFromTraversal(authorizableNodeIdentifier, session);
        }
        return groupNodeIds;
    }

    Collection<String> collectMembership(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        HashSet<String> groupNodeIds = new HashSet<String>();
        this.memberOf(authorizableNodeIdentifier, groupNodeIds, session);
        return groupNodeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> declaredMemberOf(String authorizableNodeIdentifier) throws RepositoryException {
        Collection<String> groupNodeIds = this.cache.get(authorizableNodeIdentifier);
        if (groupNodeIds == null) {
            SessionImpl session = this.getSession();
            try {
                groupNodeIds = this.collectDeclaredMembership(authorizableNodeIdentifier, session);
                this.cache.put(authorizableNodeIdentifier, Collections.unmodifiableCollection(groupNodeIds));
            }
            finally {
                if (session != this.systemSession) {
                    session.logout();
                }
            }
        }
        return groupNodeIds;
    }

    private void memberOf(String authorizableNodeIdentifier, Collection<String> groupNodeIds) throws RepositoryException {
        Collection<String> declared = this.declaredMemberOf(authorizableNodeIdentifier);
        for (String identifier : declared) {
            if (!groupNodeIds.add(identifier)) continue;
            this.memberOf(identifier, groupNodeIds);
        }
    }

    private void memberOf(String authorizableNodeIdentifier, Collection<String> groupNodeIds, Session session) throws RepositoryException {
        Collection<String> declared = this.collectDeclaredMembership(authorizableNodeIdentifier, session);
        for (String identifier : declared) {
            if (!groupNodeIds.add(identifier)) continue;
            this.memberOf(identifier, groupNodeIds, session);
        }
    }

    private Collection<String> collectDeclaredMembershipFromReferences(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        HashSet<String> pIds = new HashSet<String>();
        HashSet<String> nIds = new HashSet<String>();
        PropertyIterator refs = MembershipCache.getMembershipReferences(authorizableNodeIdentifier, session);
        if (refs == null) {
            return null;
        }
        while (refs.hasNext()) {
            try {
                HashSet<String> groupNodeIdentifiers;
                PropertyImpl pMember = (PropertyImpl)refs.nextProperty();
                NodeImpl nGroup = (NodeImpl)pMember.getParent();
                if (P_MEMBERS.equals(pMember.getQName())) {
                    groupNodeIdentifiers = pIds;
                } else {
                    groupNodeIdentifiers = nIds;
                    while (nGroup.isNodeType(NT_REP_MEMBERS)) {
                        nGroup = (NodeImpl)nGroup.getParent();
                    }
                }
                if (nGroup.isNodeType(NT_REP_GROUP)) {
                    groupNodeIdentifiers.add(nGroup.getIdentifier());
                    continue;
                }
                log.debug("Invalid member reference to '" + this + "' -> Not included in membership set.");
            }
            catch (ItemNotFoundException e) {
            }
            catch (AccessDeniedException e) {}
        }
        return this.select(pIds, nIds);
    }

    private Collection<String> collectDeclaredMembershipFromTraversal(final String authorizableNodeIdentifier, Session session) throws RepositoryException {
        final HashSet<String> pIds = new HashSet<String>();
        final HashSet<String> nIds = new HashSet<String>();
        log.info("Traversing groups tree to collect membership.");
        TraversingItemVisitor.Default visitor = new TraversingItemVisitor.Default(){

            protected void entering(Property property, int level) throws RepositoryException {
                PropertyImpl pMember = (PropertyImpl)property;
                NodeImpl nGroup = (NodeImpl)pMember.getParent();
                if (UserConstants.P_MEMBERS.equals(pMember.getQName()) && nGroup.isNodeType(UserConstants.NT_REP_GROUP)) {
                    for (Value value : property.getValues()) {
                        String v = value.getString();
                        if (!v.equals(authorizableNodeIdentifier)) continue;
                        pIds.add(nGroup.getIdentifier());
                    }
                } else {
                    String v;
                    while (nGroup.isNodeType(UserConstants.NT_REP_MEMBERS)) {
                        nGroup = (NodeImpl)nGroup.getParent();
                    }
                    if (nGroup.isNodeType(UserConstants.NT_REP_GROUP) && !NameConstants.JCR_UUID.equals(pMember.getQName()) && (v = pMember.getString()).equals(authorizableNodeIdentifier)) {
                        nIds.add(nGroup.getIdentifier());
                    }
                }
            }
        };
        if (session.nodeExists(this.groupsPath)) {
            Node groupsNode = session.getNode(this.groupsPath);
            visitor.visit(groupsNode);
        }
        return this.select(pIds, nIds);
    }

    private Set<String> select(Set<String> pIds, Set<String> nIds) {
        Set<String> result = this.useMembersNode ? (!nIds.isEmpty() || pIds.isEmpty() ? nIds : pIds) : (!pIds.isEmpty() || nIds.isEmpty() ? pIds : nIds);
        if (!pIds.isEmpty() && !nIds.isEmpty()) {
            log.warn("Found members node and members property. Ignoring {} members", (Object)(this.useMembersNode ? "property" : "node"));
        }
        return result;
    }

    private SessionImpl getSession() {
        try {
            return (SessionImpl)this.systemSession.createSession(this.systemSession.getWorkspace().getName());
        }
        catch (RepositoryException e) {
            return this.systemSession;
        }
    }

    private static PropertyIterator getMembershipReferences(String authorizableNodeIdentifier, Session session) {
        PropertyIterator refs = null;
        try {
            refs = session.getNodeByIdentifier(authorizableNodeIdentifier).getWeakReferences(null);
        }
        catch (RepositoryException e) {
            log.error("Failed to retrieve membership references of " + authorizableNodeIdentifier + ".", e);
        }
        return refs;
    }
}

