/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.BLOBInDataStore;
import org.apache.jackrabbit.core.value.BLOBInMemory;
import org.apache.jackrabbit.core.value.BLOBInResource;
import org.apache.jackrabbit.core.value.BLOBInTempFile;
import org.apache.jackrabbit.core.value.BinaryValueImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.AbstractQValue;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.apache.jackrabbit.util.ISO8601;

public class InternalValue
extends AbstractQValue {
    public static final InternalValue[] EMPTY_ARRAY = new InternalValue[0];
    private static final InternalValue BOOLEAN_TRUE = new InternalValue(true);
    private static final InternalValue BOOLEAN_FALSE = new InternalValue(false);
    private static final int MIN_BLOB_FILE_SIZE = 1024;

    public static InternalValue create(Value value, NamePathResolver resolver) throws ValueFormatException, RepositoryException {
        return InternalValue.create(value, resolver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalValue create(Value value, NamePathResolver resolver, DataStore store) throws ValueFormatException, RepositoryException {
        switch (value.getType()) {
            case 2: {
                BinaryValueImpl bin;
                DataIdentifier identifier;
                BLOBFileValue blob = null;
                if (value instanceof BinaryValueImpl && (identifier = (bin = (BinaryValueImpl)value).getDataIdentifier()) != null) {
                    if (bin.usesDataStore(store)) {
                        store.getRecord(identifier);
                        blob = BLOBInDataStore.getInstance(store, identifier);
                    } else if (store.getRecordIfStored(identifier) != null) {
                        blob = BLOBInDataStore.getInstance(store, identifier);
                    }
                }
                if (blob == null) {
                    Binary b = value.getBinary();
                    boolean dispose = false;
                    try {
                        if (b instanceof BLOBFileValue) {
                            blob = (BLOBFileValue)b;
                        } else {
                            dispose = true;
                            blob = InternalValue.getBLOBFileValue(store, b.getStream(), true);
                        }
                    }
                    finally {
                        if (dispose) {
                            b.dispose();
                        }
                    }
                }
                return new InternalValue(blob);
            }
            case 6: {
                return InternalValue.create(value.getBoolean());
            }
            case 5: {
                return InternalValue.create(value.getDate());
            }
            case 4: {
                return InternalValue.create(value.getDouble());
            }
            case 12: {
                return InternalValue.create(value.getDecimal());
            }
            case 3: {
                return InternalValue.create(value.getLong());
            }
            case 9: {
                return InternalValue.create(new NodeId(value.getString()));
            }
            case 10: {
                return InternalValue.create(new NodeId(value.getString()), true);
            }
            case 11: {
                try {
                    return InternalValue.create(new URI(value.getString()));
                }
                catch (URISyntaxException e) {
                    throw new ValueFormatException(e.getMessage());
                }
            }
            case 7: {
                try {
                    if (value instanceof QValueValue) {
                        QValue qv = ((QValueValue)value).getQValue();
                        if (qv instanceof InternalValue) {
                            return (InternalValue)qv;
                        }
                        return InternalValue.create(qv.getName());
                    }
                    return InternalValue.create(resolver.getQName(value.getString()));
                }
                catch (NameException e) {
                    throw new ValueFormatException(e.getMessage());
                }
            }
            case 8: {
                try {
                    if (value instanceof QValueValue) {
                        QValue qv = ((QValueValue)value).getQValue();
                        if (qv instanceof InternalValue) {
                            return (InternalValue)qv;
                        }
                        return InternalValue.create(qv.getPath());
                    }
                    return InternalValue.create(resolver.getQPath(value.getString(), false));
                }
                catch (MalformedPathException mpe) {
                    throw new ValueFormatException(mpe.getMessage());
                }
            }
            case 1: {
                return InternalValue.create(value.getString());
            }
        }
        throw new IllegalArgumentException("illegal value");
    }

    public static InternalValue create(QValue value) throws RepositoryException {
        switch (value.getType()) {
            case 2: {
                try {
                    return InternalValue.create(value.getString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalError("UTF-8 not supported");
                }
            }
            case 6: {
                return new InternalValue(value.getBoolean());
            }
            case 5: {
                return new InternalValue(value.getCalendar());
            }
            case 4: {
                return new InternalValue(value.getDouble());
            }
            case 12: {
                return new InternalValue(value.getDecimal());
            }
            case 3: {
                return new InternalValue(value.getLong());
            }
            case 9: {
                return InternalValue.create(new NodeId(value.getString()));
            }
            case 10: {
                return InternalValue.create(new NodeId(value.getString()), true);
            }
            case 11: {
                return new InternalValue(value.getURI());
            }
            case 7: {
                return new InternalValue(value.getName());
            }
            case 8: {
                return new InternalValue(value.getPath());
            }
            case 1: {
                return new InternalValue(value.getString());
            }
        }
        throw new IllegalArgumentException("illegal value");
    }

    public static InternalValue[] create(QValue[] values) throws RepositoryException {
        if (values == null) {
            return null;
        }
        InternalValue[] tmp = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            tmp[i] = InternalValue.create(values[i]);
        }
        return tmp;
    }

    static InternalValue getInternalValue(DataIdentifier identifier, DataStore store, boolean verify) throws DataStoreException {
        if (verify) {
            if (store.getRecordIfStored(identifier) == null) {
                return null;
            }
        } else {
            store.getRecord(identifier);
        }
        BLOBInDataStore blob = BLOBInDataStore.getInstance(store, identifier);
        return new InternalValue(blob);
    }

    public static InternalValue create(String value) {
        return new InternalValue(value);
    }

    public static InternalValue create(long value) {
        return new InternalValue(value);
    }

    public static InternalValue create(double value) {
        return new InternalValue(value);
    }

    public static InternalValue create(Calendar value) {
        return new InternalValue(value);
    }

    public static InternalValue create(BigDecimal value) {
        return new InternalValue(value);
    }

    public static InternalValue create(URI value) {
        return new InternalValue(value);
    }

    public static InternalValue create(boolean value) {
        return value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public static InternalValue create(byte[] value) {
        return new InternalValue(BLOBInMemory.getInstance(value));
    }

    public static InternalValue createTemporary(InputStream value) throws RepositoryException {
        return new InternalValue(InternalValue.getBLOBFileValue(null, value, true));
    }

    public static InternalValue create(InputStream value, DataStore store) throws RepositoryException {
        return new InternalValue(InternalValue.getBLOBFileValue(store, value, false));
    }

    public static InternalValue create(InputStream value) throws RepositoryException {
        return InternalValue.create(value, null);
    }

    public static InternalValue create(FileSystemResource value) throws IOException {
        return new InternalValue(BLOBInResource.getInstance(value));
    }

    public static InternalValue create(DataStore store, String id) {
        return new InternalValue(InternalValue.getBLOBFileValue(store, id));
    }

    public static InternalValue create(Name value) {
        return new InternalValue(value);
    }

    public static InternalValue[] create(Name[] values) {
        InternalValue[] ret = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new InternalValue(values[i]);
        }
        return ret;
    }

    public static InternalValue create(Path value) {
        return new InternalValue(value);
    }

    public static InternalValue create(NodeId value) {
        return InternalValue.create(value, false);
    }

    public static InternalValue create(NodeId value, boolean weak) {
        return new InternalValue(value, weak);
    }

    BLOBFileValue getBLOBFileValue() {
        assert (this.val != null && this.type == 2);
        return (BLOBFileValue)this.val;
    }

    public NodeId getNodeId() {
        assert (this.val != null && (this.type == 9 || this.type == 10));
        return (NodeId)this.val;
    }

    public Calendar getDate() {
        assert (this.val != null && this.type == 5);
        try {
            return this.getCalendar();
        }
        catch (RepositoryException ignore) {
            assert (false);
            return null;
        }
    }

    public InternalValue createCopy() throws RepositoryException {
        if (this.type != 2) {
            return this;
        }
        return new InternalValue(((BLOBFileValue)this.val).copy());
    }

    public static InternalValue valueOf(String s, int type) {
        switch (type) {
            case 6: {
                return InternalValue.create(Boolean.valueOf(s));
            }
            case 5: {
                return InternalValue.create(ISO8601.parse(s));
            }
            case 4: {
                return InternalValue.create(Double.parseDouble(s));
            }
            case 3: {
                return InternalValue.create(Long.parseLong(s));
            }
            case 12: {
                return InternalValue.create(new BigDecimal(s));
            }
            case 9: {
                return InternalValue.create(new NodeId(s));
            }
            case 10: {
                return InternalValue.create(new NodeId(s), true);
            }
            case 8: {
                return InternalValue.create(PathFactoryImpl.getInstance().create(s));
            }
            case 7: {
                return InternalValue.create(NameFactoryImpl.getInstance().create(s));
            }
            case 11: {
                return InternalValue.create(URI.create(s));
            }
            case 1: {
                return InternalValue.create(s);
            }
            case 2: {
                throw new IllegalArgumentException("this method does not support the type PropertyType.BINARY");
            }
        }
        throw new IllegalArgumentException("illegal type: " + type);
    }

    private InternalValue(String value) {
        super(value, 1);
    }

    private InternalValue(Name value) {
        super(value);
    }

    private InternalValue(long value) {
        super(value);
    }

    private InternalValue(double value) {
        super(value);
    }

    private InternalValue(Calendar value) {
        super(value);
    }

    private InternalValue(boolean value) {
        super(value);
    }

    private InternalValue(URI value) {
        super(value);
    }

    private InternalValue(BigDecimal value) {
        super(value);
    }

    private InternalValue(BLOBFileValue value) {
        super(value, 2);
    }

    private InternalValue(Path value) {
        super(value);
    }

    private InternalValue(NodeId value, boolean weak) {
        super(value, weak ? 10 : 9);
    }

    private static BLOBFileValue getBLOBFileValue(DataStore store, InputStream in, boolean temporary) throws RepositoryException {
        int maxMemorySize = store != null ? store.getMinRecordLength() - 1 : 1024;
        maxMemorySize = Math.max(0, maxMemorySize);
        byte[] buffer = new byte[maxMemorySize];
        int pos = 0;
        int len = maxMemorySize;
        try {
            int l;
            while (pos < maxMemorySize && (l = in.read(buffer, pos, len)) >= 0) {
                pos += l;
                len -= l;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read from stream", e);
        }
        if (pos < maxMemorySize) {
            byte[] data = new byte[pos];
            System.arraycopy(buffer, 0, data, 0, pos);
            return BLOBInMemory.getInstance(data);
        }
        in = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, pos), in);
        if (store != null) {
            return BLOBInDataStore.getInstance(store, in);
        }
        return BLOBInTempFile.getInstance(in, temporary);
    }

    private static BLOBFileValue getBLOBFileValue(DataStore store, String id) {
        if (BLOBInMemory.isInstance(id)) {
            return BLOBInMemory.getInstance(id);
        }
        if (BLOBInDataStore.isInstance(id)) {
            return BLOBInDataStore.getInstance(store, id);
        }
        throw new IllegalArgumentException("illegal binary id: " + id);
    }

    public void store(DataStore dataStore) throws RepositoryException {
        assert (dataStore != null);
        assert (this.type == 2);
        BLOBFileValue v = (BLOBFileValue)this.val;
        if (v instanceof BLOBInDataStore) {
            return;
        }
        this.val = BLOBInDataStore.getInstance(dataStore, this.getStream());
    }

    public long getLength() throws RepositoryException {
        if (2 == this.type) {
            return ((Binary)this.val).getSize();
        }
        return super.getLength();
    }

    public InputStream getStream() throws RepositoryException {
        if (this.type == 2) {
            return ((Binary)this.val).getStream();
        }
        try {
            return new ByteArrayInputStream(this.getString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("UTF-8 is not supported encoding on this platform", e);
        }
    }

    public Binary getBinary() throws RepositoryException {
        if (this.type == 2) {
            return ((BLOBFileValue)this.val).copy();
        }
        try {
            byte[] data = this.getString().getBytes("UTF-8");
            return BLOBInMemory.getInstance(data);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("UTF-8 is not supported encoding on this platform", e);
        }
    }

    public void discard() {
        if (this.type == 2) {
            BLOBFileValue bfv = (BLOBFileValue)this.val;
            bfv.dispose();
        } else {
            super.discard();
        }
    }

    public void deleteBinaryResource() {
        if (this.type == 2) {
            BLOBFileValue bfv = (BLOBFileValue)this.val;
            bfv.delete(true);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof InternalValue) {
            InternalValue that = (InternalValue)object;
            if (this.type == 5) {
                return that.type == 5 && this.getDate().getTimeInMillis() == that.getDate().getTimeInMillis();
            }
            return this.type == that.type && this.val.equals(that.val);
        }
        return false;
    }
}

