/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.tika.detect.ContainerDetector;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.iwork.IWorkPackageParser;

public class ZipContainerDetector
implements ContainerDetector {
    public MediaType getDefault() {
        return MediaType.APPLICATION_ZIP;
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (TikaInputStream.isTikaInputStream(input)) {
            return this.detect(TikaInputStream.get(input), metadata);
        }
        return MediaType.APPLICATION_ZIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(TikaInputStream input, Metadata metadata) throws IOException {
        ZipFile zip = new ZipFile(input.getFile());
        for (ZipEntry zipEntry : Collections.list(zip.entries())) {
            if (zipEntry.getName().equals("mimetype")) {
                InputStream stream = zip.getInputStream(zipEntry);
                try {
                    MediaType mediaType = ZipContainerDetector.fromString(IOUtils.toString(stream, "UTF-8"));
                    return mediaType;
                }
                finally {
                    stream.close();
                }
            }
            if (zipEntry.getName().equals("_rels/.rels") || zipEntry.getName().equals("[Content_Types].xml")) {
                try {
                    OPCPackage pkg = OPCPackage.open(input.getFile().toString());
                    input.setOpenContainer(pkg);
                    PackageRelationshipCollection core = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
                    if (core.size() != 1) {
                        throw new IOException("Invalid OOXML Package received - expected 1 core document, found " + core.size());
                    }
                    PackagePart corePart = pkg.getPart(core.getRelationship(0));
                    String coreType = corePart.getContentType();
                    String docType = coreType.substring(0, coreType.lastIndexOf(46));
                    return ZipContainerDetector.fromString(docType);
                }
                catch (InvalidFormatException e) {
                    throw new IOException("Office Open XML File detected, but corrupted - " + e.getMessage());
                }
            }
            if (zipEntry.getName().equals("buildVersionHistory.plist")) {
                zip.close();
                zip = new ZipFile(input.getFile());
                return IWorkPackageParser.identifyType(zip);
            }
            if (!zipEntry.getName().equals("META-INF/")) continue;
            return MediaType.application("java-archive");
        }
        return MediaType.APPLICATION_ZIP;
    }

    private static MediaType fromString(String type) {
        int splitAt = type.indexOf(47);
        if (splitAt > -1) {
            return new MediaType(type.substring(0, splitAt), type.substring(splitAt + 1));
        }
        return MediaType.APPLICATION_ZIP;
    }
}

