/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.ProxyInputStream;
import org.apache.tika.metadata.Metadata;

public class TikaInputStream
extends ProxyInputStream {
    private static final int BLOB_SIZE_THRESHOLD = 0x100000;
    private File file;
    private boolean temporary;
    private long length;
    private long position = 0L;
    private long mark = -1L;
    private Object openContainer;

    public static boolean isTikaInputStream(InputStream stream) {
        return stream instanceof TikaInputStream;
    }

    public static TikaInputStream get(InputStream stream) {
        if (stream instanceof TikaInputStream) {
            return (TikaInputStream)stream;
        }
        return new TikaInputStream(new BufferedInputStream(stream), null, -1L);
    }

    public static TikaInputStream get(byte[] data) {
        return TikaInputStream.get(data, new Metadata());
    }

    public static TikaInputStream get(byte[] data, Metadata metadata) {
        metadata.set("Content-Length", Integer.toString(data.length));
        return new TikaInputStream(new ByteArrayInputStream(data), null, data.length);
    }

    public static TikaInputStream get(File file) throws FileNotFoundException {
        return TikaInputStream.get(file, new Metadata());
    }

    public static TikaInputStream get(File file, Metadata metadata) throws FileNotFoundException {
        metadata.set("resourceName", file.getName());
        metadata.set("Content-Length", Long.toString(file.length()));
        return new TikaInputStream(new BufferedInputStream(new FileInputStream(file)), file, file.length());
    }

    public static TikaInputStream get(Blob blob) throws SQLException {
        return TikaInputStream.get(blob, new Metadata());
    }

    public static TikaInputStream get(Blob blob, Metadata metadata) throws SQLException {
        long length = -1L;
        try {
            length = blob.length();
            metadata.set("Content-Length", Long.toString(length));
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        if (0L <= length && length <= 0x100000L) {
            return TikaInputStream.get(blob.getBytes(1L, (int)length), metadata);
        }
        return new TikaInputStream(new BufferedInputStream(blob.getBinaryStream()), null, length);
    }

    public static TikaInputStream get(URI uri) throws IOException {
        return TikaInputStream.get(uri, new Metadata());
    }

    public static TikaInputStream get(URI uri, Metadata metadata) throws IOException {
        File file;
        if ("file".equalsIgnoreCase(uri.getScheme()) && (file = new File(uri)).isFile()) {
            return TikaInputStream.get(file, metadata);
        }
        return TikaInputStream.get(uri.toURL(), metadata);
    }

    public static TikaInputStream get(URL url) throws IOException {
        return TikaInputStream.get(url, new Metadata());
    }

    public static TikaInputStream get(URL url, Metadata metadata) throws IOException {
        int length;
        String encoding;
        String type;
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                File file = new File(url.toURI());
                if (file.isFile()) {
                    return TikaInputStream.get(file, metadata);
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        URLConnection connection = url.openConnection();
        String path = url.getPath();
        int slash = path.lastIndexOf(47);
        if (slash + 1 < path.length()) {
            metadata.set("resourceName", path.substring(slash + 1));
        }
        if ((type = connection.getContentType()) != null) {
            metadata.set("Content-Type", type);
        }
        if ((encoding = connection.getContentEncoding()) != null) {
            metadata.set("Content-Encoding", encoding);
        }
        if ((length = connection.getContentLength()) >= 0) {
            metadata.set("Content-Length", Integer.toString(length));
        }
        return new TikaInputStream(new BufferedInputStream(connection.getInputStream()), null, length);
    }

    private TikaInputStream(InputStream stream, File file, long length) {
        super(stream);
        this.file = file;
        this.temporary = file == null;
        this.length = length;
    }

    public int peek(byte[] buffer) throws IOException {
        int n = 0;
        this.mark(buffer.length);
        int m = this.read(buffer);
        while (m != -1) {
            if ((n += m) < buffer.length) {
                m = this.read(buffer, n, buffer.length - n);
                continue;
            }
            m = -1;
        }
        this.reset();
        return n;
    }

    public Object getOpenContainer() {
        return this.openContainer;
    }

    public void setOpenContainer(Object container) {
        this.openContainer = container;
    }

    public boolean hasFile() {
        return this.file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() throws IOException {
        if (this.file == null) {
            if (this.in == null) {
                throw new IOException("Stream has already been read");
            }
            if (this.position > 0L) {
                throw new IOException("Stream is already being read");
            }
            this.file = File.createTempFile("apache-tika-", ".tmp");
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                IOUtils.copy(this.in, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
            this.in.close();
            this.in = new BufferedInputStream(new FileInputStream(this.file));
        }
        return this.file;
    }

    public boolean hasLength() {
        return this.length != -1L;
    }

    public long getLength() throws IOException {
        if (this.length == -1L) {
            this.length = this.getFile().length();
        }
        return this.length;
    }

    public int available() throws IOException {
        if (this.in == null && this.file == null) {
            return 0;
        }
        return super.available();
    }

    public long skip(long ln) throws IOException {
        if (this.in == null && this.file == null) {
            return 0L;
        }
        long n = super.skip(ln);
        this.position += n;
        return n;
    }

    public int read() throws IOException {
        if (this.in == null && this.file == null) {
            return -1;
        }
        return super.read();
    }

    public int read(byte[] bts, int off, int len) throws IOException {
        if (this.in == null && this.file == null) {
            return -1;
        }
        return super.read(bts, off, len);
    }

    public int read(byte[] bts) throws IOException {
        return this.read(bts, 0, bts.length);
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.position = this.mark;
        this.mark = -1L;
    }

    public void close() throws IOException {
        if (this.openContainer != null) {
            this.openContainer = null;
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.file != null) {
            if (this.temporary) {
                this.file.delete();
            }
            this.file = null;
        }
    }

    protected void beforeRead(int n) throws IOException {
        if (this.in == null) {
            if (this.file != null) {
                this.in = new FileInputStream(this.file);
            } else {
                throw new IOException("End of the stream reached");
            }
        }
    }

    protected void afterRead(int n) throws IOException {
        if (n != -1) {
            this.position += (long)n;
        } else if (this.mark == -1L) {
            this.close();
        }
    }
}

