/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.drools.PackageIntegrationException;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.common.DroolsObjectInput;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.ObjectHashSet;
import org.drools.definition.process.Process;
import org.drools.definition.type.FactType;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.RuleBaseEventSupport;
import org.drools.impl.EnvironmentFactory;
import org.drools.management.DroolsManagementAgent;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.Function;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.FactHandleFactory;
import org.drools.util.ClassLoaderUtil;
import org.drools.util.CompositeClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleBase
implements InternalRuleBase,
Externalizable {
    private String id;
    private AtomicInteger workingMemoryCounter = new AtomicInteger(0);
    private RuleBaseConfiguration config;
    protected Map<String, Package> pkgs;
    private Map<String, Process> processes;
    private Map agendaGroupRuleTotals;
    private transient CompositeClassLoader rootClassLoader;
    private FactHandleFactory factHandleFactory;
    private transient Map<String, Class<?>> globals;
    private final transient Queue<DialectRuntimeRegistry> reloadPackageCompilationData = new ConcurrentLinkedQueue<DialectRuntimeRegistry>();
    private RuleBaseEventSupport eventSupport = new RuleBaseEventSupport(this);
    private transient ObjectHashSet statefulSessions;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantLock statefulSessionLock = new ReentrantLock();
    private int additionsSinceLock;
    private int removalsSinceLock;
    private transient Map<Class<?>, TypeDeclaration> classTypeDeclaration;
    private List<RuleBasePartitionId> partitionIDs;
    private ClassFieldAccessorCache classFieldAccessorCache;

    public AbstractRuleBase() {
    }

    @Override
    public int nextWorkingMemoryCounter() {
        return this.workingMemoryCounter.getAndIncrement();
    }

    public int getWorkingMemoryCounter() {
        return this.workingMemoryCounter.get();
    }

    public AbstractRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        this.config = config != null ? config : new RuleBaseConfiguration();
        this.config.makeImmutable();
        this.createRulebaseId(id);
        this.factHandleFactory = factHandleFactory;
        if (this.config.isSequential()) {
            this.agendaGroupRuleTotals = new HashMap();
        }
        this.rootClassLoader = this.config.getClassLoader();
        this.rootClassLoader.addClassLoader(this.getClass().getClassLoader());
        this.pkgs = new HashMap<String, Package>();
        this.processes = new HashMap<String, Process>();
        this.globals = new HashMap();
        this.statefulSessions = new ObjectHashSet();
        this.classTypeDeclaration = new HashMap();
        this.partitionIDs = new CopyOnWriteArrayList<RuleBasePartitionId>();
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
    }

    private void createRulebaseId(String id) {
        if (id != null) {
            this.id = id;
        } else {
            String key = "";
            if (this.config.isMBeansEnabled()) {
                DroolsManagementAgent agent = DroolsManagementAgent.getInstance();
                key = String.valueOf(agent.getNextKnowledgeBaseId());
            }
            this.id = "default" + key;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream bytes;
        ObjectOutput droolsStream;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        if (isDrools) {
            droolsStream = out;
            bytes = null;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        droolsStream.writeBoolean(this.config.isClassLoaderCacheEnabled());
        droolsStream.writeObject(this.config);
        droolsStream.writeObject(this.pkgs);
        droolsStream.writeObject(this.id);
        droolsStream.writeInt(this.workingMemoryCounter.get());
        droolsStream.writeObject(this.processes);
        droolsStream.writeObject(this.agendaGroupRuleTotals);
        droolsStream.writeUTF(this.factHandleFactory.getClass().getName());
        droolsStream.writeObject(this.buildGlobalMapForSerialization());
        droolsStream.writeObject(this.partitionIDs);
        this.eventSupport.removeEventListener(RuleBaseEventListener.class);
        droolsStream.writeObject(this.eventSupport);
        if (!isDrools) {
            droolsStream.flush();
            droolsStream.close();
            bytes.close();
            out.writeObject(bytes.toByteArray());
        }
    }

    private Map<String, String> buildGlobalMapForSerialization() {
        HashMap<String, String> gl = new HashMap<String, String>();
        for (Map.Entry<String, Class<?>> entry : this.globals.entrySet()) {
            gl.put(entry.getKey(), entry.getValue().getName());
        }
        return gl;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInput droolsStream;
        boolean isDrools = in instanceof DroolsObjectInputStream;
        ByteArrayInputStream bytes = null;
        if (isDrools) {
            droolsStream = (DroolsObjectInput)in;
        } else {
            bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        boolean classLoaderCacheEnabled = droolsStream.readBoolean();
        this.rootClassLoader = ClassLoaderUtil.getClassLoader(new ClassLoader[]{droolsStream.getParentClassLoader()}, this.getClass(), classLoaderCacheEnabled);
        droolsStream.setClassLoader(this.rootClassLoader);
        droolsStream.setRuleBase(this);
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.config = (RuleBaseConfiguration)droolsStream.readObject();
        this.config.setClassLoader(droolsStream.getParentClassLoader());
        this.pkgs = (Map)droolsStream.readObject();
        for (Package object : this.pkgs.values()) {
            object.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
        }
        this.id = (String)droolsStream.readObject();
        this.workingMemoryCounter.set(droolsStream.readInt());
        this.processes = (Map)droolsStream.readObject();
        this.agendaGroupRuleTotals = (Map)droolsStream.readObject();
        Class<?> cls = null;
        try {
            cls = droolsStream.getParentClassLoader().loadClass(droolsStream.readUTF());
            this.factHandleFactory = (FactHandleFactory)cls.newInstance();
        }
        catch (InstantiationException e) {
            DroolsObjectInputStream.newInvalidClassException(cls, e);
        }
        catch (IllegalAccessException e) {
            DroolsObjectInputStream.newInvalidClassException(cls, e);
        }
        for (Package object : this.pkgs.values()) {
            object.getDialectRuntimeRegistry().onBeforeExecute();
            object.getClassFieldAccessorStore().setClassFieldAccessorCache(this.classFieldAccessorCache);
            object.getClassFieldAccessorStore().wire();
        }
        this.populateTypeDeclarationMaps();
        Map globs = (Map)droolsStream.readObject();
        this.populateGlobalsMap(globs);
        this.partitionIDs = (List)droolsStream.readObject();
        this.eventSupport = (RuleBaseEventSupport)droolsStream.readObject();
        this.eventSupport.setRuleBase(this);
        this.statefulSessions = new ObjectHashSet();
        if (!isDrools) {
            droolsStream.close();
        }
    }

    private void populateGlobalsMap(Map<String, String> globs) throws ClassNotFoundException {
        this.globals = new HashMap();
        for (Map.Entry<String, String> entry : globs.entrySet()) {
            this.globals.put(entry.getKey(), this.rootClassLoader.loadClass(entry.getValue()));
        }
    }

    private void populateTypeDeclarationMaps() throws ClassNotFoundException {
        this.classTypeDeclaration = new HashMap();
        for (Package pkg : this.pkgs.values()) {
            for (TypeDeclaration type : pkg.getTypeDeclarations().values()) {
                type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                this.classTypeDeclaration.put(type.getTypeClass(), type);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public RuleBaseConfiguration getConfig() {
        return this.config;
    }

    @Override
    public StatefulSession newStatefulSession() {
        return this.newStatefulSession(SessionConfiguration.getDefaultInstance(), EnvironmentFactory.newEnvironment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeStatefulSession(StatefulSession statefulSession) {
        this.statefulSessionLock.lock();
        try {
            this.statefulSessions.remove(statefulSession);
            for (Object listener : statefulSession.getRuleBaseUpdateListeners()) {
                this.removeEventListener((RuleBaseEventListener)listener);
            }
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    @Override
    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    @Override
    public FactHandleFactory newFactHandleFactory(int id, long counter) {
        return this.factHandleFactory.newInstance(id, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process[] getProcesses() {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            return this.processes.values().toArray(new Process[this.processes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package[] getPackages() {
        this.readLock();
        try {
            Package[] packageArray = this.pkgs.values().toArray(new Package[this.pkgs.size()]);
            return packageArray;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Map<String, Package> getPackagesMap() {
        return this.pkgs;
    }

    @Override
    public Map getGlobals() {
        return this.globals;
    }

    @Override
    public Map getAgendaGroupRuleTotals() {
        return this.agendaGroupRuleTotals;
    }

    @Override
    public int getAdditionsSinceLock() {
        return this.additionsSinceLock;
    }

    @Override
    public int getRemovalsSinceLock() {
        return this.removalsSinceLock;
    }

    @Override
    public void lock() {
        boolean firstLock;
        boolean bl = firstLock = !this.lock.isWriteLockedByCurrentThread();
        if (firstLock) {
            this.eventSupport.fireBeforeRuleBaseLocked();
        }
        this.lock.writeLock().lock();
        if (firstLock) {
            this.additionsSinceLock = 0;
            this.removalsSinceLock = 0;
            this.eventSupport.fireAfterRuleBaseLocked();
        }
    }

    @Override
    public void unlock() {
        boolean lastUnlock;
        boolean bl = lastUnlock = this.lock.getWriteHoldCount() == 1;
        if (lastUnlock) {
            this.eventSupport.fireBeforeRuleBaseUnlocked();
        }
        this.lock.writeLock().unlock();
        if (lastUnlock) {
            this.eventSupport.fireAfterRuleBaseUnlocked();
        }
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackages(Collection<Package> newPkgs) {
        this.lock();
        try {
            Package pkg;
            for (Package newPkg : newPkgs) {
                newPkg.checkValidity();
                ++this.additionsSinceLock;
                this.eventSupport.fireBeforePackageAdded(newPkg);
                pkg = this.pkgs.get(newPkg.getName());
                if (pkg == null) {
                    pkg = new Package(newPkg.getName());
                    pkg.setClassFieldAccessorCache(this.classFieldAccessorCache);
                    this.pkgs.put(pkg.getName(), pkg);
                }
                pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
            }
            for (Package newPkg : newPkgs) {
                pkg = this.pkgs.get(newPkg.getName());
                if (newPkg.getFunctions() != null) {
                    for (Map.Entry<String, Function> entry : newPkg.getFunctions().entrySet()) {
                        pkg.addFunction(entry.getValue());
                    }
                }
                pkg.getDialectRuntimeRegistry().onBeforeExecute();
                pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
            }
            for (Package newPkg : newPkgs) {
                pkg = this.pkgs.get(newPkg.getName());
                TypeDeclaration lastType = null;
                try {
                    if (newPkg.getTypeDeclarations() != null) {
                        Iterator<TypeDeclaration> i$ = newPkg.getTypeDeclarations().values().iterator();
                        while (i$.hasNext()) {
                            TypeDeclaration newDecl;
                            lastType = newDecl = i$.next();
                            newDecl.setTypeClass(this.rootClassLoader.loadClass(newDecl.getTypeClassName()));
                            TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(newDecl.getTypeClass());
                            if (typeDeclaration == null) {
                                this.classTypeDeclaration.put(newDecl.getTypeClass(), newDecl);
                                typeDeclaration = newDecl;
                            } else {
                                this.mergeTypeDeclarations(typeDeclaration, newDecl);
                            }
                            this.updateDependentTypes(newPkg, typeDeclaration);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeDroolsException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
                }
                this.mergePackage(pkg, newPkg);
                Rule[] rules = newPkg.getRules();
                for (int i = 0; i < rules.length; ++i) {
                    this.addRule(newPkg, rules[i]);
                }
                if (newPkg.getRuleFlows() != null) {
                    Map<String, Process> flows = newPkg.getRuleFlows();
                    for (Process process : flows.values()) {
                        this.addProcess(process);
                    }
                }
                this.eventSupport.fireAfterPackageAdded(newPkg);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected abstract void updateDependentTypes(Package var1, TypeDeclaration var2);

    private void mergeTypeDeclarations(TypeDeclaration existingDecl, TypeDeclaration newDecl) {
        if (!(this.nullSafeEquals((Object)existingDecl.getFormat(), (Object)newDecl.getFormat()) && this.nullSafeEquals(existingDecl.getObjectType(), newDecl.getObjectType()) && this.nullSafeEquals(existingDecl.getTypeClassName(), newDecl.getTypeClassName()) && this.nullSafeEquals(existingDecl.getTypeName(), newDecl.getTypeName()))) {
            throw new RuntimeDroolsException("Unable to merge Type Declaration for class '" + existingDecl.getTypeName() + "'");
        }
        existingDecl.setDurationAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @duration attribute for type declaration of class:", existingDecl.getDurationAttribute(), newDecl.getDurationAttribute(), true));
        existingDecl.setDynamic(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyChangeSupport  (a.k.a. dynamic) attribute for type declaration of class:", existingDecl.isDynamic(), newDecl.isDynamic(), true));
        existingDecl.setExpirationOffset(Math.max(existingDecl.getExpirationOffset(), newDecl.getExpirationOffset()));
        existingDecl.setNovel(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @novel attribute for type declaration of class:", existingDecl.isNovel(), newDecl.isNovel(), true));
        existingDecl.setResource(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge resource attribute for type declaration of class:", existingDecl.getResource(), newDecl.getResource(), true));
        existingDecl.setRole(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @role attribute for type declaration of class:", existingDecl.getRole(), newDecl.getRole(), true));
        existingDecl.setTimestampAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @timestamp attribute for type declaration of class:", existingDecl.getTimestampAttribute(), newDecl.getTimestampAttribute(), true));
        existingDecl.setTypesafe(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @typesafe attribute for type declaration of class:", existingDecl.isTypesafe(), newDecl.isTypesafe(), true));
    }

    private <T> T mergeLeft(String typeClass, String errorMsg, T leftVal, T rightVal, boolean errorOnDiff) {
        T newValue = leftVal;
        if (!this.nullSafeEquals(leftVal, rightVal)) {
            if (leftVal == null && rightVal != null) {
                newValue = rightVal;
            } else if (leftVal != null && rightVal != null && errorOnDiff) {
                throw new RuntimeDroolsException(errorMsg + " '" + typeClass + "'");
            }
        }
        return newValue;
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void mergePackage(Package pkg, Package newPkg) {
        Map<String, ImportDeclaration> imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        String lastIdent = null;
        String lastType = null;
        try {
            if (newPkg.getGlobals() != null && newPkg.getGlobals() != Collections.EMPTY_MAP) {
                Map<String, String> globals = pkg.getGlobals();
                for (Map.Entry<String, String> entry : newPkg.getGlobals().entrySet()) {
                    String identifier = entry.getKey();
                    String type = entry.getValue();
                    lastIdent = identifier;
                    lastType = type;
                    if (globals.containsKey(identifier) && !globals.get(identifier).equals(type)) {
                        throw new PackageIntegrationException(pkg);
                    }
                    pkg.addGlobal(identifier, this.rootClassLoader.loadClass(type));
                    this.globals.put(identifier, this.rootClassLoader.loadClass(type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + lastType + "' for global '" + lastIdent + "'");
        }
        if (newPkg.getEntryPointIds() != null) {
            for (String ep : newPkg.getEntryPointIds()) {
                pkg.addEntryPointId(ep);
            }
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        Rule[] newRules = newPkg.getRules();
        for (int i = 0; i < newRules.length; ++i) {
            Rule newRule = newRules[i];
            if (pkg.getRule(newRule.getName()) != null) {
                this.removeRule(pkg, pkg.getRule(newRule.getName()));
            }
            pkg.addRule(newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map<String, Process> flows = newPkg.getRuleFlows();
            for (Process flow : flows.values()) {
                pkg.addProcess(flow);
            }
        }
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(clazz);
        if (typeDeclaration == null) {
            TypeDeclarationCandidate candidate = this.checkSuperClasses(clazz);
            if ((candidate = this.checkInterfaces(clazz, candidate, 1)) != null) {
                typeDeclaration = candidate.candidate;
            }
        }
        return typeDeclaration;
    }

    private TypeDeclarationCandidate checkSuperClasses(Class<?> clazz) {
        TypeDeclarationCandidate candidate = null;
        TypeDeclaration typeDeclaration = null;
        int score = 0;
        for (Class<?> current = clazz.getSuperclass(); typeDeclaration == null && current != null; current = current.getSuperclass()) {
            ++score;
            typeDeclaration = this.classTypeDeclaration.get(current);
        }
        if (typeDeclaration == null) {
            score = Integer.MAX_VALUE;
        } else {
            candidate = new TypeDeclarationCandidate();
            candidate.candidate = typeDeclaration;
            candidate.score = score;
        }
        return candidate;
    }

    private TypeDeclarationCandidate checkInterfaces(Class<?> clazz, TypeDeclarationCandidate baseline, int level) {
        TypeDeclarationCandidate candidate = null;
        TypeDeclaration typeDeclaration = null;
        if (baseline == null || level < baseline.score) {
            for (Class<?> ifc : clazz.getInterfaces()) {
                typeDeclaration = this.classTypeDeclaration.get(ifc);
                if (typeDeclaration != null) {
                    candidate = new TypeDeclarationCandidate();
                    candidate.candidate = typeDeclaration;
                    candidate.score = level;
                    break;
                }
                candidate = this.checkInterfaces(ifc, baseline, level + 1);
            }
        } else {
            candidate = baseline;
        }
        return candidate;
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.classTypeDeclaration.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule(Package pkg, Rule rule) throws InvalidPatternException {
        this.lock();
        try {
            this.eventSupport.fireBeforeRuleAdded(pkg, rule);
            this.addRule(rule);
            this.eventSupport.fireAfterRuleAdded(pkg, rule);
        }
        finally {
            this.unlock();
        }
    }

    protected abstract void addRule(Rule var1) throws InvalidPatternException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePackage(String packageName) {
        this.lock();
        try {
            Package pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            ++this.removalsSinceLock;
            this.eventSupport.fireBeforePackageRemoved(pkg);
            Rule[] rules = pkg.getRules();
            for (int i = 0; i < rules.length; ++i) {
                this.removeRule(pkg, rules[i]);
            }
            HashSet<String> referencedGlobals = new HashSet<String>();
            for (Package pkgref : this.pkgs.values()) {
                if (pkgref == pkg) continue;
                referencedGlobals.addAll(pkgref.getGlobals().keySet());
            }
            for (String globalName : pkg.getGlobals().keySet()) {
                if (referencedGlobals.contains(globalName)) continue;
                this.globals.remove(globalName);
            }
            Map<String, Process> flows = pkg.getRuleFlows();
            Iterator<String> iter = flows.keySet().iterator();
            while (iter.hasNext()) {
                this.removeProcess(iter.next());
            }
            this.pkgs.remove(pkg.getName());
            pkg.getDialectRuntimeRegistry().onRemove();
            pkg.clear();
            this.eventSupport.fireAfterPackageRemoved(pkg);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void removeQuery(String packageName, String ruleName) {
        this.removeRule(packageName, ruleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRule(String packageName, String ruleName) {
        this.lock();
        try {
            Package pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            Rule rule = pkg.getRule(ruleName);
            if (rule == null) {
                throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
            }
            ++this.removalsSinceLock;
            this.removeRule(pkg, rule);
            pkg.removeRule(rule);
            this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRule(Package pkg, Rule rule) {
        this.lock();
        try {
            this.eventSupport.fireBeforeRuleRemoved(pkg, rule);
            this.removeRule(rule);
            this.eventSupport.fireAfterRuleRemoved(pkg, rule);
        }
        finally {
            this.unlock();
        }
    }

    protected abstract void removeRule(Rule var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFunction(String packageName, String functionName) {
        this.lock();
        try {
            Package pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            if (!pkg.getFunctions().containsKey(functionName)) {
                throw new IllegalArgumentException("function name '" + packageName + "' does not exist in the Package '" + packageName + "'.");
            }
            this.removeFunction(pkg, functionName);
            pkg.removeFunction(functionName);
            this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
        }
        finally {
            this.unlock();
        }
    }

    protected void removeFunction(String functionName) {
    }

    private void removeFunction(Package pkg, String functionName) {
        this.eventSupport.fireBeforeFunctionRemoved(pkg, functionName);
        this.removeFunction(functionName);
        this.eventSupport.fireAfterFunctionRemoved(pkg, functionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(Process process) {
        this.eventSupport.fireBeforeProcessAdded(process);
        this.lock();
        try {
            this.processes.put(process.getId(), process);
        }
        finally {
            this.unlock();
        }
        this.eventSupport.fireAfterProcessAdded(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcess(String id) {
        Process process = this.processes.get(id);
        if (process == null) {
            throw new IllegalArgumentException("Process '" + id + "' does not exist for this Rule Base.");
        }
        this.eventSupport.fireBeforeProcessRemoved(process);
        this.lock();
        try {
            this.processes.remove(id);
        }
        finally {
            this.unlock();
        }
        this.eventSupport.fireAfterProcessRemoved(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process getProcess(String id) {
        this.readLock();
        try {
            Process process = this.processes.get(id);
            return process;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatefulSession(StatefulSession statefulSession) {
        this.statefulSessionLock.lock();
        try {
            this.statefulSessions.add(statefulSession);
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String name) {
        this.readLock();
        try {
            Package package_ = this.pkgs.get(name);
            return package_;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulSession[] getStatefulSessions() {
        this.statefulSessionLock.lock();
        try {
            Object[] copyOfSessions = new StatefulSession[this.statefulSessions.size()];
            this.statefulSessions.toArray(copyOfSessions);
            Object[] objectArray = copyOfSessions;
            return objectArray;
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalWorkingMemory[] getWorkingMemories() {
        this.statefulSessionLock.lock();
        try {
            Object[] copyOfMemories = new InternalWorkingMemory[this.statefulSessions.size()];
            this.statefulSessions.toArray(copyOfMemories);
            Object[] objectArray = copyOfMemories;
            return objectArray;
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    @Override
    public RuleBaseConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public CompositeClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public void executeQueuedActions() {
        DialectRuntimeRegistry registry;
        while ((registry = this.reloadPackageCompilationData.poll()) != null) {
            registry.onBeforeExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleBasePartitionId createNewPartitionId() {
        RuleBasePartitionId p;
        List<RuleBasePartitionId> list = this.partitionIDs;
        synchronized (list) {
            p = new RuleBasePartitionId("P-" + this.partitionIDs.size());
            this.partitionIDs.add(p);
        }
        return p;
    }

    @Override
    public List<RuleBasePartitionId> getPartitionIds() {
        return Collections.unmodifiableList(this.partitionIDs);
    }

    @Override
    public void addEventListener(RuleBaseEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(RuleBaseEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    @Override
    public List<RuleBaseEventListener> getRuleBaseEventListeners() {
        return this.eventSupport.getEventListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEvent(Class<?> clazz) {
        this.readLock();
        try {
            for (Package pkg : this.pkgs.values()) {
                if (!pkg.isEvent(clazz)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactType getFactType(String name) {
        this.readLock();
        try {
            for (Package pkg : this.pkgs.values()) {
                FactType type = pkg.getFactType(name);
                if (type == null) continue;
                FactType factType = type;
                return factType;
            }
            FactType factType = null;
            return factType;
        }
        finally {
            this.readUnlock();
        }
    }

    private void addReloadDialectDatas(DialectRuntimeRegistry registry) {
        this.reloadPackageCompilationData.offer(registry);
    }

    public ClassFieldAccessorCache getClassFieldAccessorCache() {
        return this.classFieldAccessorCache;
    }

    @Override
    public Set<String> getEntryPointIds() {
        HashSet<String> entryPointIds = new HashSet<String>();
        for (Package pkg : this.pkgs.values()) {
            entryPointIds.addAll(pkg.getEntryPointIds());
        }
        return entryPointIds;
    }

    public static interface RuleBaseAction
    extends Externalizable {
        public void execute(InternalRuleBase var1);
    }

    private static class TypeDeclarationCandidate {
        public TypeDeclaration candidate = null;
        public int score = Integer.MAX_VALUE;

        private TypeDeclarationCandidate() {
        }
    }
}

