/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

public class TraitTripleWrapperClassBuilderImpl
implements TraitProxyClassBuilder {
    private ClassDefinition trait;

    public void init(ClassDefinition trait) {
        this.trait = trait;
    }

    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        FieldVisitor fv;
        ClassWriter cw = new ClassWriter(0);
        long mask = TraitRegistry.getInstance().getFieldMask(this.trait.getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.trait, core);
        String masterName = TraitFactory.getProxyName(this.trait, core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String internalProxy = BuildUtils.getInternalType(masterName);
        String descrWrapper = BuildUtils.getTypeDescriptor(name);
        String descrProxy = BuildUtils.getTypeDescriptor(masterName);
        String internalCore = BuildUtils.getInternalType(core.getClassName());
        String descrCore = BuildUtils.getTypeDescriptor(core.getClassName());
        String internalTrait = BuildUtils.getInternalType(this.trait.getClassName());
        String descrTrait = BuildUtils.getTypeDescriptor(this.trait.getClassName());
        cw.visit(49, 33, internalWrapper, null, "org/drools/factmodel/traits/TripleBasedStruct", null);
        cw.visitInnerClass("java/util/Map$Entry", "java/util/Map", "Entry", 1545);
        for (FieldDefinition fld : core.getFieldsDefinitions()) {
            fv = cw.visitField(9, fld.getName() + "_reader", "Lorg/drools/spi/InternalReadAccessor;", null, null);
            fv.visitEnd();
            fv = cw.visitField(9, fld.getName() + "_writer", "Lorg/drools/spi/WriteAccessor;", null, null);
            fv.visitEnd();
        }
        fv = cw.visitField(0, "object", descrCore, null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + descrCore + "Lorg/drools/core/util/TripleStore;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalWrapper, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalWrapper, "store", "Lorg/drools/core/util/TripleStore;");
        int stackSize = this.initSoftFields(mv, internalWrapper, this.trait, mask);
        mv.visitInsn(177);
        mv.visitMaxs(4 + stackSize, 3);
        mv.visitEnd();
        this.buildSize(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildIsEmpty(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildGet(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildPut(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildClear(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildRemove(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildContainsKey(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildContainsValue(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildKeyset(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildValues(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildEntryset(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildCommonMethods(cw, name);
        this.buildSpecificMethods(cw, name, core);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void buildRemove(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        boolean hasPrimitiveFields = false;
        boolean hasObjectFields = false;
        MethodVisitor mv = cw.visitMethod(1, "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        int stack = 0;
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            stack = Math.max(stack, BuildUtils.sizeOf(field.getTypeName()));
            mv.visitLdcInsn(field.getName());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            Label l1 = new Label();
            mv.visitJumpInsn(153, l1);
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitVarInsn(58, 2);
            TraitFactory.invokeInjector(mv, wrapperName, trait, core, field, true, 1);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitLabel(l1);
        }
        int j = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField;
            if (!(isSoftField = (mask & (long)(1 << j++)) == 0L)) continue;
            stack = Math.max(stack, BuildUtils.sizeOf(field.getTypeName()));
            mv.visitLdcInsn(field.getName());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            Label l2 = new Label();
            mv.visitJumpInsn(153, l2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalWrapper, "store", "Lorg/drools/core/util/TripleStore;");
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(field.getName());
            mv.visitMethodInsn(182, internalWrapper, "key", "(Ljava/lang/Object;)Lorg/drools/core/util/TripleImpl;");
            mv.visitMethodInsn(182, "org/drools/core/util/TripleStore", "get", "(Lorg/drools/core/util/Triple;)Lorg/drools/core/util/Triple;");
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(field.getName());
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "put", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitLabel(l2);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(2 + stack, 3);
        mv.visitEnd();
    }

    private int initSoftFields(MethodVisitor mv, String wrapperName, ClassDefinition trait, long mask) {
        int j = 0;
        boolean nonPrimitiveFields = false;
        int stackSize = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField;
            if (!(isSoftField = (mask & (long)(1 << j++)) == 0L)) continue;
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, wrapperName, "store", "Lorg/drools/core/util/TripleStore;");
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(field.getName());
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
                int size = BuildUtils.sizeOf(field.getTypeName());
                stackSize = Math.max(stackSize, size);
            } else {
                stackSize = Math.max(stackSize, 2);
            }
            mv.visitMethodInsn(182, wrapperName, "property", "(Ljava/lang/String;Ljava/lang/Object;)Lorg/drools/core/util/TripleImpl;");
            mv.visitMethodInsn(182, "org/drools/core/util/TripleStore", "put", "(Lorg/drools/core/util/Triple;)Z");
            mv.visitInsn(87);
        }
        return stackSize;
    }

    private void buildClear(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        boolean hasPrimitiveFields = false;
        boolean hasObjectFields = false;
        MethodVisitor mv = cw.visitMethod(1, "clear", "()V", null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            if (field.isKey()) continue;
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                hasPrimitiveFields = true;
            } else {
                hasObjectFields = true;
            }
            TraitFactory.invokeInjector(mv, wrapperName, trait, core, field, true, 1);
        }
        int stack = 2;
        if (hasPrimitiveFields) {
            ++stack;
        }
        if (hasObjectFields) {
            ++stack;
        }
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "clear", "()V");
        int num = this.initSoftFields(mv, internalWrapper, trait, mask);
        mv.visitInsn(177);
        mv.visitMaxs(stack += num, 1);
        mv.visitEnd();
    }

    private void buildContainsValue(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        MethodVisitor mv = cw.visitMethod(1, "containsValue", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        Label l99 = new Label();
        mv.visitJumpInsn(199, l99);
        int j = 0;
        int N = core.getFieldsDefinitions().size();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            ++j;
            if (BuildUtils.isPrimitive(field.getTypeName())) continue;
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (j != N) {
                Label l1 = new Label();
                mv.visitJumpInsn(199, l1);
                mv.visitInsn(4);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                continue;
            }
            mv.visitJumpInsn(199, l99);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l99);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "containsValue", "(Ljava/lang/Object;)Z");
        mv.visitInsn(172);
        mv.visitMaxs(core.getFieldsDefinitions().size() > 0 ? 3 : 2, 2);
        mv.visitEnd();
    }

    private void buildContainsKey(ClassWriter cw, String name, String className, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(name);
        MethodVisitor mv = cw.visitMethod(1, "containsKey", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitLdcInsn(field.getName());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            Label l0 = new Label();
            mv.visitJumpInsn(153, l0);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "containsKey", "(Ljava/lang/Object;)Z");
        mv.visitInsn(172);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void buildSize(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "size", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "size", "()I");
        int n = core.getFieldsDefinitions().size();
        for (int j = 0; j < n; ++j) {
            mv.visitInsn(4);
            mv.visitInsn(96);
        }
        mv.visitInsn(172);
        mv.visitMaxs(core.getFieldsDefinitions().size() > 0 ? 2 : 1, 1);
        mv.visitEnd();
    }

    private void buildIsEmpty(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        boolean hasHardFields = core.getFieldsDefinitions().size() > 0;
        MethodVisitor mv = cw.visitMethod(1, "isEmpty", "()Z", null, null);
        mv.visitCode();
        if (!hasHardFields) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "isEmpty", "()Z");
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void buildGet(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (core.getFieldsDefinitions().size() > 0) {
            for (FieldDefinition field : core.getFieldsDefinitions()) {
                mv.visitLdcInsn(field.getName());
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label l0 = new Label();
                mv.visitJumpInsn(153, l0);
                TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
                if (BuildUtils.isPrimitive(field.getTypeName())) {
                    TraitFactory.valueOf(mv, field.getTypeName());
                }
                mv.visitInsn(176);
                mv.visitLabel(l0);
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void buildPut(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        MethodVisitor mv = cw.visitMethod(1, "put", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (core.getFieldsDefinitions().size() > 0) {
            boolean j = false;
            for (FieldDefinition field : core.getFieldsDefinitions()) {
                mv.visitLdcInsn(field.getName());
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label l1 = new Label();
                mv.visitJumpInsn(153, l1);
                mv.visitVarInsn(25, 2);
                if (BuildUtils.isPrimitive(field.getTypeName())) {
                    TraitFactory.promote(mv, field.getTypeName());
                    mv.visitVarInsn(BuildUtils.storeType(field.getTypeName()), 3);
                    TraitFactory.invokeInjector(mv, wrapperName, trait, core, field, false, 3);
                } else {
                    TraitFactory.invokeInjector(mv, wrapperName, trait, core, field, false, 2);
                }
                mv.visitVarInsn(25, 2);
                mv.visitInsn(176);
                mv.visitLabel(l1);
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "put", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 5);
        mv.visitEnd();
    }

    private void buildEntryset(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        MethodVisitor mv = cw.visitMethod(1, "entrySet", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/util/Map$Entry<Ljava/lang/String;Ljava/lang/Object;>;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/util/HashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(field.getName());
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(184, "org/drools/factmodel/traits/TraitProxy", "buildEntry", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/util/Map$Entry;");
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "entrySet", "()Ljava/util/Set;");
        mv.visitMethodInsn(185, "java/util/Set", "addAll", "(Ljava/util/Collection;)Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(core.getFieldsDefinitions().size() > 0 ? 4 : 2, 2);
        mv.visitEnd();
    }

    private void buildKeyset(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "keySet", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/lang/String;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/util/HashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(field.getName());
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "keySet", "()Ljava/util/Set;");
        mv.visitMethodInsn(185, "java/util/Set", "addAll", "(Ljava/util/Collection;)Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void buildValues(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        String internalCore = BuildUtils.getInternalType(coreName);
        String descrCore = BuildUtils.getTypeDescriptor(coreName);
        MethodVisitor mv = cw.visitMethod(1, "values", "()Ljava/util/Collection;", "()Ljava/util/Collection<Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(185, "java/util/Collection", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedStruct", "values", "()Ljava/util/Collection;");
        mv.visitMethodInsn(185, "java/util/Collection", "addAll", "(Ljava/util/Collection;)Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(core.getFieldsDefinitions().size() > 0 ? 3 : 2, 2);
        mv.visitEnd();
    }

    public void buildCommonMethods(ClassVisitor cw, String wrapper) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitLdcInsn("[[");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "entrySet", "()Ljava/util/Set;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        mv.visitLdcInsn("]]");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "java/lang/String");
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "put", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private void buildSpecificMethods(ClassWriter cw, String wrapper, ClassDefinition core) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "object", BuildUtils.getTypeDescriptor(core.getName()));
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "getTriplesForSubject", "(Ljava/lang/Object;)Ljava/util/Collection;");
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mv.visitInsn(172);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "getObject", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "object", BuildUtils.getTypeDescriptor(core.getName()));
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }
}

