/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.internal.InternalResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodedResource
extends BaseResource
implements InternalResource {
    private final InternalResource resource;
    private final String encoding;

    public EncodedResource(Resource resource) {
        this(resource, null);
    }

    public EncodedResource(Resource resource, String encoding) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        this.resource = (InternalResource)resource;
        this.encoding = encoding;
    }

    @Override
    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    @Override
    public boolean hasURL() {
        return this.resource.hasURL();
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.resource.getInputStream());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    @Override
    public long getLastModified() {
        return this.resource.getLastModified();
    }

    @Override
    public long getLastRead() {
        return this.resource.getLastRead();
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        return this.resource.listResources();
    }

    public String toString() {
        return "[EncodedResource resource=" + this.resource + " encoding='" + this.encoding + "']";
    }
}

