/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.rule.Namespaceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclarationDescr
extends AnnotatedBaseDescr
implements Namespaceable,
Comparable<TypeDeclarationDescr> {
    private static final long serialVersionUID = 510L;
    private QualifiedName type;
    private Map<String, TypeFieldDescr> fields;
    private List<QualifiedName> superTypes;

    public TypeDeclarationDescr() {
        this(null);
    }

    public TypeDeclarationDescr(String typeName) {
        this.type = new QualifiedName(typeName, null);
    }

    public TypeDeclarationDescr(String typeName, String typeNamespace) {
        this.type = new QualifiedName(typeName, typeNamespace);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = (QualifiedName)in.readObject();
        this.superTypes = (List)in.readObject();
        this.fields = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.type);
        out.writeObject(this.superTypes);
        out.writeObject(this.fields);
    }

    @Override
    public void setNamespace(String namespace) {
        this.type.setNamespace(namespace);
    }

    @Override
    public String getNamespace() {
        return this.type.getNamespace();
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public void setTypeName(String typeName) {
        this.type.setName(typeName);
    }

    public QualifiedName getType() {
        return this.type;
    }

    public void setType(QualifiedName qname) {
        this.type = qname;
    }

    public void setType(String name, String namespace) {
        this.type = new QualifiedName(name, namespace);
    }

    public String getSuperTypeName() {
        return this.superTypes == null ? null : this.superTypes.get(0).getName();
    }

    public String getSuperTypeNamespace() {
        return this.superTypes == null ? null : this.superTypes.get(0).getNamespace();
    }

    public String getSupertTypeFullName() {
        return this.superTypes == null ? null : this.superTypes.get(0).getFullName();
    }

    public Map<String, TypeFieldDescr> getFields() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    public void setFields(Map<String, TypeFieldDescr> fields) {
        this.fields = fields;
    }

    public void addField(TypeFieldDescr field) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, TypeFieldDescr>();
        }
        this.fields.put(field.getFieldName(), field);
    }

    public String toString() {
        return "TypeDeclaration[ " + this.getType().getFullName() + " ]";
    }

    public List<QualifiedName> getSuperTypes() {
        return this.superTypes != null ? this.superTypes : Collections.emptyList();
    }

    public void addSuperType(String type) {
        this.addSuperType(new QualifiedName(type));
    }

    public void addSuperType(QualifiedName type) {
        if (this.superTypes == null) {
            this.superTypes = new ArrayList<QualifiedName>();
        }
        this.superTypes.add(type);
    }

    @Override
    public int compareTo(TypeDeclarationDescr descr) {
        System.out.println("Comp");
        if (!this.getSuperTypes().isEmpty() && !descr.getSuperTypes().isEmpty()) {
            for (QualifiedName q : descr.getSuperTypes()) {
                if (!this.getSuperTypes().contains(q)) continue;
                return -1;
            }
            for (QualifiedName q : this.getSuperTypes()) {
                if (!descr.getSuperTypes().contains(q)) continue;
                return 1;
            }
        }
        for (TypeFieldDescr field : this.getFields().values()) {
            if (!descr.getType().equals(field.getPattern().getObjectType())) continue;
            return -1;
        }
        for (TypeFieldDescr field : descr.getFields().values()) {
            if (!this.getType().equals(field.getPattern().getObjectType())) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDeclarationDescr that = (TypeDeclarationDescr)o;
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public static class QualifiedName {
        private String name;
        private String namespace;

        public QualifiedName(String name) {
            int pos = name.lastIndexOf(46);
            if (pos < 0) {
                this.name = name;
                this.namespace = "";
            } else {
                this.name = name.substring(pos + 1);
                this.namespace = name.substring(0, pos);
            }
        }

        public QualifiedName(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QualifiedName that = (QualifiedName)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            return result;
        }

        public String getFullName() {
            if (StringUtils.isEmpty(this.namespace)) {
                return this.name;
            }
            return this.namespace + "." + this.name;
        }

        public String toString() {
            return this.getFullName();
        }
    }
}

