/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.drools.guvnor.importgenerator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.InputType;
import org.drools.rule.Package;
import org.jboss.drools.guvnor.importgenerator.CmdArgsParser;
import org.jboss.drools.guvnor.importgenerator.Rule;
import org.jboss.drools.guvnor.importgenerator.utils.DroolsHelper;
import org.jboss.drools.guvnor.importgenerator.utils.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFile {
    private static final String PH_RULE_START = "rule ";
    private static final String PH_PACKAGE_START = "package ";
    private static final String PH_NEWLINE = "\n";
    private static final String[] RULE_START_MATCHERS = new String[]{"rule \"", "rule\""};
    private static final String[] RULE_END_MATCHERS = new String[]{"end\n", "\nend"};
    private static final String PACKAGE_DELIMETER = ".";
    private static String FUNCTIONS_FILE = null;
    private Package pkg;
    private File file;
    private String imports = "";
    private String dependencyErrors = "";
    private String compilationErrors = "";
    private Map<String, Rule> rules = new HashMap<String, Rule>();
    private List<File> ruleFiles = new ArrayList<File>();
    private String name;

    public static Map<String, PackageFile> buildPackages(CmdArgsParser options) throws Exception {
        String path = options.getOption(CmdArgsParser.Parameters.OPTIONS_PATH);
        FUNCTIONS_FILE = options.getOption(CmdArgsParser.Parameters.OPTIONS_FUNCTIONS_FILE);
        HashMap<String, PackageFile> result = new HashMap<String, PackageFile>();
        File location = new File(path);
        if (!location.isDirectory()) {
            throw new Exception("path must be a directory");
        }
        PackageFile.buildPackageForDirectory(result, location, options);
        return result;
    }

    private static void buildPackageForDirectory(Map<String, PackageFile> packages, File directory, CmdArgsParser options) throws FileNotFoundException, UnsupportedEncodingException, DroolsParserException, IOException {
        boolean recurse = "true".equals(options.getOption(CmdArgsParser.Parameters.OPTIONS_RECURSIVE));
        File[] files = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith(PackageFile.PACKAGE_DELIMETER);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            File[] ruleFiles = PackageFile.getRuleFiles(files[i], options);
            if (ruleFiles.length > 0) {
                PackageFile packageFile = PackageFile.parseRuleFiles(ruleFiles, options);
                packageFile.setName(PackageFile.getPackageName(files[i], options));
                packages.put(packageFile.getName(), packageFile);
                continue;
            }
            if (!recurse) continue;
            PackageFile.buildPackageForDirectory(packages, files[i], options);
        }
    }

    private static File[] getRuleFiles(File directory, CmdArgsParser options) {
        if (directory.isDirectory()) {
            final String extensionList = options.getOption(CmdArgsParser.Parameters.OPTIONS_EXTENSIONS);
            File[] files = directory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !name.startsWith(PackageFile.PACKAGE_DELIMETER) && name.matches(PackageFile.buildRE(extensionList));
                }
            });
            ArrayList<File> result = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.isFile()) continue;
                result.add(f);
            }
            return result.toArray(new File[result.size()]);
        }
        return new File[0];
    }

    private static PackageFile parseRuleFiles(File[] ruleFiles, CmdArgsParser options) throws IOException, DroolsParserException {
        PackageFile result = new PackageFile();
        for (int i = 0; i < ruleFiles.length; ++i) {
            File file = ruleFiles[i];
            if (file.getName().endsWith(".drl")) {
                PackageFile.parseDrlFile(file, result, options);
                result.addRuleFile(file);
                continue;
            }
            if (!file.getName().endsWith(".xls")) continue;
            if (result.getRuleFiles().size() > 1) {
                throw new DroolsParserException("Can't parse more than one .xls decision table file in a single directory [" + file.getParentFile().getPath() + "]");
            }
            PackageFile.parseXlsFile(file, result, options);
            result.addRuleFile(file);
        }
        return result;
    }

    private static void parseXlsFile(File file, PackageFile packageFile, CmdArgsParser options) throws FileNotFoundException, UnsupportedEncodingException {
        String content = FileIO.readAllAsBase64(file);
        packageFile.setName(PackageFile.getPackageName(file, options));
        packageFile.setFile(file);
        packageFile.getRules().put(file.getName(), new Rule(file.getName(), content));
    }

    private static void parseDrlFile(File file, PackageFile packageFile, CmdArgsParser options) throws FileNotFoundException {
        String content = FileIO.readAll(new FileInputStream(file));
        int packageLoc = content.indexOf(PH_PACKAGE_START);
        int ruleLoc = PackageFile.getRuleStart(content, 0);
        if (ruleLoc < 0) {
            return;
        }
        String imports = content.substring(packageLoc, ruleLoc);
        packageFile.addImports(imports);
        try {
            boolean moreRules = true;
            while (moreRules) {
                int endLoc = PackageFile.getLoc(content, ruleLoc, RULE_END_MATCHERS) + 4;
                String ruleContents = content.substring(ruleLoc, endLoc);
                ruleLoc = PackageFile.getRuleStart(content, endLoc);
                moreRules = ruleLoc >= 0;
                Rule rule = new Rule(PackageFile.findRuleName(ruleContents, options), ruleContents);
                packageFile.getRules().put(rule.getRuleName(), rule);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.print("Error with file: " + file.getName() + PH_NEWLINE);
        }
    }

    public void buildPackage() throws IOException, DroolsParserException {
        PackageBuilder pb = new PackageBuilder();
        for (File file : this.getRuleFiles()) {
            File functionsFile;
            if (FUNCTIONS_FILE != null && (functionsFile = new File(file.getParentFile().getPath(), FUNCTIONS_FILE)).exists()) {
                pb.addPackageFromDrl(new FileReader(functionsFile));
            }
            if (this.isFormat(Format.DRL)) {
                pb.addPackageFromDrl(new FileReader(file));
                continue;
            }
            if (!this.isFormat(Format.DRL)) continue;
            pb.addPackageFromDrl(new StringReader(DroolsHelper.compileDTabletoDRL(file, InputType.XLS)));
        }
        this.pkg = pb.getPackage();
        if (this.pkg == null) {
            for (int i = 0; i < pb.getErrors().getErrors().length; ++i) {
                DroolsError msg = pb.getErrors().getErrors()[i];
                this.addCompilationError(msg.getMessage());
            }
        } else if (this.pkg != null && !this.pkg.isValid()) {
            this.addDependencyError(this.pkg.getErrorSummary());
        }
    }

    public void buildPackageWithAccurateDependencyErrorDetection() throws IOException, DroolsParserException {
        PackageBuilder resBuilder = new PackageBuilder();
        for (File file : this.getRuleFiles()) {
            File functionsFile;
            PackageBuilder pb = new PackageBuilder();
            if (FUNCTIONS_FILE != null && (functionsFile = new File(file.getParentFile().getPath(), FUNCTIONS_FILE)).exists()) {
                pb.addPackageFromDrl(new FileReader(functionsFile));
            }
            if (this.isFormat(Format.DRL)) {
                pb.addPackageFromDrl(new FileReader(file));
            } else if (this.isFormat(Format.DRL)) {
                pb.addPackageFromDrl(new StringReader(DroolsHelper.compileDTabletoDRL(file, InputType.XLS)));
            }
            Package check = pb.getPackage();
            if (check == null) {
                for (int i = 0; i < pb.getErrors().getErrors().length; ++i) {
                    DroolsError msg = pb.getErrors().getErrors()[i];
                    this.addCompilationError(msg.getMessage());
                }
            } else if (check != null && !check.isValid()) {
                this.addDependencyError(check.getErrorSummary());
                resBuilder.addPackage(pb.getPackage());
            }
            resBuilder.addPackage(check);
        }
        this.pkg = resBuilder.getPackage();
    }

    public byte[] toByteArray() throws IOException {
        if (this.pkg != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream doos = new DroolsObjectOutputStream(baos);
            doos.writeObject(this.pkg);
            return baos.toByteArray();
        }
        return new byte[0];
    }

    public void addRuleFile(File ruleFile) {
        this.ruleFiles.add(ruleFile);
    }

    public List<File> getRuleFiles() {
        return this.ruleFiles;
    }

    private static String buildRE(String extensions) {
        String RE = ".+\\.({0})$";
        String[] xtns = extensions.split(",");
        for (int i = 0; i < xtns.length; ++i) {
            String xtn = "(" + xtns[i] + ")";
            if (i < xtns.length - 1) {
                xtn = xtn + "|{0}";
            }
            RE = MessageFormat.format(RE, xtn);
        }
        return RE;
    }

    private static String getPackageName(File directory, CmdArgsParser options) {
        String startPath = directory.getPath();
        Matcher m = Pattern.compile("([^/]+)").matcher(startPath);
        ArrayList<String> lpath = new ArrayList<String>();
        while (m.find()) {
            lpath.add(m.group());
        }
        String[] path = lpath.toArray(new String[lpath.size()]);
        StringBuffer sb = new StringBuffer();
        for (int i = path.length - 1; i >= 0; --i) {
            String dir = path[i];
            if (dir.matches(options.getOption(CmdArgsParser.Parameters.OPTIONS_PACKAGE_EXCLUDE))) continue;
            if (dir.equals(options.getOption(CmdArgsParser.Parameters.OPTIONS_PACKAGE_START))) break;
            sb.insert(0, PACKAGE_DELIMETER).insert(0, dir);
        }
        if (sb.substring(sb.length() - 1).equals(PACKAGE_DELIMETER)) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    private static int getRuleStart(String contents, int startLoc) {
        return PackageFile.getLoc(contents, startLoc, RULE_START_MATCHERS);
    }

    private static int getLoc(String contents, int startLoc, String[] markers) {
        int i;
        int[] a = new int[markers.length];
        for (i = 0; i < markers.length; ++i) {
            String marker = markers[i];
            a[i] = contents.indexOf(marker, startLoc);
        }
        for (int x = 0; x < a.length; ++x) {
            i = x;
            for (int j = x + 1; j < a.length; ++j) {
                if (a[j] >= a[i]) continue;
                i = j;
            }
            int tmp = a[x];
            a[x] = a[i];
            a[i] = tmp;
        }
        for (int k = 0; k < a.length; ++k) {
            if (a[k] < 0) continue;
            return a[k];
        }
        return -1;
    }

    private static String findRuleName(String ruleContents, CmdArgsParser options) {
        String name = ruleContents.substring(ruleContents.indexOf(PH_RULE_START) + PH_RULE_START.length(), ruleContents.indexOf(PH_NEWLINE)).replaceAll("\"", "").trim();
        if (!name.matches("[^'^/^<^>.]+")) {
            if ("true".equals(options.getOption(CmdArgsParser.Parameters.OPTIONS_VERBOSE))) {
                System.out.println("WARNING: fixing invalid rule name [old name=" + name + "]");
            }
            name = name.replaceAll("'", "");
            name = name.replaceAll("/", "-");
            name = name.replaceAll("<", "&lt;");
            name = name.replaceAll(">", "&gt;");
        }
        return name;
    }

    public boolean isFormat(Format isFormat) {
        if (this.ruleFiles != null && this.ruleFiles.size() > 0) {
            String name = this.ruleFiles.get(0).getName().toLowerCase();
            return name.endsWith(isFormat.value);
        }
        return false;
    }

    public String getFormat() {
        if (this.ruleFiles != null && this.ruleFiles.size() > 0) {
            String name = this.ruleFiles.get(0).getName().toLowerCase();
            if (name.endsWith("drl")) {
                return "drl";
            }
            if (name.endsWith("xls")) {
                return "xls";
            }
        }
        return "";
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getDependencyErrors() {
        return this.dependencyErrors;
    }

    public void setDependencyErrors(String dependencyErrors) {
        this.dependencyErrors = dependencyErrors;
    }

    public boolean hasDependencyErrors() {
        return this.dependencyErrors.length() > 0;
    }

    public void addDependencyError(String dependencyError) {
        this.dependencyErrors = this.dependencyErrors + dependencyError + PH_NEWLINE;
    }

    public String getCompilationErrors() {
        return this.compilationErrors;
    }

    public void setCompilationErrors(String compilationErrors) {
        this.compilationErrors = compilationErrors;
    }

    public boolean hasCompilationErrors() {
        return this.compilationErrors.length() > 0;
    }

    public void addCompilationError(String compilationError) {
        this.compilationErrors = this.compilationErrors + compilationError + PH_NEWLINE;
    }

    public boolean hasErrors() {
        return this.hasCompilationErrors() || this.hasDependencyErrors();
    }

    public Package getPkg() {
        return this.pkg;
    }

    public void setPkg(Package pkg) {
        this.pkg = pkg;
    }

    public String getImports() {
        return this.imports;
    }

    public void addImports(String imports) {
        StringBuffer sb = new StringBuffer(imports);
        if (imports.length() > 0) {
            int posPackage = imports.indexOf(PH_PACKAGE_START);
            sb.delete(posPackage, imports.indexOf(PH_NEWLINE, posPackage));
        }
        this.imports = new StringBuffer().append(imports).append(PH_NEWLINE).append(sb).toString();
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public void setRules(Map<String, Rule> rules) {
        this.rules = rules;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "PackageFile[name=" + this.name + ",format=" + this.getFormat() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Format {
        DRL(".drl"),
        XLS(".xls");

        String value;

        private Format(String value) {
            this.value = value;
        }
    }
}

