/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BLOBInDataStore
extends BLOBFileValue {
    private final DataStore store;
    private final DataIdentifier identifier;
    private static final String PREFIX = "dataStore:";
    private static Logger log = LoggerFactory.getLogger(BLOBInDataStore.class);

    private BLOBInDataStore(DataStore store, DataIdentifier identifier) {
        assert (store != null);
        assert (identifier != null);
        this.store = store;
        this.identifier = identifier;
    }

    void delete(boolean pruneEmptyParentDirs) {
    }

    public void dispose() {
    }

    DataIdentifier getDataIdentifier() {
        return this.identifier;
    }

    BLOBFileValue copy() throws RepositoryException {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BLOBInDataStore) || obj == null) {
            return false;
        }
        BLOBInDataStore other = (BLOBInDataStore)obj;
        return this.store == other.store && this.identifier.equals(other.identifier);
    }

    public int hashCode() {
        return 0;
    }

    public long getSize() {
        try {
            return this.getDataRecord().getLength();
        }
        catch (DataStoreException e) {
            log.warn("getSize for " + this.identifier + " failed", e);
            return -1L;
        }
    }

    public InputStream getStream() throws RepositoryException {
        return this.getDataRecord().getStream();
    }

    public String toString() {
        return PREFIX + this.identifier;
    }

    static BLOBInDataStore getInstance(DataStore store, String s) {
        String id = s.substring(PREFIX.length());
        DataIdentifier identifier = new DataIdentifier(id);
        return new BLOBInDataStore(store, identifier);
    }

    static BLOBInDataStore getInstance(DataStore store, DataIdentifier identifier) {
        return new BLOBInDataStore(store, identifier);
    }

    static BLOBInDataStore getInstance(DataStore store, InputStream in) throws DataStoreException {
        DataRecord rec = store.addRecord(in);
        DataIdentifier identifier = rec.getIdentifier();
        return new BLOBInDataStore(store, identifier);
    }

    static boolean isInstance(String s) {
        return s.startsWith(PREFIX);
    }

    private DataRecord getDataRecord() throws DataStoreException {
        return this.store.getRecord(this.identifier);
    }

    boolean usesDataStore(DataStore s) {
        return this.store == s;
    }
}

