/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.record.PersistRecord;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class ExOleObjStg
extends RecordAtom
implements PositionDependentRecord,
PersistRecord {
    private int _persistId;
    private byte[] _header = new byte[8];
    private byte[] _data;
    protected int myLastOnDiskOffset;

    public ExOleObjStg() {
        this._data = new byte[0];
        LittleEndian.putShort(this._header, 0, (short)16);
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected ExOleObjStg(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public int getDataLength() {
        return LittleEndian.getInt(this._data, 0);
    }

    public InputStream getData() {
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(this._data, 4, this._data.length);
        return new InflaterInputStream(compressedStream);
    }

    public byte[] getRawData() {
        return this._data;
    }

    public void setData(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[4];
        LittleEndian.putInt(b, data.length);
        out.write(b);
        DeflaterOutputStream def = new DeflaterOutputStream(out);
        def.write(data, 0, data.length);
        def.finish();
        this._data = out.toByteArray();
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    public long getRecordType() {
        return RecordTypes.ExOleObjStg.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public int getPersistId() {
        return this._persistId;
    }

    public void setPersistId(int id) {
        this._persistId = id;
    }

    public int getLastOnDiskOffset() {
        return this.myLastOnDiskOffset;
    }

    public void setLastOnDiskOffset(int offset) {
        this.myLastOnDiskOffset = offset;
    }

    public void updateOtherRecordReferences(Hashtable oldToNewReferencesLookup) {
    }
}

