/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public final class ListFormatOverrideLevel {
    private static final int BASE_SIZE = 8;
    int _iStartAt;
    byte _info;
    private static BitField _ilvl = BitFieldFactory.getInstance(15);
    private static BitField _fStartAt = BitFieldFactory.getInstance(16);
    private static BitField _fFormatting = BitFieldFactory.getInstance(32);
    byte[] _reserved = new byte[3];
    ListLevel _lvl;

    public ListFormatOverrideLevel(byte[] buf, int offset) {
        this._iStartAt = LittleEndian.getInt(buf, offset);
        offset += 4;
        this._info = buf[offset++];
        System.arraycopy(buf, offset, this._reserved, 0, this._reserved.length);
        offset += this._reserved.length;
        if (_fFormatting.getValue(this._info) > 0) {
            this._lvl = new ListLevel(buf, offset);
        }
    }

    public ListLevel getLevel() {
        return this._lvl;
    }

    public int getLevelNum() {
        return _ilvl.getValue(this._info);
    }

    public boolean isFormatting() {
        return _fFormatting.getValue(this._info) != 0;
    }

    public boolean isStartAt() {
        return _fStartAt.getValue(this._info) != 0;
    }

    public int getSizeInBytes() {
        return this._lvl == null ? 8 : 8 + this._lvl.getSizeInBytes();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListFormatOverrideLevel lfolvl = (ListFormatOverrideLevel)obj;
        boolean lvlEquality = false;
        lvlEquality = this._lvl != null ? this._lvl.equals(lfolvl._lvl) : lfolvl._lvl == null;
        return lvlEquality && lfolvl._iStartAt == this._iStartAt && lfolvl._info == this._info && Arrays.equals(lfolvl._reserved, this._reserved);
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.getSizeInBytes()];
        int offset = 0;
        LittleEndian.putInt(buf, this._iStartAt);
        offset += 4;
        buf[offset++] = this._info;
        System.arraycopy(this._reserved, 0, buf, offset, 3);
        offset += 3;
        if (this._lvl != null) {
            byte[] levelBuf = this._lvl.toByteArray();
            System.arraycopy(levelBuf, 0, buf, offset, levelBuf.length);
        }
        return buf;
    }

    public int getIStartAt() {
        return this._iStartAt;
    }
}

