/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.extensions;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public class XSSFCellBorder {
    private CTBorder border;

    public XSSFCellBorder(CTBorder border) {
        this.border = border;
    }

    public XSSFCellBorder() {
        this.border = CTBorder.Factory.newInstance();
    }

    @Internal
    public CTBorder getCTBorder() {
        return this.border;
    }

    public BorderStyle getBorderStyle(BorderSide side) {
        CTBorderPr ctBorder = this.getBorder(side);
        STBorderStyle.Enum border = ctBorder == null ? STBorderStyle.NONE : ctBorder.getStyle();
        return BorderStyle.values()[border.intValue() - 1];
    }

    public void setBorderStyle(BorderSide side, BorderStyle style) {
        this.getBorder(side, true).setStyle(STBorderStyle.Enum.forInt(style.ordinal() + 1));
    }

    public XSSFColor getBorderColor(BorderSide side) {
        CTBorderPr borderPr = this.getBorder(side);
        return borderPr != null && borderPr.isSetColor() ? new XSSFColor(borderPr.getColor()) : null;
    }

    public void setBorderColor(BorderSide side, XSSFColor color) {
        CTBorderPr borderPr = this.getBorder(side, true);
        if (color == null) {
            borderPr.unsetColor();
        } else {
            borderPr.setColor(color.getCTColor());
        }
    }

    private CTBorderPr getBorder(BorderSide side) {
        return this.getBorder(side, false);
    }

    private CTBorderPr getBorder(BorderSide side, boolean ensure) {
        CTBorderPr borderPr;
        switch (side) {
            case TOP: {
                borderPr = this.border.getTop();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewTop();
                break;
            }
            case RIGHT: {
                borderPr = this.border.getRight();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewRight();
                break;
            }
            case BOTTOM: {
                borderPr = this.border.getBottom();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewBottom();
                break;
            }
            case LEFT: {
                borderPr = this.border.getLeft();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewLeft();
                break;
            }
            default: {
                throw new IllegalArgumentException("No suitable side specified for the border");
            }
        }
        return borderPr;
    }

    public int hashCode() {
        return this.border.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFCellBorder)) {
            return false;
        }
        XSSFCellBorder cf = (XSSFCellBorder)o;
        return this.border.toString().equals(cf.getCTBorder().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderSide {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

