/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PackageExtractor {
    private final ContentHandler handler;
    private final Metadata metadata;
    private final EmbeddedDocumentExtractor extractor;

    public PackageExtractor(ContentHandler handler, Metadata metadata, ParseContext context) {
        this.handler = handler;
        this.metadata = metadata;
        this.extractor = new EmbeddedDocumentExtractor(context);
    }

    public void parse(InputStream stream) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(this.handler, this.metadata);
        xhtml.startDocument();
        stream = new CloseShieldInputStream(stream);
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(2);
        int a = stream.read();
        int b = stream.read();
        stream.reset();
        if (a == 66 && b == 90) {
            this.metadata.set("Content-Type", "application/x-bzip");
            this.decompress(new BZip2CompressorInputStream(stream), xhtml);
        } else if (a == 31 && b == 139) {
            this.metadata.set("Content-Type", "application/x-gzip");
            this.decompress(new GZIPInputStream(stream), xhtml);
        } else if (a == 80 && b == 75) {
            this.metadata.set("Content-Type", "application/zip");
            this.unpack(new ZipArchiveInputStream(stream), xhtml);
        } else if (a == 48 && b == 55 || a == 113 && b == 199 || a == 199 && b == 113) {
            this.metadata.set("Content-Type", "application/x-cpio");
            this.unpack(new CpioArchiveInputStream(stream), xhtml);
        } else if (a == 61 && (b == 60 || b == 33)) {
            this.metadata.set("Content-Type", "application/x-archive");
            this.unpack(new ArArchiveInputStream(stream), xhtml);
        } else {
            this.metadata.set("Content-Type", "application/x-tar");
            this.unpack(new TarArchiveInputStream(stream), xhtml);
        }
        xhtml.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(InputStream stream, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        try {
            Metadata entrydata = new Metadata();
            String name = this.metadata.get("resourceName");
            if (name != null) {
                if (name.endsWith(".tbz")) {
                    name = name.substring(0, name.length() - 4) + ".tar";
                } else if (name.endsWith(".tbz2")) {
                    name = name.substring(0, name.length() - 5) + ".tar";
                } else if (name.endsWith(".bz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".bz2")) {
                    name = name.substring(0, name.length() - 4);
                } else if (name.length() > 0) {
                    name = GzipUtils.getUncompressedFilename(name);
                }
                entrydata.set("resourceName", name);
            }
            if (this.extractor.shouldParseEmbedded(entrydata)) {
                this.extractor.parseEmbedded(stream, xhtml, entrydata, true);
            }
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(ArchiveInputStream archive, XHTMLContentHandler xhtml) throws IOException, SAXException {
        try {
            ArchiveEntry entry = archive.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Metadata entrydata = new Metadata();
                    String name = entry.getName();
                    if (name != null && name.length() > 0) {
                        entrydata.set("resourceName", name);
                    }
                    if (this.extractor.shouldParseEmbedded(entrydata)) {
                        this.extractor.parseEmbedded(archive, xhtml, entrydata, true);
                    }
                }
                entry = archive.getNextEntry();
            }
        }
        finally {
            archive.close();
        }
    }
}

