/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTFParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("rtf"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try {
            CustomStyledDocument sd = new CustomStyledDocument();
            new RTFEditorKit().read(stream, (Document)sd, 0);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.element("p", sd.getText(0, sd.getLength()));
            xhtml.endDocument();
        }
        catch (BadLocationException e) {
            throw new TikaException("Error parsing an RTF document", e);
        }
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private static class NoReclaimStyleContext
    extends StyleContext {
        private NoReclaimStyleContext() {
        }

        public void reclaim(AttributeSet a) {
        }
    }

    private static class CustomStyledDocument
    extends DefaultStyledDocument {
        public CustomStyledDocument() {
            super(new NoReclaimStyleContext());
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (offs > 0 && offs == this.getLength()) {
                super.insertString(offs, " ", a);
                super.insertString(this.getLength(), str, a);
            } else {
                super.insertString(offs, str, a);
            }
        }
    }
}

