/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.util.Collection;
import java.util.Properties;
import org.drools.RuleBase;
import org.drools.RuntimeDroolsException;
import org.drools.agent.AgentEventListener;
import org.drools.agent.PackageChangeInfo;
import org.drools.rule.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageProvider {
    protected AgentEventListener listener;

    abstract PackageChangeInfo loadPackageChanges();

    abstract void configure(Properties var1);

    static void removePackage(String name, RuleBase rb) {
        Package[] ps = rb.getPackages();
        if (ps == null) {
            return;
        }
        for (int i = 0; i < ps.length; ++i) {
            Package p = ps[i];
            if (!p.getName().equals(name)) continue;
            rb.removePackage(name);
            return;
        }
    }

    static void removePackages(Collection<String> removedPackages, RuleBase rb, AgentEventListener listener) {
        for (String name : removedPackages) {
            listener.info("Removing package called " + name);
            PackageProvider.removePackage(name, rb);
        }
    }

    static void applyChanges(RuleBase rb, boolean removeExistingPackages, Collection changes, AgentEventListener listener) {
        PackageProvider.applyChanges(rb, removeExistingPackages, changes, null, listener);
    }

    static void applyChanges(RuleBase rb, boolean removeExistingPackages, Collection changes, Collection<String> removed, AgentEventListener listener) {
        if (changes == null && removed == null) {
            return;
        }
        rb.lock();
        if (removed != null) {
            PackageProvider.removePackages(removed, rb, listener);
        }
        if (changes != null) {
            for (Package p : changes) {
                if (removeExistingPackages) {
                    PackageProvider.removePackage(p.getName(), rb);
                }
                try {
                    listener.info("Adding package called " + p.getName());
                    rb.addPackage(p);
                }
                catch (Exception e) {
                    throw new RuntimeDroolsException(e);
                }
            }
        }
        rb.unlock();
    }

    public void setAgentListener(AgentEventListener listener) {
        this.listener = listener;
    }
}

