/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.common.EqualityKey;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.StringUtils;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

@XmlRootElement(name="fact-handle")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFactHandle
implements InternalFactHandle,
Serializable {
    private static final long serialVersionUID = 510L;
    private int id;
    private long recency;
    private Object object;
    private EqualityKey key;
    private int objectHashCode;
    private int identityHashCode;
    public RightTuple firstRightTuple;
    public RightTuple lastRightTuple;
    public LeftTuple firstLeftTuple;
    public LeftTuple lastLeftTuple;
    private WorkingMemoryEntryPoint entryPoint;
    private boolean disconnected;

    public DefaultFactHandle() {
    }

    public DefaultFactHandle(int id, Object object) {
        this(id, object, id, null);
    }

    public DefaultFactHandle(int id, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint);
    }

    public DefaultFactHandle(int id, int identityHashCode, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this.id = id;
        this.entryPoint = wmEntryPoint;
        this.recency = recency;
        this.object = object;
        this.objectHashCode = object != null ? object.hashCode() : 0;
        this.identityHashCode = identityHashCode;
    }

    public DefaultFactHandle(int id, String wmEntryPointId, int identityHashCode, int objectHashCode, long recency, Object object) {
        this.id = id;
        this.entryPoint = wmEntryPointId == null ? null : new DisconnectedWorkingMemoryEntryPoint(wmEntryPointId);
        this.identityHashCode = identityHashCode;
        this.objectHashCode = objectHashCode;
        this.recency = recency;
        this.object = object;
        this.disconnected = true;
    }

    public DefaultFactHandle(String externalFormat) {
        this.createFromExternalFormat(externalFormat);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultFactHandle)) {
            return false;
        }
        return this.id == ((DefaultFactHandle)object).id;
    }

    public void disconnect() {
        this.key = null;
        this.firstLeftTuple = null;
        this.firstRightTuple = null;
        this.lastLeftTuple = null;
        this.lastRightTuple = null;
        this.entryPoint = this.entryPoint == null ? null : new DisconnectedWorkingMemoryEntryPoint(this.entryPoint.getEntryPointId());
        this.disconnected = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public int getObjectHashCode() {
        return this.objectHashCode;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static int determineIdentityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    protected void setObjectHashCode(int hashCode) {
        this.objectHashCode = hashCode;
    }

    public int hashCode() {
        return this.id;
    }

    public String toExternalForm() {
        return "0:" + this.id + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (this.entryPoint != null ? this.entryPoint.getEntryPointId() : "null");
    }

    @XmlAttribute(name="external-form")
    public String getExternalForm() {
        return this.toExternalForm();
    }

    public void setExternalForm(String externalForm) {
        this.createFromExternalFormat(externalForm);
    }

    public String toString() {
        return "[fact " + this.toExternalForm() + ":" + this.object + "]";
    }

    public long getRecency() {
        return this.recency;
    }

    public void setRecency(long recency) {
        this.recency = recency;
    }

    public int getId() {
        return this.id;
    }

    public void invalidate() {
        this.id = -1;
        this.object = null;
        this.entryPoint = null;
    }

    public boolean isValid() {
        return this.id != -1;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
        this.objectHashCode = object != null ? object.hashCode() : 0;
        this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
    }

    public EqualityKey getEqualityKey() {
        return this.key;
    }

    public void setEqualityKey(EqualityKey key) {
        this.key = key;
    }

    public boolean isEvent() {
        return false;
    }

    public RightTuple getFirstRightTuple() {
        return this.firstRightTuple;
    }

    public void setFirstRightTuple(RightTuple firstRightTuple) {
        this.firstRightTuple = firstRightTuple;
    }

    public RightTuple getLastRightTuple() {
        return this.lastRightTuple;
    }

    public void setLastRightTuple(RightTuple lastRightTuple) {
        this.lastRightTuple = lastRightTuple;
    }

    public void setFirstLeftTuple(LeftTuple firstLeftTuple) {
        this.firstLeftTuple = firstLeftTuple;
    }

    public LeftTuple getFirstLeftTuple() {
        return this.firstLeftTuple;
    }

    public void setLastLeftTuple(LeftTuple lastLeftTuple) {
        this.lastLeftTuple = lastLeftTuple;
    }

    public LeftTuple getLastLeftTuple() {
        return this.lastLeftTuple;
    }

    public WorkingMemoryEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(WorkingMemoryEntryPoint sourceNode) {
        this.entryPoint = sourceNode;
    }

    public DefaultFactHandle clone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.object, this.recency, this.entryPoint);
        clone.key = this.key;
        clone.firstLeftTuple = this.firstLeftTuple;
        clone.lastLeftTuple = this.lastLeftTuple;
        clone.firstRightTuple = this.firstRightTuple;
        clone.lastRightTuple = this.lastRightTuple;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = System.identityHashCode(clone.object);
        clone.disconnected = this.disconnected;
        return clone;
    }

    public String toTupleTree(int indent) {
        StringBuilder buf = new StringBuilder();
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        String istr = new String(spaces);
        buf.append(istr);
        buf.append(this.toExternalString());
        buf.append("\n");
        for (LeftTuple leftTuple = this.firstLeftTuple; leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            buf.append(leftTuple.toTupleTree(indent + 4));
        }
        return buf.toString();
    }

    private Object toExternalString() {
        return "[F:" + this.getId() + " first=" + System.identityHashCode(this.firstLeftTuple) + " last=" + System.identityHashCode(this.lastLeftTuple) + " ]";
    }

    private void createFromExternalFormat(String externalFormat) {
        String[] elements = externalFormat.split(":");
        if (elements.length != 6) {
            throw new IllegalArgumentException("externalFormat did not have enough elements");
        }
        this.id = Integer.parseInt(elements[1]);
        this.identityHashCode = Integer.parseInt(elements[2]);
        this.objectHashCode = Integer.parseInt(elements[3]);
        this.recency = Long.parseLong(elements[4]);
        this.entryPoint = StringUtils.isEmpty(elements[5]) || "null".equals(elements[5].trim()) ? null : new DisconnectedWorkingMemoryEntryPoint(elements[5].trim());
        this.disconnected = true;
    }
}

