/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.ObjectHashSet;
import org.drools.definition.rule.Rule;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.rule.EntryPoint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropagationContextImpl
implements PropagationContext {
    private static final long serialVersionUID = 510L;
    private int type;
    private org.drools.rule.Rule rule;
    private LeftTuple leftTuple;
    private InternalFactHandle factHandle;
    private long propagationNumber;
    public int activeActivations;
    public int dormantActivations;
    private EntryPoint entryPoint;
    private int originOffset;
    private ObjectHashSet propagationAttempts;
    private ObjectTypeNode currentPropagatingOTN;
    private boolean shouldPropagateAll;
    private LinkedList<WorkingMemoryAction> queue1;
    private LinkedList<WorkingMemoryAction> queue2;
    private ObjectType objectType;
    private MarshallerReaderContext readerContext;

    public PropagationContextImpl() {
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle) {
        this(number, type, rule, leftTuple, factHandle, 0, 0, EntryPoint.DEFAULT, null);
        this.originOffset = -1;
        this.shouldPropagateAll = true;
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint) {
        this(number, type, rule, leftTuple, factHandle, activeActivations, dormantActivations, entryPoint, null);
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint, MarshallerReaderContext readerContext) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.activeActivations = activeActivations;
        this.dormantActivations = dormantActivations;
        this.entryPoint = entryPoint;
        this.originOffset = -1;
        this.readerContext = readerContext;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.activeActivations = in.readInt();
        this.dormantActivations = in.readInt();
        this.propagationNumber = in.readLong();
        this.rule = (org.drools.rule.Rule)in.readObject();
        this.leftTuple = (LeftTuple)in.readObject();
        this.entryPoint = (EntryPoint)in.readObject();
        this.originOffset = in.readInt();
        this.propagationAttempts = (ObjectHashSet)in.readObject();
        this.currentPropagatingOTN = (ObjectTypeNode)in.readObject();
        this.shouldPropagateAll = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeInt(this.activeActivations);
        out.writeInt(this.dormantActivations);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.leftTuple);
        out.writeObject(this.entryPoint);
        out.writeInt(this.originOffset);
        out.writeObject(this.propagationAttempts);
        out.writeObject(this.currentPropagatingOTN);
        out.writeObject(this.shouldPropagateAll);
    }

    @Override
    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    @Override
    public org.drools.rule.Rule getRuleOrigin() {
        return this.rule;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public LeftTuple getLeftTupleOrigin() {
        return this.leftTuple;
    }

    @Override
    public InternalFactHandle getFactHandleOrigin() {
        return this.factHandle;
    }

    @Override
    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getActiveActivations() {
        return this.activeActivations;
    }

    @Override
    public int getDormantActivations() {
        return this.dormantActivations;
    }

    @Override
    public void releaseResources() {
        this.leftTuple = null;
        this.rule = null;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public int getOriginOffset() {
        return this.originOffset;
    }

    @Override
    public void setOriginOffset(int originOffset) {
        this.originOffset = originOffset;
    }

    @Override
    public ObjectHashSet getPropagationAttemptsMemory() {
        if (this.propagationAttempts == null) {
            this.propagationAttempts = new ObjectHashSet();
        }
        return this.propagationAttempts;
    }

    @Override
    public boolean isPropagating(ObjectTypeNode otn) {
        return this.currentPropagatingOTN != null && this.currentPropagatingOTN.equals(otn);
    }

    @Override
    public void setCurrentPropagatingOTN(ObjectTypeNode otn) {
        this.currentPropagatingOTN = otn;
    }

    @Override
    public void setShouldPropagateAll(Object node) {
        this.shouldPropagateAll = this.getPropagationAttemptsMemory().contains(node);
    }

    @Override
    public boolean shouldPropagateAll() {
        return this.shouldPropagateAll;
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue1() {
        if (this.queue1 == null) {
            this.queue1 = new LinkedList();
        }
        return this.queue1;
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue2() {
        if (this.queue2 == null) {
            this.queue2 = new LinkedList();
        }
        return this.queue2;
    }

    @Override
    public void evaluateActionQueue(InternalWorkingMemory workingMemory) {
        if (this.queue1 == null && this.queue2 == null) {
            return;
        }
        boolean repeat = true;
        block0: while (repeat) {
            WorkingMemoryAction action;
            if (this.queue1 != null) {
                action = null;
                while ((action = !this.queue1.isEmpty() ? this.queue1.removeFirst() : null) != null) {
                    action.execute(workingMemory);
                }
            }
            repeat = false;
            if (this.queue2 == null) continue;
            action = null;
            while ((action = !this.queue2.isEmpty() ? this.queue2.removeFirst() : null) != null) {
                action.execute(workingMemory);
                if (this.queue1 == null || this.queue1.isEmpty()) continue;
                repeat = true;
                continue block0;
            }
        }
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public MarshallerReaderContext getReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "PropagationContextImpl [activeActivations=" + this.activeActivations + ", dormantActivations=" + this.dormantActivations + ", entryPoint=" + this.entryPoint + ", factHandle=" + this.factHandle + ", leftTuple=" + this.leftTuple + ", originOffset=" + this.originOffset + ", propagationNumber=" + this.propagationNumber + ", rule=" + this.rule + ", type=" + this.type + "]";
    }
}

