/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.security.PermissionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfo {
    private static final Logger log = LoggerFactory.getLogger(UserInfo.class);
    Node userInfoNode;

    public UserInfo(RulesRepository repo) throws RulesRepositoryException {
        try {
            this.init(repo, repo.getSession().getUserID());
        }
        catch (RepositoryException e) {
            log.error("Unable to init UserInfo", e);
            throw new RulesRepositoryException(e);
        }
    }

    UserInfo() {
    }

    public UserInfo(RulesRepository repo, String userName) throws RulesRepositoryException {
        try {
            this.init(repo, userName);
        }
        catch (RepositoryException e) {
            log.error("Unable to init UserInfo", e);
            throw new RulesRepositoryException(e);
        }
    }

    void init(RulesRepository repo, String userName) throws RepositoryException {
        this.userInfoNode = PermissionManager.getUserInfoNode(userName, repo);
    }

    public List<InboxEntry> readEntries(String fileName, String propertyName) throws RulesRepositoryException {
        try {
            Val property = this.getProperty(fileName, propertyName);
            if (property.value != null && !property.value.equals("")) {
                return (List)this.getXStream().fromXML(property.value);
            }
            return new ArrayList<InboxEntry>();
        }
        catch (RepositoryException e) {
            log.error("Unable to readEntries", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void writeEntries(String fileName, String boxName, List<InboxEntry> entries) throws RulesRepositoryException {
        try {
            String entry = this.getXStream().toXML(entries);
            this.setProperty(fileName, boxName, new Val(entry));
        }
        catch (RepositoryException e) {
            log.error("Unable to writeEntries", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void clear(String fileName, String boxName) {
        try {
            this.setProperty(fileName, boxName, new Val(""));
        }
        catch (RepositoryException e) {
            log.error("Unable to clear", e);
            throw new RulesRepositoryException(e);
        }
    }

    private XStream getXStream() {
        XStream xs = new XStream();
        xs.alias("inbox-entries", List.class);
        xs.alias("entry", InboxEntry.class);
        return xs;
    }

    public void setProperty(String fileName, String propertyName, Val value) throws RepositoryException {
        Node inboxNode = PermissionManager.getNode(this.userInfoNode, fileName, "nt:file");
        if (inboxNode.hasNode("jcr:content")) {
            inboxNode.getNode("jcr:content").setProperty(propertyName, value.value);
        } else {
            inboxNode.addNode("jcr:content", "nt:unstructured").setProperty(propertyName, value.value);
        }
    }

    public Val getProperty(String fileName, String propertyName) throws RepositoryException {
        Node inboxNode = PermissionManager.getNode(this.userInfoNode, fileName, "nt:file");
        if (inboxNode.hasNode("jcr:content")) {
            if (inboxNode.getNode("jcr:content").hasProperty(propertyName)) {
                return new Val(inboxNode.getNode("jcr:content").getProperty(propertyName).getString());
            }
            return new Val("");
        }
        inboxNode.addNode("jcr:content", "nt:unstructured");
        return new Val("");
    }

    public static void eachUser(RulesRepository repository, Command c) throws RulesRepositoryException {
        try {
            NodeIterator nit = PermissionManager.getUsersRootNode(PermissionManager.getRootNode(repository)).getNodes();
            while (nit.hasNext()) {
                c.process(nit.nextNode().getName());
            }
        }
        catch (RepositoryException e) {
            log.error("Unable to eachUser", e);
            throw new RulesRepositoryException(e);
        }
    }

    public void save() throws RulesRepositoryException {
        try {
            this.userInfoNode.getParent().getParent().save();
        }
        catch (RepositoryException e) {
            log.error("Unable to save", e);
            throw new RulesRepositoryException(e);
        }
    }

    public static interface Command {
        public void process(String var1) throws RulesRepositoryException;
    }

    public static class Val {
        public String value;

        public Val(String s) {
            this.value = s;
        }
    }

    public static class InboxEntry {
        public String from;
        public String assetUUID;
        public String note;
        public long timestamp;

        public InboxEntry() {
        }

        public InboxEntry(String assetId, String note, String userFrom) {
            this.assetUUID = assetId;
            this.note = note;
            this.timestamp = System.currentTimeMillis();
            this.from = userFrom;
        }
    }
}

