/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.jackrabbit;

import java.io.InputStreamReader;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.core.RepositoryFactoryImpl;
import org.apache.jackrabbit.core.TransientRepository;
import org.drools.repository.JCRRepositoryConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitRepositoryConfigurator
extends JCRRepositoryConfigurator {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitRepositoryConfigurator.class);

    public JackrabbitRepositoryConfigurator() {
        defaultJCRImplClass = RepositoryFactoryImpl.class.getName();
    }

    public Repository getJCRRepository(Properties properties) throws RepositoryException {
        String repoRootDir = properties.getProperty("repository.root.directory");
        this.repository = repoRootDir == null ? new TransientRepository() : new TransientRepository(repoRootDir + "/repository.xml", repoRootDir);
        return this.repository;
    }

    public Session login(String userName) throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials(userName, "password".toCharArray());
        return this.repository.login(credentials);
    }

    public void registerNodeTypesFromCndFile(String cndFileName, Session session, Workspace workspace) throws RepositoryException {
        try {
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(cndFileName));
            CndImporter.registerNodeTypes(in, session);
        }
        catch (Exception e) {
            throw new RepositoryException("Registering node types for repository failed.", e);
        }
    }

    public void shutdown() {
        if (this.repository instanceof TransientRepository) {
            ((TransientRepository)this.repository).shutdown();
        }
    }
}

