/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.drools.RuntimeDroolsException;
import org.drools.core.util.KeyStoreHelper;
import org.drools.core.util.StringUtils;
import org.drools.rule.ConditionalElement;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.EvalCondition;
import org.drools.rule.Function;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.Wireable;
import org.drools.util.CompositeClassLoader;
import org.drools.util.FastClassLoader;

public class JavaDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private static final long serialVersionUID = 510L;
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JavaDialectRuntimeData.class.getProtectionDomain();
        }
    });
    private Map invokerLookups;
    private Map store;
    private DialectRuntimeRegistry registry;
    private transient PackageClassLoader classLoader;
    private transient CompositeClassLoader rootClassLoader;
    private boolean dirty = false;
    private List<String> wireList = Collections.emptyList();

    public JavaDialectRuntimeData() {
        this.invokerLookups = new HashMap();
        this.store = new HashMap();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        KeyStoreHelper helper = new KeyStoreHelper();
        stream.writeBoolean(helper.isSigned());
        if (helper.isSigned()) {
            stream.writeObject(helper.getPvtKeyAlias());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeInt(this.store.size());
        for (Map.Entry entry : this.store.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.flush();
        out.close();
        byte[] buff = bos.toByteArray();
        stream.writeObject(buff);
        if (helper.isSigned()) {
            this.sign(stream, helper, buff);
        }
        stream.writeInt(this.invokerLookups.size());
        for (Map.Entry entry : this.invokerLookups.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    private void sign(ObjectOutput stream, KeyStoreHelper helper, byte[] buff) {
        try {
            stream.writeObject(helper.signDataWithPrivateKey(buff));
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Error signing object store: " + e.getMessage(), e);
        }
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i;
        KeyStoreHelper helper = new KeyStoreHelper();
        boolean signed = stream.readBoolean();
        if (helper.isSigned() != signed) {
            throw new RuntimeDroolsException("This environment is configured to work with " + (helper.isSigned() ? "signed" : "unsigned") + " serialized objects, but the given object is " + (signed ? "signed" : "unsigned") + ". Deserialization aborted.");
        }
        String pubKeyAlias = null;
        if (signed) {
            pubKeyAlias = (String)stream.readObject();
            if (helper.getPubKeyStore() == null) {
                throw new RuntimeDroolsException("The package was serialized with a signature. Please configure a public keystore with the public key to check the signature. Deserialization aborted.");
            }
        }
        byte[] bytes = (byte[])stream.readObject();
        if (signed) {
            this.checkSignature(stream, helper, bytes, pubKeyAlias);
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        int length = in.readInt();
        for (i = 0; i < length; ++i) {
            this.store.put(in.readObject(), in.readObject());
        }
        in.close();
        length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.invokerLookups.put(stream.readObject(), stream.readObject());
        }
        this.dirty = true;
    }

    private void checkSignature(ObjectInput stream, KeyStoreHelper helper, byte[] bytes, String pubKeyAlias) throws ClassNotFoundException, IOException {
        byte[] signature = (byte[])stream.readObject();
        try {
            if (!helper.checkDataWithPublicKey(pubKeyAlias, bytes, signature)) {
                throw new RuntimeDroolsException("Signature does not match serialized package. This is a security violation. Deserialisation aborted.");
            }
        }
        catch (InvalidKeyException e) {
            throw new RuntimeDroolsException("Invalid key checking signature: " + e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeDroolsException("Error accessing Key Store: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeDroolsException("No algorithm available: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new RuntimeDroolsException("Signature Exception: " + e.getMessage(), e);
        }
    }

    public void onAdd(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        this.registry = registry;
        this.rootClassLoader = rootClassLoader;
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        this.rootClassLoader.addClassLoader(this.classLoader);
    }

    public void onRemove() {
        this.rootClassLoader.removeClassLoader(this.classLoader);
    }

    public void onBeforeExecute() {
        if (this.isDirty()) {
            this.reload();
        } else if (!this.wireList.isEmpty()) {
            try {
                for (String resourceName : this.wireList) {
                    this.wire(JavaDialectRuntimeData.convertResourceToClassName(resourceName));
                }
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Unable to wire up JavaDialect", e);
            }
        }
        this.wireList.clear();
    }

    public DialectRuntimeData clone(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        JavaDialectRuntimeData cloneOne = new JavaDialectRuntimeData();
        cloneOne.merge(registry, this);
        cloneOne.onAdd(registry, rootClassLoader);
        return cloneOne;
    }

    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.registry = registry;
        JavaDialectRuntimeData newJavaData = (JavaDialectRuntimeData)newData;
        for (String resourceName : newJavaData.list()) {
            this.write(resourceName, newJavaData.read(resourceName));
        }
        this.putAllInvokers(newJavaData.getInvokers());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected Map getStore() {
        if (this.store == null) {
            this.store = new HashMap();
        }
        return this.store;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void removeRule(Package pkg, Rule rule) {
        String consequenceName;
        if (!(rule instanceof Query) && this.remove(consequenceName = rule.getConsequence().getClass().getName())) {
            this.removeClasses(rule.getLhs());
            String sufix = StringUtils.ucFirst(rule.getConsequence().getName()) + "ConsequenceInvoker";
            this.remove(consequenceName.substring(0, consequenceName.indexOf(sufix)));
        }
    }

    public void removeFunction(Package pkg, Function function) {
        this.remove(pkg.getName() + "." + StringUtils.ucFirst(function.getName()));
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            for (Object object : group.getChildren()) {
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Pattern)) continue;
                this.removeClasses((Pattern)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Pattern pattern) {
        for (Object object : pattern.getConstraints()) {
            if (object instanceof PredicateConstraint) {
                this.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
                continue;
            }
            if (!(object instanceof ReturnValueConstraint)) continue;
            this.remove(((ReturnValueConstraint)object).getExpression().getClass().getName());
        }
    }

    public byte[] read(String resourceName) {
        byte[] bytes = null;
        if (!this.getStore().isEmpty()) {
            bytes = (byte[])this.getStore().get(resourceName);
        }
        return bytes;
    }

    public void write(String resourceName, byte[] clazzData) throws RuntimeDroolsException {
        if (this.getStore().put(resourceName, clazzData) != null) {
            this.dirty = true;
            if (!this.wireList.isEmpty()) {
                this.wireList.clear();
            }
        } else if (!this.dirty) {
            try {
                if (this.wireList == Collections.emptyList()) {
                    this.wireList = new ArrayList<String>();
                }
                this.wireList.add(resourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeDroolsException(e);
            }
        }
    }

    public void wire(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object invoker = this.getInvokers().get(className);
        if (invoker != null) {
            this.wire(className, invoker);
        }
    }

    public void wire(String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = this.rootClassLoader.loadClass(className);
        if (clazz != null) {
            if (invoker instanceof Wireable) {
                ((Wireable)invoker).wire(clazz.newInstance());
            }
        } else {
            throw new ClassNotFoundException(className);
        }
    }

    public boolean remove(String resourceName) throws RuntimeDroolsException {
        this.getInvokers().remove(resourceName);
        if (this.getStore().remove(JavaDialectRuntimeData.convertClassToResourcePath(resourceName)) != null) {
            this.wireList.remove(resourceName);
            this.dirty = true;
            return true;
        }
        return false;
    }

    public String[] list() {
        String[] names = new String[this.getStore().size()];
        int i = 0;
        for (Object object : this.getStore().keySet()) {
            names[i++] = (String)object;
        }
        return names;
    }

    public void reload() throws RuntimeDroolsException {
        this.rootClassLoader.removeClassLoader(this.classLoader);
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        this.rootClassLoader.addClassLoader(this.classLoader);
        try {
            Iterator i$ = this.getInvokers().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = i$.next();
                this.wire((String)entry.getKey(), entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeDroolsException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException(e);
        }
        this.dirty = false;
    }

    public void clear() {
        this.getStore().clear();
        this.getInvokers().clear();
        this.reload();
    }

    public String toString() {
        return this.getClass().getName() + this.getStore().toString();
    }

    public void putInvoker(String className, Object invoker) {
        this.getInvokers().put(className, invoker);
    }

    public void putAllInvokers(Map invokers) {
        this.getInvokers().putAll(invokers);
    }

    public Map getInvokers() {
        if (this.invokerLookups == null) {
            this.invokerLookups = new HashMap();
        }
        return this.invokerLookups;
    }

    public void removeInvoker(String className) {
        this.getInvokers().remove(className);
    }

    public static String convertResourceToClassName(String pResourceName) {
        return JavaDialectRuntimeData.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        String withoutExtension = pResourceName.substring(0, i);
        return withoutExtension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageClassLoader
    extends ClassLoader
    implements FastClassLoader {
        private JavaDialectRuntimeData store;
        CompositeClassLoader rootClassLoader;

        public PackageClassLoader(JavaDialectRuntimeData store, CompositeClassLoader rootClassLoader) {
            super(rootClassLoader);
            this.rootClassLoader = rootClassLoader;
            this.store = store;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> cls = this.fastFindClass(name);
            if (cls == null) {
                CompositeClassLoader parent = (CompositeClassLoader)this.getParent();
                cls = parent.loadClass(name, resolve, this);
            }
            if (cls == null) {
                throw new ClassNotFoundException("Unable to load class: " + name);
            }
            return cls;
        }

        @Override
        public Class<?> fastFindClass(String name) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                byte[] clazzBytes = this.store.read(JavaDialectRuntimeData.convertClassToResourcePath(name));
                if (clazzBytes != null) {
                    String pkgName = name.substring(0, name.lastIndexOf(46));
                    if (this.getPackage(pkgName) == null) {
                        this.definePackage(pkgName, "", "", "", "", "", "", null);
                    }
                    cls = this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
                }
                if (cls != null) {
                    this.resolveClass(cls);
                }
            }
            return cls;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            byte[] clsBytes = this.store.read(name);
            if (clsBytes != null) {
                return new ByteArrayInputStream(clsBytes);
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public URL nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
    }
}

