/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.base.ClassObjectType;
import org.drools.definition.KnowledgeDefinition;
import org.drools.factmodel.ClassDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.io.Resource;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclaration
implements KnowledgeDefinition,
Externalizable {
    public static final int ROLE_BIT = 1;
    public static final int TYPESAFE_BIT = 2;
    public static final int FORMAT_BIT = 4;
    public static final int KIND_BIT = 8;
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TYPESAFE = "typesafe";
    public static final String ATTR_DURATION = "duration";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_EXPIRE = "expires";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_FIELD_POSITION = "position";
    public static final String ATTR_PROP_CHANGE_SUPPORT = "propertyChangeSupport";
    public int setMask = 0;
    private String typeName;
    private Role role;
    private Format format;
    private Kind kind;
    private String timestampAttribute;
    private String durationAttribute;
    private InternalReadAccessor durationExtractor;
    private InternalReadAccessor timestampExtractor;
    private transient Class<?> typeClass;
    private String typeClassName;
    private FactTemplate typeTemplate;
    private ClassDefinition typeClassDef;
    private Resource resource;
    private boolean dynamic;
    private boolean typesafe;
    private boolean novel;
    private transient ObjectType objectType;
    private long expirationOffset = -1L;

    public TypeDeclaration() {
        this.role = Role.FACT;
        this.format = Format.POJO;
        this.kind = Kind.CLASS;
    }

    public TypeDeclaration(String typeName) {
        this.typeName = typeName;
        this.role = Role.FACT;
        this.format = Format.POJO;
        this.kind = Kind.CLASS;
        this.durationAttribute = null;
        this.timestampAttribute = null;
        this.typeTemplate = null;
        this.typesafe = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = (String)in.readObject();
        this.role = (Role)((Object)in.readObject());
        this.format = (Format)((Object)in.readObject());
        this.kind = (Kind)((Object)in.readObject());
        this.durationAttribute = (String)in.readObject();
        this.timestampAttribute = (String)in.readObject();
        this.typeClassName = (String)in.readObject();
        this.typeTemplate = (FactTemplate)in.readObject();
        this.typeClassDef = (ClassDefinition)in.readObject();
        this.durationExtractor = (InternalReadAccessor)in.readObject();
        this.timestampExtractor = (InternalReadAccessor)in.readObject();
        this.resource = (Resource)in.readObject();
        this.expirationOffset = in.readLong();
        this.dynamic = in.readBoolean();
        this.typesafe = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.typeName);
        out.writeObject((Object)this.role);
        out.writeObject((Object)this.format);
        out.writeObject((Object)this.kind);
        out.writeObject(this.durationAttribute);
        out.writeObject(this.timestampAttribute);
        out.writeObject(this.typeClassName);
        out.writeObject(this.typeTemplate);
        out.writeObject(this.typeClassDef);
        out.writeObject(this.durationExtractor);
        out.writeObject(this.timestampExtractor);
        out.writeObject(this.resource);
        out.writeLong(this.expirationOffset);
        out.writeBoolean(this.dynamic);
        out.writeBoolean(this.typesafe);
    }

    public int getSetMask() {
        return this.setMask;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.setMask |= 1;
        this.role = role;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.setMask |= 4;
        this.format = format;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.setMask |= 8;
        this.kind = kind;
    }

    public String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    public void setTimestampAttribute(String timestampAttribute) {
        this.timestampAttribute = timestampAttribute;
    }

    public String getDurationAttribute() {
        return this.durationAttribute;
    }

    public void setDurationAttribute(String durationAttribute) {
        this.durationAttribute = durationAttribute;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
        if (this.typeClassDef != null) {
            this.typeClassDef.setDefinedClass(this.typeClass);
        }
        if (this.typeClass != null) {
            this.typeClassName = this.typeClass.getName();
        }
    }

    public FactTemplate getTypeTemplate() {
        return this.typeTemplate;
    }

    public void setTypeTemplate(FactTemplate typeTemplate) {
        this.typeTemplate = typeTemplate;
    }

    public boolean matches(Object clazz) {
        boolean matches = false;
        matches = clazz instanceof FactTemplate ? this.typeTemplate.equals(clazz) : this.typeClass.isAssignableFrom((Class)clazz);
        return matches;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDeclaration other = (TypeDeclaration)obj;
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }

    public InternalReadAccessor getDurationExtractor() {
        return this.durationExtractor;
    }

    public void setDurationExtractor(InternalReadAccessor durationExtractor) {
        this.durationExtractor = durationExtractor;
    }

    public ClassDefinition getTypeClassDef() {
        return this.typeClassDef;
    }

    public void setTypeClassDef(ClassDefinition typeClassDef) {
        this.typeClassDef = typeClassDef;
    }

    public InternalReadAccessor getTimestampExtractor() {
        return this.timestampExtractor;
    }

    public void setTimestampExtractor(InternalReadAccessor timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ObjectType getObjectType() {
        if (this.objectType == null) {
            this.objectType = this.getFormat() == Format.POJO ? new ClassObjectType(this.getTypeClass()) : new FactTemplateObjectType(this.getTypeTemplate());
        }
        return this.objectType;
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
    }

    public String getTypeClassName() {
        return this.typeClassName;
    }

    public void setTypeClassName(String typeClassName) {
        this.typeClassName = typeClassName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isTypesafe() {
        return this.typesafe;
    }

    public void setTypesafe(boolean typesafe) {
        this.setMask |= 2;
        this.typesafe = typesafe;
    }

    public boolean isNovel() {
        return this.novel;
    }

    public void setNovel(boolean novel) {
        this.novel = novel;
    }

    public String toString() {
        return "TypeDeclaration{typeName='" + this.typeName + '\'' + ", role=" + (Object)((Object)this.role) + ", format=" + (Object)((Object)this.format) + ", kind=" + (Object)((Object)this.kind) + "}";
    }

    @Override
    public KnowledgeDefinition.KnowledgeType getKnowledgeType() {
        return KnowledgeDefinition.KnowledgeType.TYPE;
    }

    @Override
    public String getNamespace() {
        return this.typeClass != null ? this.typeClass.getPackage().getName() : "";
    }

    @Override
    public String getId() {
        return this.getTypeName();
    }

    public class TimestampAccessorSetter
    implements AcceptsReadAccessor,
    Serializable {
        private static final long serialVersionUID = 510L;

        public void setReadAccessor(InternalReadAccessor readAccessor) {
            TypeDeclaration.this.setTimestampExtractor(readAccessor);
        }
    }

    public class DurationAccessorSetter
    implements AcceptsReadAccessor,
    Serializable {
        private static final long serialVersionUID = 510L;

        public void setReadAccessor(InternalReadAccessor readAccessor) {
            TypeDeclaration.this.setDurationExtractor(readAccessor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        POJO,
        TEMPLATE;

        public static final String ID = "format";

        public static Format parseFormat(String format) {
            if ("pojo".equalsIgnoreCase(format)) {
                return POJO;
            }
            if ("template".equalsIgnoreCase(format)) {
                return TEMPLATE;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        FACT,
        EVENT;

        public static final String ID = "role";

        public static Role parseRole(String role) {
            if ("event".equalsIgnoreCase(role)) {
                return EVENT;
            }
            if ("fact".equalsIgnoreCase(role)) {
                return FACT;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CLASS,
        TRAIT,
        ENUM;

        public static final String ID = "kind";

        public static Kind parseKind(String kind) {
            if (TypeDeclaration.ATTR_CLASS.equalsIgnoreCase(kind)) {
                return CLASS;
            }
            if ("trait".equalsIgnoreCase(kind)) {
                return TRAIT;
            }
            if ("enum".equalsIgnoreCase(kind)) {
                return ENUM;
            }
            return null;
        }
    }
}

