/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.asm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.base.TypeResolver;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassGenerator {
    private final String className;
    private final TypeResolver typeResolver;
    private final InternalClassLoader classLoader;
    private int version = 49;
    private int access = 33;
    private String signature;
    private Class superClass = Object.class;
    private Class<?>[] interfaces;
    private final String classDescriptor;
    private String superDescriptor;
    private List<ClassPartDescr> classParts = new ArrayList<ClassPartDescr>();
    private byte[] bytecode;
    private Class<?> clazz;
    private Map<Class<?>, String> descriptorsCache = new HashMap();
    private static final MethodBody EMPTY_METHOD_BODY = new MethodBody(){

        public final void body(MethodVisitor mv) {
            mv.visitInsn(177);
        }
    };
    private static final InternalTypeResolver INTERNAL_TYPE_RESOLVER = new InternalTypeResolver();

    public ClassGenerator(String className, ClassLoader classLoader) {
        this(className, classLoader, null);
    }

    public ClassGenerator(String className, ClassLoader classLoader, TypeResolver typeResolver) {
        this.className = className;
        this.classDescriptor = className.replace('.', '/');
        this.classLoader = new InternalClassLoader(classLoader);
        this.typeResolver = typeResolver == null ? INTERNAL_TYPE_RESOLVER : typeResolver;
    }

    public byte[] generateBytecode() {
        if (this.bytecode == null) {
            ClassWriter cw = new ClassWriter(3);
            cw.visit(this.version, this.access, this.getClassDescriptor(), this.signature, this.getSuperClassDescriptor(), this.toInteralNames(this.interfaces));
            for (ClassPartDescr part : this.classParts) {
                part.write(this, cw);
            }
            cw.visitEnd();
            this.bytecode = cw.toByteArray();
        }
        return this.bytecode;
    }

    public Class<?> generateClass() {
        if (this.clazz == null) {
            this.clazz = this.classLoader.defineClass(this.className, this.generateBytecode());
        }
        return this.clazz;
    }

    public <T> T newInstance() {
        try {
            return (T)this.generateClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getClassDescriptor() {
        return this.classDescriptor;
    }

    public String getSuperClassDescriptor() {
        if (this.superDescriptor == null) {
            this.superDescriptor = this.toInteralName(this.superClass);
        }
        return this.superDescriptor;
    }

    public ClassGenerator setVersion(int version) {
        this.version = version;
        return this;
    }

    public ClassGenerator setAccess(int access) {
        this.access = access;
        return this;
    }

    public ClassGenerator setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public ClassGenerator setSuperClass(Class superClass) {
        this.superClass = superClass;
        return this;
    }

    public ClassGenerator setInterfaces(Class<?> ... interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    private String descriptorOf(Class<?> type) {
        String descriptor = this.descriptorsCache.get(type);
        if (descriptor == null) {
            descriptor = Type.getDescriptor(type);
            this.descriptorsCache.put(type, descriptor);
        }
        return descriptor;
    }

    public String methodDescr(Class<?> type, Class<?> ... args) {
        StringBuilder desc = new StringBuilder("(");
        if (args != null) {
            for (Class<?> arg : args) {
                desc.append(this.descriptorOf(arg));
            }
        }
        desc.append(")").append(type == null ? "V" : this.descriptorOf(type));
        return desc.toString();
    }

    private Type toType(String typeName) {
        return Type.getType(this.toTypeDescriptor(typeName));
    }

    public String toTypeDescriptor(Class<?> clazz) {
        return this.descriptorOf(clazz);
    }

    public String toTypeDescriptor(String className) {
        String typeDescriptor;
        String arrayPrefix = "";
        while (className.endsWith("[]")) {
            arrayPrefix = arrayPrefix + "[";
            className = className.substring(0, className.length() - 2);
        }
        try {
            typeDescriptor = this.toTypeDescriptor(this.typeResolver.resolveType(className));
        }
        catch (ClassNotFoundException e) {
            typeDescriptor = "L" + className.replace('.', '/') + ";";
        }
        return arrayPrefix + typeDescriptor;
    }

    public String toInteralName(Class<?> clazz) {
        return clazz.isPrimitive() ? this.descriptorOf(clazz) : Type.getType(clazz).getInternalName();
    }

    public String toInteralName(String className) {
        String typeDescriptor;
        String arrayPrefix = "";
        while (className.endsWith("[]")) {
            arrayPrefix = arrayPrefix + "[";
            className = className.substring(0, className.length() - 2);
        }
        boolean isPrimitive = false;
        try {
            Class clazz = this.typeResolver.resolveType(className);
            isPrimitive = clazz.isPrimitive();
            typeDescriptor = this.toInteralName(clazz);
        }
        catch (ClassNotFoundException e) {
            typeDescriptor = className.replace('.', '/');
        }
        if (!isPrimitive && arrayPrefix.length() > 0) {
            typeDescriptor = "L" + typeDescriptor + ";";
        }
        return arrayPrefix + typeDescriptor;
    }

    private String[] toInteralNames(Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        String[] internals = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            internals[i] = this.toInteralName(classes[i]);
        }
        return internals;
    }

    public ClassGenerator addField(int access, String name, Class<?> type) {
        return this.addField(access, name, type, null, null);
    }

    public ClassGenerator addField(int access, String name, Class<?> type, String signature) {
        return this.addField(access, name, type, signature, null);
    }

    public ClassGenerator addStaticField(int access, String name, Class<?> type, Object value) {
        return this.addField(access + 8, name, type, null, value);
    }

    public ClassGenerator addStaticField(int access, String name, Class<?> type, String signature, Object value) {
        return this.addField(access + 8, name, type, signature, value);
    }

    private ClassGenerator addField(int access, String name, Class<?> type, String signature, Object value) {
        this.classParts.add(new FieldDescr(access, name, this.descriptorOf(type), signature, value));
        return this;
    }

    public ClassGenerator addDefaultConstructor() {
        return this.addDefaultConstructor(EMPTY_METHOD_BODY);
    }

    public ClassGenerator addDefaultConstructor(final MethodBody body) {
        MethodBody constructorBody = new MethodBody(){

            public void body(MethodVisitor mv) {
                body.setClassGenerator(this.cg);
                body.setMethodVisitor(mv);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.cg.getSuperClassDescriptor(), "<init>", "()V");
                body.body(mv);
            }
        };
        return this.addMethod(1, "<init>", "()V", null, null, constructorBody);
    }

    public ClassGenerator addMethod(int access, String name, String desc) {
        return this.addMethod(access, name, desc, null, null, EMPTY_METHOD_BODY);
    }

    public ClassGenerator addMethod(int access, String name, String desc, MethodBody body) {
        return this.addMethod(access, name, desc, null, null, body);
    }

    public ClassGenerator addMethod(int access, String name, String desc, String signature, MethodBody body) {
        return this.addMethod(access, name, desc, signature, null, body);
    }

    public ClassGenerator addMethod(int access, String name, String desc, String[] exceptions, MethodBody body) {
        return this.addMethod(access, name, desc, null, exceptions, body);
    }

    public ClassGenerator addMethod(int access, String name, String desc, String signature, String[] exceptions, MethodBody body) {
        this.classParts.add(new MethodDescr(access, name, desc, signature, exceptions, body));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalTypeResolver
    implements TypeResolver {
        private InternalTypeResolver() {
        }

        @Override
        public Set<String> getImports() {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public void addImport(String importEntry) {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public Class resolveType(String className) throws ClassNotFoundException {
            return Class.forName(className);
        }

        @Override
        public String getFullTypeName(String shortName) throws ClassNotFoundException {
            throw new RuntimeException("Not Implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalClassLoader
    extends ClassLoader {
        InternalClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }

    private static class MethodDescr
    implements ClassPartDescr {
        private final int access;
        private final String name;
        private final String desc;
        private final String signature;
        private final String[] exceptions;
        private final MethodBody body;

        private MethodDescr(int access, String name, String desc, String signature, String[] exceptions, MethodBody body) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.signature = signature;
            this.exceptions = exceptions;
            this.body = body;
        }

        public void write(ClassGenerator cg, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(this.access, this.name, this.desc, this.signature, this.exceptions);
            mv.visitCode();
            this.body.setClassGenerator(cg);
            this.body.setMethodVisitor(mv);
            this.body.body(mv);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MethodBody {
        ClassGenerator cg;
        MethodVisitor mv;
        private Map<Integer, Type> storedTypes;

        public abstract void body(MethodVisitor var1);

        private void setClassGenerator(ClassGenerator cg) {
            this.cg = cg;
        }

        private void setMethodVisitor(MethodVisitor mv) {
            this.mv = mv;
        }

        public int store(int registry, String typeName) {
            if (this.storedTypes == null) {
                this.storedTypes = new HashMap<Integer, Type>();
            }
            Type t = this.cg.toType(typeName);
            this.mv.visitVarInsn(t.getOpcode(54), registry);
            this.storedTypes.put(registry, t);
            return t.getSize();
        }

        public void load(int registry) {
            this.mv.visitVarInsn(this.storedTypes.get(registry).getOpcode(21), registry);
        }

        public void loadAsObject(int registry) {
            Type type = this.storedTypes.get(registry);
            this.mv.visitVarInsn(type.getOpcode(21), registry);
            String typeName = type.getClassName();
            if (typeName.equals("int")) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else if (typeName.equals("boolean")) {
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            } else if (typeName.equals("char")) {
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            } else if (typeName.equals("byte")) {
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            } else if (typeName.equals("short")) {
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            } else if (typeName.equals("float")) {
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            } else if (typeName.equals("long")) {
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            } else if (typeName.equals("double")) {
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
        }

        public void println(String msg) {
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitLdcInsn(msg);
            this.mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        }

        public void printRegistryValue(int reg, Class<?> clazz) {
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitVarInsn(Type.getType(clazz).getOpcode(21), reg);
            this.invokeVirtual(PrintStream.class, "println", null, clazz);
        }

        public void printLastRegistry(Class<?> clazz) {
            Type t = Type.getType(clazz);
            this.mv.visitVarInsn(t.getOpcode(54), 100);
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitVarInsn(t.getOpcode(21), 100);
            this.invokeVirtual(PrintStream.class, "println", null, clazz);
        }

        public void printStack() {
            this.mv.visitTypeInsn(187, "java/lang/RuntimeException");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "()V");
            this.mv.visitMethodInsn(182, "java/lang/RuntimeException", "printStackTrace", "()V");
            this.mv.visitInsn(177);
        }

        public <T> void returnAsArray(T[] array) {
            this.push(array.length);
            this.mv.visitTypeInsn(189, this.internalName(array.getClass().getComponentType()));
            for (int i = 0; i < array.length; ++i) {
                this.mv.visitInsn(89);
                this.push(i);
                this.push(array[i]);
                this.mv.visitInsn(83);
            }
            this.mv.visitInsn(176);
        }

        public <T> void returnAsArray(Collection<T> collection, Class<T> clazz) {
            this.push(collection.size());
            this.mv.visitTypeInsn(189, this.internalName(clazz));
            int i = 0;
            for (T item : collection) {
                this.mv.visitInsn(89);
                this.push(i++);
                this.push(item);
                this.mv.visitInsn(83);
            }
            this.mv.visitInsn(176);
        }

        public void push(Object obj) {
            if (obj instanceof Boolean) {
                this.push((Boolean)obj);
            } else {
                this.mv.visitLdcInsn(obj);
            }
        }

        public void push(Boolean b) {
            this.mv.visitFieldInsn(178, "java/lang/Boolean", b != false ? "TRUE" : "FALSE", "Ljava/lang/Boolean;");
        }

        public void cast(Class<?> clazz) {
            this.mv.visitTypeInsn(192, this.internalName(clazz));
        }

        public void instanceOf(Class<?> clazz) {
            this.mv.visitTypeInsn(193, this.internalName(clazz));
        }

        public void invokeThis(String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.mv.visitMethodInsn(182, this.classDescriptor(), methodName, this.methodDescr(returnedType, paramsType));
        }

        public void invokeStatic(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(184, clazz, methodName, returnedType, paramsType);
        }

        public void invokeVirtual(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(182, clazz, methodName, returnedType, paramsType);
        }

        public void invokeInterface(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(185, clazz, methodName, returnedType, paramsType);
        }

        public void invokeSpecial(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(183, clazz, methodName, returnedType, paramsType);
        }

        private void invoke(int opCode, Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.mv.visitMethodInsn(opCode, this.internalName(clazz), methodName, this.methodDescr(returnedType, paramsType));
        }

        public void putField(String name, Class<?> type) {
            this.mv.visitFieldInsn(181, this.classDescriptor(), name, this.cg.descriptorOf(type));
        }

        public void getField(String name, Class<?> type) {
            this.mv.visitFieldInsn(180, this.classDescriptor(), name, this.cg.descriptorOf(type));
        }

        public String classDescriptor() {
            return this.cg.getClassDescriptor();
        }

        public String superClassDescriptor() {
            return this.cg.getSuperClassDescriptor();
        }

        public String methodDescr(Class<?> type, Class<?> ... args) {
            return this.cg.methodDescr(type, args);
        }

        private Type type(String typeName) {
            return this.cg.toType(typeName);
        }

        public String typeDescr(Class<?> clazz) {
            return this.cg.toTypeDescriptor(clazz);
        }

        public String typeDescr(String className) {
            return this.cg.toTypeDescriptor(className);
        }

        public String internalName(Class<?> clazz) {
            return this.cg.toInteralName(clazz);
        }

        public String internalName(String className) {
            return this.cg.toInteralName(className);
        }
    }

    private static class FieldDescr
    implements ClassPartDescr {
        private final int access;
        private final String name;
        private final String desc;
        private final String signature;
        private final Object value;

        FieldDescr(int access, String name, String desc, String signature, Object value) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.signature = signature;
            this.value = value;
        }

        public void write(ClassGenerator cg, ClassWriter cw) {
            cw.visitField(this.access, this.name, this.desc, this.signature, this.value).visitEnd();
        }
    }

    private static interface ClassPartDescr {
        public void write(ClassGenerator var1, ClassWriter var2);
    }
}

