/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.drools.guvnor.importgenerator.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.rule.Package;
import org.jboss.drools.guvnor.importgenerator.PackageFile;
import org.jboss.drools.guvnor.importgenerator.utils.FileIO;

public class DroolsHelper {
    private static final String FUNCTIONS_FILE = "functions.drl";

    public static byte[] compileRuletoPKG(PackageFile file) throws IOException, DroolsParserException {
        PackageBuilder pb = new PackageBuilder();
        String xtn = FileIO.getExtension(file.getFile()).toLowerCase();
        if (xtn.equals("drl")) {
            File functionsFile = new File(file.getFile().getParentFile().getPath(), FUNCTIONS_FILE);
            if (functionsFile.exists()) {
                pb.addPackageFromDrl(new FileReader(functionsFile));
            }
            pb.addPackageFromDrl(new FileReader(file.getFile()));
        } else if (xtn.equals("xls")) {
            pb.addPackageFromDrl(new StringReader(DroolsHelper.compileDTabletoDRL(file.getFile(), InputType.XLS)));
        }
        Package pkg = pb.getPackage();
        if (pkg == null) {
            for (int i = 0; i < pb.getErrors().getErrors().length; ++i) {
                DroolsError msg = pb.getErrors().getErrors()[i];
                file.addCompilationError(msg.getMessage());
            }
        } else if (pkg != null && !pkg.isValid()) {
            file.addDependencyError(pkg.getErrorSummary());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream doos = new DroolsObjectOutputStream(baos);
        doos.writeObject(pkg);
        return baos.toByteArray();
    }

    public static String compileDTabletoDRL(File file, InputType type) throws FileNotFoundException {
        SpreadsheetCompiler compiler = new SpreadsheetCompiler();
        return compiler.compile((InputStream)new FileInputStream(file), type);
    }
}

