/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import java.util.Arrays;
import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.util.LittleEndian;

public final class SprmBuffer
implements Cloneable {
    byte[] _buf;
    int _offset;
    boolean _istd;

    public SprmBuffer(byte[] buf, boolean istd) {
        this._offset = buf.length;
        this._buf = buf;
        this._istd = istd;
    }

    public SprmBuffer(byte[] buf) {
        this(buf, false);
    }

    public SprmBuffer() {
        this._buf = new byte[4];
        this._offset = 0;
    }

    private int findSprm(short opcode) {
        int operation = SprmOperation.getOperationFromOpcode(opcode);
        int type = SprmOperation.getTypeFromOpcode(opcode);
        SprmIterator si = new SprmIterator(this._buf, 2);
        while (si.hasNext()) {
            SprmOperation i = si.next();
            if (i.getOperation() != operation || i.getType() != type) continue;
            return i.getGrpprlOffset();
        }
        return -1;
    }

    public void updateSprm(short opcode, byte operand) {
        int grpprlOffset = this.findSprm(opcode);
        if (grpprlOffset != -1) {
            this._buf[grpprlOffset] = operand;
            return;
        }
        this.addSprm(opcode, operand);
    }

    public void updateSprm(short opcode, short operand) {
        int grpprlOffset = this.findSprm(opcode);
        if (grpprlOffset != -1) {
            LittleEndian.putShort(this._buf, grpprlOffset, operand);
            return;
        }
        this.addSprm(opcode, operand);
    }

    public void updateSprm(short opcode, int operand) {
        int grpprlOffset = this.findSprm(opcode);
        if (grpprlOffset != -1) {
            LittleEndian.putInt(this._buf, grpprlOffset, operand);
            return;
        }
        this.addSprm(opcode, operand);
    }

    public void addSprm(short opcode, byte operand) {
        int addition = 3;
        this.ensureCapacity(addition);
        LittleEndian.putShort(this._buf, this._offset, opcode);
        this._offset += 2;
        this._buf[this._offset++] = operand;
    }

    public void addSprm(short opcode, short operand) {
        int addition = 4;
        this.ensureCapacity(addition);
        LittleEndian.putShort(this._buf, this._offset, opcode);
        this._offset += 2;
        LittleEndian.putShort(this._buf, this._offset, operand);
        this._offset += 2;
    }

    public void addSprm(short opcode, int operand) {
        int addition = 6;
        this.ensureCapacity(addition);
        LittleEndian.putShort(this._buf, this._offset, opcode);
        this._offset += 2;
        LittleEndian.putInt(this._buf, this._offset, operand);
        this._offset += 4;
    }

    public void addSprm(short opcode, byte[] operand) {
        int addition = 3 + operand.length;
        this.ensureCapacity(addition);
        LittleEndian.putShort(this._buf, this._offset, opcode);
        this._offset += 2;
        this._buf[this._offset++] = (byte)operand.length;
        System.arraycopy(operand, 0, this._buf, this._offset, operand.length);
    }

    public byte[] toByteArray() {
        return this._buf;
    }

    public boolean equals(Object obj) {
        SprmBuffer sprmBuf = (SprmBuffer)obj;
        return Arrays.equals(this._buf, sprmBuf._buf);
    }

    public void append(byte[] grpprl) {
        this.ensureCapacity(grpprl.length);
        System.arraycopy(grpprl, 0, this._buf, this._offset, grpprl.length);
    }

    public Object clone() throws CloneNotSupportedException {
        SprmBuffer retVal = (SprmBuffer)super.clone();
        retVal._buf = new byte[this._buf.length];
        System.arraycopy(this._buf, 0, retVal._buf, 0, this._buf.length);
        return retVal;
    }

    private void ensureCapacity(int addition) {
        if (this._offset + addition >= this._buf.length) {
            byte[] newBuf = new byte[this._offset + addition + 6];
            System.arraycopy(this._buf, 0, newBuf, 0, this._buf.length);
            this._buf = newBuf;
        }
    }
}

