/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DWGParser
implements Parser {
    private static MediaType TYPE = MediaType.image("vnd.dwg");
    private static String[] HEADER_PROPERTIES_ENTRIES = new String[]{"title", "subject", "Author", "Keywords", "Comments", "Last-Author", null, "relation"};

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(TYPE);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        byte[] header = new byte[128];
        IOUtils.readFully(stream, header);
        String version = new String(header, 0, 6, "US-ASCII");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        if (version.equals("AC1018")) {
            metadata.set("Content-Type", TYPE.toString());
            if (this.skipToPropertyInfoSection(stream, header)) {
                this.get2004Props(stream, metadata, xhtml);
            }
        } else if (version.equals("AC1021") || version.equals("AC1024")) {
            metadata.set("Content-Type", TYPE.toString());
            this.skipToPropertyInfoSection(stream, header);
            this.get2007and2010Props(stream, metadata, xhtml);
        } else {
            throw new TikaException("Unsupported AutoCAD drawing version: " + version);
        }
        xhtml.endDocument();
    }

    private void get2004Props(InputStream stream, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException {
        for (int i = 0; i < HEADER_PROPERTIES_ENTRIES.length; ++i) {
            int stringLen = LittleEndian.readUShort(stream);
            byte[] stringData = new byte[stringLen];
            IOUtils.readFully(stream, stringData);
            if (stringData[stringLen - 1] == 0) {
                --stringLen;
            }
            String headerValue = StringUtil.getFromCompressedUnicode(stringData, 0, stringLen);
            this.handleHeader(i, headerValue, metadata, xhtml);
        }
    }

    private void get2007and2010Props(InputStream stream, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException {
        for (int i = 0; i < HEADER_PROPERTIES_ENTRIES.length; ++i) {
            int stringLen = LittleEndian.readUShort(stream);
            byte[] stringData = new byte[stringLen * 2];
            IOUtils.readFully(stream, stringData);
            String headerValue = StringUtil.getFromUnicodeLE(stringData);
            this.handleHeader(i, headerValue, metadata, xhtml);
        }
    }

    private void handleHeader(int headerNumber, String value, Metadata metadata, XHTMLContentHandler xhtml) throws SAXException {
        String headerProp;
        if (value == null || value.length() == 0) {
            return;
        }
        if (value.charAt(value.length() - 1) == '\u0000') {
            value = value.substring(0, value.length() - 1);
        }
        if ((headerProp = HEADER_PROPERTIES_ENTRIES[headerNumber]) != null) {
            metadata.set(headerProp, value);
        }
        xhtml.element("p", value);
    }

    private boolean skipToPropertyInfoSection(InputStream stream, byte[] header) throws IOException {
        byte[] skip;
        long offsetToSection = LittleEndian.getLong(header, 32);
        if (offsetToSection == 0L) {
            return false;
        }
        for (long toSkip = offsetToSection - (long)header.length; toSkip > 0L; toSkip -= (long)skip.length) {
            skip = new byte[Math.min((int)toSkip, 16384)];
            IOUtils.readFully(stream, skip);
        }
        return true;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

