/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.agent.FileLoader;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleAgent;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.rule.Package;

public class FileScanner
extends PackageProvider {
    File[] files;
    Map lastUpdated = new HashMap();
    Map<String, String> pathToPackage = null;

    void configure(Properties config) {
        List paths = RuleAgent.list(config.getProperty("file"));
        this.files = new File[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            File file = new File((String)paths.get(i));
            if (!file.exists()) {
                throw new IllegalArgumentException("The file " + file.getName() + " does not exist.");
            }
            this.files[i] = file;
        }
    }

    void setFiles(File[] files) {
        this.files = files;
    }

    PackageChangeInfo loadPackageChanges() {
        PackageChangeInfo changes = this.getChangeSet();
        return changes;
    }

    private PackageChangeInfo getChangeSet() {
        PackageChangeInfo info = new PackageChangeInfo();
        if (this.files == null) {
            return info;
        }
        if (this.pathToPackage == null) {
            this.pathToPackage = new HashMap<String, String>();
        }
        for (int i = 0; i < this.files.length; ++i) {
            Package p;
            File f = this.files[i];
            if (!f.exists()) {
                String name = this.pathToPackage.get(f.getPath());
                if (name == null) continue;
                info.addRemovedPackage(name);
                continue;
            }
            if (!this.hasChanged(f.getPath(), this.lastUpdated, f.lastModified()) || (p = this.readPackage(f)) == null) continue;
            info.addPackage(p);
            this.pathToPackage.put(f.getPath(), p.getName());
        }
        return info;
    }

    private Package readPackage(File pkgFile) {
        String name = pkgFile.getName();
        if (!(name.endsWith(".pkg") || name.endsWith(".drl") || name.endsWith(".xls"))) {
            return null;
        }
        if (pkgFile.getName().endsWith(".drl")) {
            try {
                FileLoader fl = (FileLoader)Class.forName("org.drools.compiler.SourcePackageProvider").newInstance();
                return fl.loadPackage(pkgFile);
            }
            catch (Exception e) {
                this.listener.exception(e);
                return null;
            }
        }
        if (pkgFile.getName().endsWith(".xls")) {
            try {
                FileLoader fl = (FileLoader)Class.forName("org.drools.decisiontable.SourcePackageProvider").newInstance();
                return fl.loadPackage(pkgFile);
            }
            catch (Exception e) {
                this.listener.exception(e);
                return null;
            }
        }
        Object o = null;
        try {
            FileInputStream fis = new FileInputStream(pkgFile);
            o = DroolsStreamUtils.streamIn(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            this.listener.exception(e);
            this.listener.warning("Was unable to find the file " + pkgFile.getPath());
        }
        catch (IOException e) {
            this.listener.exception(e);
        }
        catch (ClassNotFoundException e) {
            this.listener.exception(e);
            this.listener.warning("Was unable to load a class when loading a package. Perhaps it is missing from this application.");
        }
        if (o instanceof KnowledgePackageImp) {
            return ((KnowledgePackageImp)o).pkg;
        }
        return (Package)o;
    }

    boolean hasChanged(String path, Map updates, long fileLastModified) {
        if (!updates.containsKey(path)) {
            updates.put(path, new Long(fileLastModified));
            return true;
        }
        Long last = (Long)updates.get(path);
        if (last < fileLastModified) {
            updates.put(path, new Long(fileLastModified));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("FileScanner scanning: ");
        for (int i = 0; i < this.files.length; ++i) {
            File f = this.files[i];
            buf.append(f.getPath() + " ");
        }
        return buf.toString();
    }
}

