/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import org.drools.factmodel.BeanClassBuilder;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.EnumClassBuilder;
import org.drools.factmodel.traits.TraitClassBuilder;
import org.drools.factmodel.traits.TraitClassBuilderImpl;
import org.drools.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitTriplePropertyWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitTripleProxyClassBuilderImpl;
import org.drools.util.ServiceRegistryImpl;

public class ClassBuilderFactory {
    private static BeanClassBuilder beanClassBuilderProvider;
    private static EnumClassBuilder enumClassBuilderProvider;
    private static TraitClassBuilder traitBuilderProvider;
    private static ClassBuilder propertyWrapperBuilderProvider;
    private static TraitProxyClassBuilder traitProxyBuilderProvider;

    public static synchronized ClassBuilder getBeanClassBuilderService() {
        if (beanClassBuilderProvider == null) {
            ClassBuilderFactory.loadBeanClassBuilderProvider();
        }
        return beanClassBuilderProvider;
    }

    public static synchronized void setBeanClassBuilderService(BeanClassBuilder provider) {
        beanClassBuilderProvider = provider;
    }

    private static void loadBeanClassBuilderProvider() {
        String defaultName = "org.drools.factmodel.DefaultBeanClassBuilder";
        try {
            ServiceRegistryImpl.getInstance().addDefault(BeanClassBuilder.class, defaultName);
            ClassBuilderFactory.setBeanClassBuilderService(ServiceRegistryImpl.getInstance().get(BeanClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized EnumClassBuilder getEnumClassBuilderService() {
        if (enumClassBuilderProvider == null) {
            ClassBuilderFactory.loadEnumClassBuilderProvider();
        }
        return enumClassBuilderProvider;
    }

    public static synchronized void setEnumClassBuilderService(EnumClassBuilder provider) {
        enumClassBuilderProvider = provider;
    }

    private static void loadEnumClassBuilderProvider() {
        String defaultName = "org.drools.factmodel.DefaultEnumClassBuilder";
        try {
            ServiceRegistryImpl.getInstance().addDefault(EnumClassBuilder.class, defaultName);
            ClassBuilderFactory.setEnumClassBuilderService(ServiceRegistryImpl.getInstance().get(EnumClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ClassBuilder getTraitBuilderService() {
        if (traitBuilderProvider == null) {
            ClassBuilderFactory.loadTraitBuilderProvider();
        }
        return traitBuilderProvider;
    }

    public static synchronized void setTraitBuilderService(TraitClassBuilder provider) {
        traitBuilderProvider = provider;
    }

    private static void loadTraitBuilderProvider() {
        ServiceRegistryImpl.getInstance().addDefault(TraitClassBuilder.class, "org.drools.factmodel.traits.TraitClassBuilderImpl");
        ClassBuilderFactory.setTraitBuilderService(ServiceRegistryImpl.getInstance().get(TraitClassBuilder.class));
    }

    public static synchronized ClassBuilder getPropertyWrapperBuilderService() {
        if (propertyWrapperBuilderProvider == null) {
            ClassBuilderFactory.loadPropertyWrapperClassBuilderProvider();
        }
        return propertyWrapperBuilderProvider;
    }

    public static synchronized void setPropertyWrapperBuilderService(TraitPropertyWrapperClassBuilder provider) {
        propertyWrapperBuilderProvider = provider;
    }

    private static void loadPropertyWrapperClassBuilderProvider() {
        try {
            ServiceRegistryImpl.getInstance().addDefault(TraitPropertyWrapperClassBuilder.class, "org.drools.factmodel.TraitTriplePropertyWrapperClassBuilderImpl");
            ClassBuilderFactory.setPropertyWrapperBuilderService(ServiceRegistryImpl.getInstance().get(TraitPropertyWrapperClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ClassBuilder getTraitProxyBuilderService() {
        if (traitProxyBuilderProvider == null) {
            ClassBuilderFactory.loadTraitProxyClassBuilderProvider();
        }
        return traitProxyBuilderProvider;
    }

    public static synchronized void setTraitProxyBuilderService(TraitProxyClassBuilder provider) {
        traitProxyBuilderProvider = provider;
    }

    private static void loadTraitProxyClassBuilderProvider() {
        try {
            ServiceRegistryImpl.getInstance().addDefault(TraitProxyClassBuilder.class, "org.drools.factmodel.TraitTripleProxyClassBuilderImpl");
            ClassBuilderFactory.setTraitProxyBuilderService(ServiceRegistryImpl.getInstance().get(TraitProxyClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        traitBuilderProvider = new TraitClassBuilderImpl();
        propertyWrapperBuilderProvider = new TraitTriplePropertyWrapperClassBuilderImpl();
        traitProxyBuilderProvider = new TraitTripleProxyClassBuilderImpl();
    }
}

