/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnwantedTokenException;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.StringUtils;
import org.drools.lang.DRLExpressions;
import org.drools.lang.DroolsEditorType;
import org.drools.lang.DroolsMismatchedSetException;
import org.drools.lang.DroolsMismatchedTokenException;
import org.drools.lang.DroolsParaphraseTypes;
import org.drools.lang.DroolsSentence;
import org.drools.lang.DroolsToken;
import org.drools.lang.ParserHelper;
import org.drools.lang.api.AbstractClassTypeDeclarationBuilder;
import org.drools.lang.api.AccumulateDescrBuilder;
import org.drools.lang.api.AnnotatedDescrBuilder;
import org.drools.lang.api.AnnotationDescrBuilder;
import org.drools.lang.api.AttributeDescrBuilder;
import org.drools.lang.api.AttributeSupportBuilder;
import org.drools.lang.api.BehaviorDescrBuilder;
import org.drools.lang.api.CEDescrBuilder;
import org.drools.lang.api.CollectDescrBuilder;
import org.drools.lang.api.DeclareDescrBuilder;
import org.drools.lang.api.DescrBuilder;
import org.drools.lang.api.DescrFactory;
import org.drools.lang.api.EntryPointDeclarationDescrBuilder;
import org.drools.lang.api.EnumDeclarationDescrBuilder;
import org.drools.lang.api.EnumLiteralDescrBuilder;
import org.drools.lang.api.EvalDescrBuilder;
import org.drools.lang.api.FieldDescrBuilder;
import org.drools.lang.api.ForallDescrBuilder;
import org.drools.lang.api.FunctionDescrBuilder;
import org.drools.lang.api.GlobalDescrBuilder;
import org.drools.lang.api.ImportDescrBuilder;
import org.drools.lang.api.PackageDescrBuilder;
import org.drools.lang.api.ParameterSupportBuilder;
import org.drools.lang.api.PatternContainerDescrBuilder;
import org.drools.lang.api.PatternDescrBuilder;
import org.drools.lang.api.QueryDescrBuilder;
import org.drools.lang.api.RuleDescrBuilder;
import org.drools.lang.api.TypeDeclarationDescrBuilder;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EntryPointDeclarationDescr;
import org.drools.lang.descr.EnumDeclarationDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.rule.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLParser {
    private TokenStream input;
    private RecognizerSharedState state;
    private ParserHelper helper;
    private DRLExpressions exprParser;

    public DRLParser(TokenStream input) {
        this.input = input;
        this.state = new RecognizerSharedState();
        this.helper = new ParserHelper(input, this.state);
        this.exprParser = new DRLExpressions(input, this.state, this.helper);
    }

    public ParserHelper getHelper() {
        return this.helper;
    }

    public boolean hasErrors() {
        return this.helper.hasErrors();
    }

    public List<DroolsParserException> getErrors() {
        return this.helper.getErrors();
    }

    public List<String> getErrorMessages() {
        return this.helper.getErrorMessages();
    }

    public void enableEditorInterface() {
        this.helper.enableEditorInterface();
    }

    public void disableEditorInterface() {
        this.helper.disableEditorInterface();
    }

    public LinkedList<DroolsSentence> getEditorInterface() {
        return this.helper.getEditorInterface();
    }

    public void reportError(RecognitionException ex) {
        if (this.state.backtracking == 0) {
            this.helper.reportError(ex);
        }
    }

    public void reportError(Exception ex) {
        if (this.state.backtracking == 0) {
            this.helper.reportError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PackageDescr compilationUnit() throws RecognitionException {
        PackageDescrBuilder pkg = DescrFactory.newPackage();
        try {
            if (this.input.LA(1) != -1 && this.helper.validateIdentifierKey("package")) {
                String pkgName = this.packageStatement(pkg);
                pkg.name(pkgName);
                if (this.state.failed) {
                    PackageDescr packageDescr = (PackageDescr)pkg.getDescr();
                    return packageDescr;
                }
            }
            while (this.input.LA(1) != -1) {
                int next = this.input.index();
                if (this.helper.validateStatement(1)) {
                    this.statement(pkg);
                    if (this.state.failed) {
                        PackageDescr packageDescr = (PackageDescr)pkg.getDescr();
                        return packageDescr;
                    }
                    if (next == this.input.index()) {
                        this.resyncToNextStatement();
                    }
                } else {
                    this.resyncToNextStatement();
                }
                if (this.input.LA(1) != 33) continue;
                this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
                if (!this.state.failed) continue;
                PackageDescr packageDescr = (PackageDescr)pkg.getDescr();
                return packageDescr;
            }
        }
        catch (RecognitionException e) {
            this.helper.reportError(e);
        }
        catch (Exception e) {
            this.helper.reportError(e);
        }
        finally {
            this.helper.setEnd(pkg);
        }
        return (PackageDescr)pkg.getDescr();
    }

    private void resyncToNextStatement() {
        this.helper.reportError(new DroolsMismatchedSetException(this.helper.getStatementKeywords(), this.input));
        do {
            this.input.consume();
        } while (this.input.LA(1) != -1 && !this.helper.validateStatement(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String packageStatement(PackageDescrBuilder pkg) throws RecognitionException {
        String pkgName = null;
        try {
            this.helper.start(pkg, PackageDescrBuilder.class, null);
            this.match(this.input, 67, "package", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                String string = pkgName;
                return string;
            }
            pkgName = this.qualifiedIdentifier();
            if (this.state.failed) {
                String string = pkgName;
                return string;
            }
            if (this.state.backtracking == 0) {
                this.helper.setParaphrasesValue(DroolsParaphraseTypes.PACKAGE, pkgName);
            }
            if (this.input.LA(1) == 33) {
                this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    String string = pkgName;
                    return string;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(PackageDescrBuilder.class, pkg);
        }
        return pkgName;
    }

    public BaseDescr statement(PackageDescrBuilder pkg) throws RecognitionException {
        BaseDescr descr = null;
        try {
            if (this.helper.validateIdentifierKey("import")) {
                descr = this.importStatement(pkg);
                if (this.state.failed) {
                    return descr;
                }
            } else if (this.helper.validateIdentifierKey("global")) {
                descr = this.globalStatement(pkg);
                if (this.state.failed) {
                    return descr;
                }
            } else if (this.helper.validateIdentifierKey("declare")) {
                descr = this.declare(pkg);
                if (this.state.failed) {
                    return descr;
                }
            } else if (this.helper.validateIdentifierKey("rule")) {
                descr = this.rule(pkg);
                if (this.state.failed) {
                    return descr;
                }
            } else if (this.helper.validateIdentifierKey("query")) {
                descr = this.query(pkg);
                if (this.state.failed) {
                    return descr;
                }
            } else if (this.helper.validateIdentifierKey("function")) {
                descr = this.function(pkg);
                if (this.state.failed) {
                    return descr;
                }
            } else if (this.helper.validateAttribute(1)) {
                descr = this.attribute(pkg);
                if (this.state.failed) {
                    return descr;
                }
            }
        }
        catch (RecognitionException e) {
            this.helper.reportError(e);
        }
        catch (Exception e) {
            this.helper.reportError(e);
        }
        return descr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportDescr importStatement(PackageDescrBuilder pkg) throws RecognitionException {
        ImportDescrBuilder imp = null;
        try {
            block23: {
                String kwd;
                block22: {
                    imp = this.helper.start(pkg, ImportDescrBuilder.class, null);
                    this.match(this.input, 67, "import", null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        ImportDescr importDescr = null;
                        return importDescr;
                    }
                    kwd = "function";
                    if (this.helper.validateIdentifierKey("function")) break block22;
                    kwd = "static";
                    if (!this.helper.validateIdentifierKey("static")) break block23;
                }
                this.match(this.input, 67, kwd, null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    ImportDescr importDescr = null;
                    return importDescr;
                }
            }
            String target = this.qualifiedIdentifier();
            if (this.state.failed) {
                ImportDescr importDescr = null;
                return importDescr;
            }
            if (this.input.LA(1) == 49 && this.input.LA(2) == 59) {
                this.match(this.input, 49, null, null, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    ImportDescr importDescr = null;
                    return importDescr;
                }
                this.match(this.input, 59, null, null, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    ImportDescr importDescr = null;
                    return importDescr;
                }
                target = target + ".*";
            }
            if (this.state.backtracking == 0) {
                imp.target(target);
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(ImportDescrBuilder.class, imp);
        }
        return imp != null ? (ImportDescr)imp.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalDescr globalStatement(PackageDescrBuilder pkg) throws RecognitionException {
        GlobalDescrBuilder global = null;
        try {
            global = this.helper.start(pkg, GlobalDescrBuilder.class, null);
            this.match(this.input, 67, "global", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                GlobalDescr globalDescr = null;
                return globalDescr;
            }
            String type = this.type();
            if (this.state.backtracking == 0) {
                global.type(type);
            }
            if (this.state.failed) {
                GlobalDescr globalDescr = null;
                return globalDescr;
            }
            Token id = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER_TYPE);
            if (this.state.failed) {
                GlobalDescr globalDescr = null;
                return globalDescr;
            }
            if (this.state.backtracking == 0) {
                global.identifier(id.getText());
                this.helper.setParaphrasesValue(DroolsParaphraseTypes.GLOBAL, id.getText());
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(GlobalDescrBuilder.class, global);
        }
        return global != null ? (GlobalDescr)global.getDescr() : null;
    }

    public BaseDescr declare(PackageDescrBuilder pkg) throws RecognitionException {
        AnnotatedBaseDescr declaration = null;
        try {
            DeclareDescrBuilder declare = this.helper.start(pkg, DeclareDescrBuilder.class, null);
            this.match(this.input, 67, "declare", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                return null;
            }
            if (this.helper.validateIdentifierKey("entry")) {
                declaration = this.entryPointDeclaration(declare);
            } else if (this.helper.validateIdentifierKey("trait")) {
                this.match(this.input, 67, "trait", null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    return null;
                }
                declaration = this.typeDeclaration(declare, true);
            } else if (this.helper.validateIdentifierKey("enum")) {
                this.match(this.input, 67, "enum", null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    return null;
                }
                declaration = this.enumDeclaration(declare);
            } else {
                declaration = this.typeDeclaration(declare, false);
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        return declaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPointDeclarationDescr entryPointDeclaration(DeclareDescrBuilder ddb) throws RecognitionException {
        EntryPointDeclarationDescrBuilder declare = null;
        try {
            declare = this.helper.start(ddb, EntryPointDeclarationDescrBuilder.class, null);
            String ep = "";
            this.match(this.input, 67, "entry", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                EntryPointDeclarationDescr entryPointDeclarationDescr = null;
                return entryPointDeclarationDescr;
            }
            this.match(this.input, 60, null, null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                EntryPointDeclarationDescr entryPointDeclarationDescr = null;
                return entryPointDeclarationDescr;
            }
            this.match(this.input, 67, "point", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                EntryPointDeclarationDescr entryPointDeclarationDescr = null;
                return entryPointDeclarationDescr;
            }
            ep = this.stringId();
            if (this.state.failed) {
                EntryPointDeclarationDescr entryPointDeclarationDescr = null;
                return entryPointDeclarationDescr;
            }
            if (this.state.backtracking == 0) {
                declare.entryPointId(ep);
            }
            while (this.input.LA(1) == 20) {
                this.annotation(declare);
                if (!this.state.failed) continue;
                EntryPointDeclarationDescr entryPointDeclarationDescr = null;
                return entryPointDeclarationDescr;
            }
            this.match(this.input, 67, "end", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                EntryPointDeclarationDescr entryPointDeclarationDescr = null;
                return entryPointDeclarationDescr;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(EntryPointDeclarationDescrBuilder.class, declare);
        }
        return declare != null ? (EntryPointDeclarationDescr)declare.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumDeclarationDescr enumDeclaration(DeclareDescrBuilder ddb) throws RecognitionException {
        EnumDeclarationDescrBuilder declare = null;
        try {
            declare = this.helper.start(ddb, EnumDeclarationDescrBuilder.class, null);
            String type = this.qualifiedIdentifier();
            if (this.state.failed) {
                EnumDeclarationDescr enumDeclarationDescr = null;
                return enumDeclarationDescr;
            }
            if (this.state.backtracking == 0) {
                declare.name(type);
            }
            while (this.input.LA(1) == 20) {
                this.annotation(declare);
                if (!this.state.failed) continue;
                EnumDeclarationDescr enumDeclarationDescr = null;
                return enumDeclarationDescr;
            }
            while (this.input.LA(1) == 67) {
                int next = this.input.LA(2);
                if (next == 42 || next == 48 || next == 33) {
                    this.enumerative(declare);
                    if (this.state.failed) {
                        EnumDeclarationDescr enumDeclarationDescr = null;
                        return enumDeclarationDescr;
                    }
                }
                if (this.input.LA(1) == 48) {
                    this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                    continue;
                }
                this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
                break;
            }
            while (this.input.LA(1) == 67 && !this.helper.validateIdentifierKey("end")) {
                this.field(declare);
                if (!this.state.failed) continue;
                EnumDeclarationDescr enumDeclarationDescr = null;
                return enumDeclarationDescr;
            }
            this.match(this.input, 67, "end", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                EnumDeclarationDescr enumDeclarationDescr = null;
                return enumDeclarationDescr;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(TypeDeclarationDescrBuilder.class, declare);
        }
        return declare != null ? (EnumDeclarationDescr)declare.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDeclarationDescr typeDeclaration(DeclareDescrBuilder ddb, boolean isTrait) throws RecognitionException {
        TypeDeclarationDescrBuilder declare = null;
        try {
            TypeDeclarationDescr typeDeclarationDescr;
            declare = this.helper.start(ddb, TypeDeclarationDescrBuilder.class, null);
            if (isTrait) {
                declare.newAnnotation("kind").value(TypeDeclaration.Kind.TRAIT.name());
            }
            if (this.helper.validateIdentifierKey("type")) {
                this.match(this.input, 67, "type", null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    TypeDeclarationDescr typeDeclarationDescr2 = null;
                    return typeDeclarationDescr2;
                }
            }
            String type = this.qualifiedIdentifier();
            if (this.state.failed) {
                TypeDeclarationDescr typeDeclarationDescr3 = null;
                return typeDeclarationDescr3;
            }
            if (this.state.backtracking == 0) {
                declare.name(type);
            }
            if (this.helper.validateIdentifierKey("extends")) {
                this.match(this.input, 67, "extends", null, DroolsEditorType.KEYWORD);
                if (!this.state.failed) {
                    String superType = this.qualifiedIdentifier();
                    declare.superType(superType);
                    while (this.input.LA(1) == 48) {
                        this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                        superType = this.qualifiedIdentifier();
                        declare.superType(superType);
                    }
                }
            }
            while (this.input.LA(1) == 20) {
                this.annotation(declare);
                if (!this.state.failed) continue;
                typeDeclarationDescr = null;
                return typeDeclarationDescr;
            }
            while (this.input.LA(1) == 67 && !this.helper.validateIdentifierKey("end")) {
                this.field(declare);
                if (!this.state.failed) continue;
                typeDeclarationDescr = null;
                return typeDeclarationDescr;
            }
            this.match(this.input, 67, "end", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                typeDeclarationDescr = null;
                return typeDeclarationDescr;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(TypeDeclarationDescrBuilder.class, declare);
        }
        return declare != null ? (TypeDeclarationDescr)declare.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumerative(EnumDeclarationDescrBuilder declare) {
        EnumLiteralDescrBuilder literal = null;
        String lit = null;
        try {
            Token enumLit = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER);
            lit = enumLit.getText();
            if (this.state.failed) {
                return;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        try {
            literal = this.helper.start(declare, EnumLiteralDescrBuilder.class, lit);
            if (this.input.LA(1) == 42) {
                boolean more;
                this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
                do {
                    int first = this.input.index();
                    this.exprParser.conditionalExpression();
                    if (this.state.failed) {
                        return;
                    }
                    if (this.state.backtracking == 0 && this.input.index() > first) {
                        String arg = this.input.toString(first, this.input.LT(-1).getTokenIndex());
                        literal.constructorArg(arg);
                    }
                    boolean bl = more = this.input.LA(1) == 48;
                    if (!more) continue;
                    this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                } while (more);
                this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(FieldDescrBuilder.class, literal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void field(AbstractClassTypeDeclarationBuilder declare) {
        FieldDescrBuilder field = null;
        String fname = null;
        try {
            fname = this.label(DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        try {
            field = this.helper.start(declare, FieldDescrBuilder.class, fname);
            String type = this.qualifiedIdentifier();
            if (this.state.failed) {
                return;
            }
            if (this.state.backtracking == 0) {
                field.type(type);
            }
            if (this.input.LA(1) == 41) {
                this.match(this.input, 41, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
                int first = this.input.index();
                this.exprParser.conditionalExpression();
                if (this.state.failed) {
                    return;
                }
                if (this.state.backtracking == 0 && this.input.index() > first) {
                    String value = this.input.toString(first, this.input.LT(-1).getTokenIndex());
                    field.initialValue(value);
                }
            }
            while (this.input.LA(1) == 20) {
                this.annotation(field);
                if (!this.state.failed) continue;
                return;
            }
            field.processAnnotations();
            if (this.input.LA(1) == 33) {
                this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(FieldDescrBuilder.class, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDescr function(PackageDescrBuilder pkg) throws RecognitionException {
        FunctionDescrBuilder function = null;
        try {
            function = this.helper.start(pkg, FunctionDescrBuilder.class, null);
            this.match(this.input, 67, "function", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                FunctionDescr functionDescr = null;
                return functionDescr;
            }
            if (this.input.LA(1) != 67 || this.input.LA(2) != 42) {
                String type = this.type();
                if (this.state.failed) {
                    FunctionDescr functionDescr = null;
                    return functionDescr;
                }
                if (this.state.backtracking == 0) {
                    function.returnType(type);
                }
            }
            Token id = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                FunctionDescr functionDescr = null;
                return functionDescr;
            }
            if (this.state.backtracking == 0) {
                function.name(id.getText());
                this.helper.setParaphrasesValue(DroolsParaphraseTypes.FUNCTION, "\"" + id.getText() + "\"");
            }
            this.parameters(function, true);
            if (this.state.failed) {
                FunctionDescr functionDescr = null;
                return functionDescr;
            }
            String body = this.chunk(46, 47, -1);
            if (this.state.failed) {
                FunctionDescr functionDescr = null;
                return functionDescr;
            }
            if (this.state.backtracking == 0) {
                function.body(body);
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(FunctionDescrBuilder.class, function);
        }
        return function != null ? (FunctionDescr)function.getDescr() : null;
    }

    private void parameters(ParameterSupportBuilder<?> statement, boolean requiresType) throws RecognitionException {
        this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) != 43) {
            this.parameter(statement, requiresType);
            if (this.state.failed) {
                return;
            }
            while (this.input.LA(1) == 48) {
                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
                this.parameter(statement, requiresType);
                if (!this.state.failed) continue;
                return;
            }
        }
        this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return;
        }
    }

    private void parameter(ParameterSupportBuilder<?> statement, boolean requiresType) throws RecognitionException {
        String type = "Object";
        if (requiresType) {
            type = this.type();
            if (this.state.failed) {
                return;
            }
        }
        int start = this.input.index();
        this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER);
        if (this.state.failed) {
            return;
        }
        while (this.input.LA(1) == 44) {
            this.match(this.input, 44, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
            this.match(this.input, 45, null, null, DroolsEditorType.SYMBOL);
            if (!this.state.failed) continue;
            return;
        }
        int end = this.input.LT(-1).getTokenIndex();
        if (this.state.backtracking == 0) {
            statement.parameter(type, this.input.toString(start, end));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleDescr query(PackageDescrBuilder pkg) throws RecognitionException {
        QueryDescrBuilder query = null;
        try {
            query = this.helper.start(pkg, QueryDescrBuilder.class, null);
            this.match(this.input, 67, "query", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                RuleDescr ruleDescr = null;
                return ruleDescr;
            }
            if (this.helper.validateIdentifierKey("when") || this.helper.validateIdentifierKey("then") || this.helper.validateIdentifierKey("end")) {
                this.failMissingTokenException();
                RuleDescr ruleDescr = null;
                return ruleDescr;
            }
            String name = this.stringId();
            if (this.state.backtracking == 0) {
                query.name(name);
            }
            if (this.state.failed) {
                RuleDescr ruleDescr = null;
                return ruleDescr;
            }
            if (this.state.backtracking == 0) {
                this.helper.emit(2000);
            }
            if (this.speculateParameters(true)) {
                this.parameters(query, true);
                if (this.state.failed) {
                    RuleDescr ruleDescr = null;
                    return ruleDescr;
                }
                if (this.state.backtracking == 0) {
                    this.helper.emit(1);
                }
            } else if (this.speculateParameters(false)) {
                this.parameters(query, false);
                if (this.state.failed) {
                    RuleDescr ruleDescr = null;
                    return ruleDescr;
                }
                if (this.state.backtracking == 0) {
                    this.helper.emit(1);
                }
            }
            while (this.input.LA(1) == 20) {
                this.annotation(query);
                if (!this.state.failed) continue;
                RuleDescr ruleDescr = null;
                return ruleDescr;
            }
            if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                this.helper.emit(1);
            }
            if (this.input.LA(1) != -1) {
                this.lhsExpression(query != null ? query.lhs() : null);
            }
            this.match(this.input, 67, "end", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                RuleDescr ruleDescr = null;
                return ruleDescr;
            }
            this.helper.emit(1000);
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(QueryDescrBuilder.class, query);
        }
        return query != null ? (QueryDescr)query.getDescr() : null;
    }

    private boolean speculateParameters(boolean requiresType) {
        ++this.state.backtracking;
        int start = this.input.mark();
        try {
            this.parameters(null, requiresType);
        }
        catch (RecognitionException re) {
            System.err.println("impossible: " + re);
            re.printStackTrace();
        }
        boolean success = !this.state.failed;
        this.input.rewind(start);
        --this.state.backtracking;
        this.state.failed = false;
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleDescr rule(PackageDescrBuilder pkg) throws RecognitionException {
        RuleDescrBuilder rule = null;
        try {
            RuleDescr ruleDescr;
            rule = this.helper.start(pkg, RuleDescrBuilder.class, null);
            this.match(this.input, 67, "rule", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                RuleDescr ruleDescr2 = null;
                return ruleDescr2;
            }
            if (this.helper.validateIdentifierKey("when") || this.helper.validateIdentifierKey("then") || this.helper.validateIdentifierKey("end")) {
                this.failMissingTokenException();
                RuleDescr ruleDescr3 = null;
                return ruleDescr3;
            }
            String name = this.stringId();
            if (this.state.failed) {
                RuleDescr ruleDescr4 = null;
                return ruleDescr4;
            }
            if (this.state.backtracking == 0) {
                rule.name(name);
                this.helper.setParaphrasesValue(DroolsParaphraseTypes.RULE, "\"" + name + "\"");
                this.helper.emit(2000);
            }
            if (this.helper.validateIdentifierKey("extends")) {
                this.match(this.input, 67, "extends", null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    RuleDescr ruleDescr5 = null;
                    return ruleDescr5;
                }
                String parent = this.stringId();
                if (this.state.backtracking == 0) {
                    rule.extendsRule(parent);
                }
                if (this.state.failed) {
                    RuleDescr ruleDescr6 = null;
                    return ruleDescr6;
                }
            }
            if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                this.helper.emit(2000);
            }
            while (this.input.LA(1) == 20) {
                this.annotation(rule);
                if (!this.state.failed) continue;
                ruleDescr = null;
                return ruleDescr;
            }
            this.attributes(rule);
            if (this.helper.validateIdentifierKey("when")) {
                this.lhs(rule);
            } else {
                rule.lhs();
            }
            this.rhs(rule);
            this.match(this.input, 67, "end", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                ruleDescr = null;
                return ruleDescr;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        finally {
            this.helper.end(RuleDescrBuilder.class, rule);
        }
        return rule != null ? (RuleDescr)rule.getDescr() : null;
    }

    private String stringId() throws RecognitionException {
        if (this.input.LA(1) == 67) {
            Token id = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return null;
            }
            return id.getText();
        }
        if (this.input.LA(1) == 14) {
            Token id = this.match(this.input, 14, null, null, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return null;
            }
            return StringUtils.unescapeJava(this.safeStripStringDelimiters(id.getText()));
        }
        throw new MismatchedTokenException(67, this.input);
    }

    private void attributes(RuleDescrBuilder rule) throws RecognitionException {
        if (this.helper.validateIdentifierKey("attributes")) {
            this.match(this.input, 67, "attributes", null, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return;
            }
            if (this.input.LA(1) == 34) {
                this.match(this.input, 34, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
            }
        }
        if (this.helper.validateAttribute(1)) {
            this.attribute(rule);
            if (this.state.failed) {
                return;
            }
            while (this.input.LA(1) == 48 || this.helper.validateAttribute(1)) {
                if (this.input.LA(1) == 48) {
                    this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        return;
                    }
                }
                this.attribute(rule);
                if (!this.state.failed) continue;
                return;
            }
        }
    }

    public AttributeDescr attribute(AttributeSupportBuilder<?> as) {
        AttributeDescr attribute = null;
        try {
            if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                this.helper.emit(2001);
            }
            if (this.helper.validateIdentifierKey("salience")) {
                attribute = this.salience(as);
            } else if (this.helper.validateIdentifierKey("enabled")) {
                attribute = this.enabled(as);
            } else if (this.helper.validateIdentifierKey("no") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "loop")) {
                attribute = this.booleanAttribute(as, new String[]{"no", "-", "loop"});
            } else if (this.helper.validateIdentifierKey("auto") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "focus")) {
                attribute = this.booleanAttribute(as, new String[]{"auto", "-", "focus"});
            } else if (this.helper.validateIdentifierKey("lock") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "on") && this.helper.validateLT(4, "-") && this.helper.validateLT(5, "active")) {
                attribute = this.booleanAttribute(as, new String[]{"lock", "-", "on", "-", "active"});
            } else if (this.helper.validateIdentifierKey("refract")) {
                attribute = this.booleanAttribute(as, new String[]{"refract"});
            } else if (this.helper.validateIdentifierKey("agenda") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "group")) {
                attribute = this.stringAttribute(as, new String[]{"agenda", "-", "group"});
            } else if (this.helper.validateIdentifierKey("activation") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "group")) {
                attribute = this.stringAttribute(as, new String[]{"activation", "-", "group"});
            } else if (this.helper.validateIdentifierKey("ruleflow") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "group")) {
                attribute = this.stringAttribute(as, new String[]{"ruleflow", "-", "group"});
            } else if (this.helper.validateIdentifierKey("date") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "effective")) {
                attribute = this.stringAttribute(as, new String[]{"date", "-", "effective"});
                attribute.setType(AttributeDescr.Type.DATE);
            } else if (this.helper.validateIdentifierKey("date") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "expires")) {
                attribute = this.stringAttribute(as, new String[]{"date", "-", "expires"});
                attribute.setType(AttributeDescr.Type.DATE);
            } else if (this.helper.validateIdentifierKey("dialect")) {
                attribute = this.stringAttribute(as, new String[]{"dialect"});
            } else if (this.helper.validateIdentifierKey("calendars")) {
                attribute = this.stringListAttribute(as, new String[]{"calendars"});
            } else if (this.helper.validateIdentifierKey("timer")) {
                attribute = this.intOrChunkAttribute(as, new String[]{"timer"});
            } else if (this.helper.validateIdentifierKey("duration")) {
                attribute = this.intOrChunkAttribute(as, new String[]{"duration"});
            }
            if (this.state.backtracking == 0) {
                this.helper.emit(2000);
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeDescr salience(AttributeSupportBuilder<?> as) throws RecognitionException {
        AttributeDescrBuilder attribute = null;
        try {
            this.match(this.input, 67, "salience", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                AttributeDescr attributeDescr = null;
                return attributeDescr;
            }
            if (this.state.backtracking == 0) {
                attribute = this.helper.start((DescrBuilder)((Object)as), AttributeDescrBuilder.class, "salience");
            }
            boolean hasParen = this.input.LA(1) == 42;
            int first = this.input.index();
            if (hasParen) {
                this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
            }
            String value = this.conditionalExpression();
            if (this.state.failed) {
                AttributeDescr attributeDescr = null;
                return attributeDescr;
            }
            if (hasParen) {
                this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
            }
            if (this.state.backtracking == 0) {
                if (hasParen) {
                    value = this.input.toString(first, this.input.LT(-1).getTokenIndex());
                }
                attribute.value(value);
                attribute.type(AttributeDescr.Type.EXPRESSION);
            }
        }
        finally {
            if (attribute != null) {
                this.helper.end(AttributeDescrBuilder.class, attribute);
            }
        }
        return attribute != null ? (AttributeDescr)attribute.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeDescr enabled(AttributeSupportBuilder<?> as) throws RecognitionException {
        AttributeDescrBuilder attribute = null;
        try {
            this.match(this.input, 67, "enabled", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                AttributeDescr attributeDescr = null;
                return attributeDescr;
            }
            if (this.state.backtracking == 0) {
                attribute = this.helper.start((DescrBuilder)((Object)as), AttributeDescrBuilder.class, "enabled");
            }
            boolean hasParen = this.input.LA(1) == 42;
            int first = this.input.index();
            if (hasParen) {
                this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
            }
            String value = this.conditionalExpression();
            if (this.state.failed) {
                AttributeDescr attributeDescr = null;
                return attributeDescr;
            }
            if (hasParen) {
                this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
            }
            if (this.state.backtracking == 0) {
                if (hasParen) {
                    value = this.input.toString(first, this.input.LT(-1).getTokenIndex());
                }
                attribute.value(value);
                attribute.type(AttributeDescr.Type.EXPRESSION);
            }
        }
        finally {
            if (attribute != null) {
                this.helper.end(AttributeDescrBuilder.class, attribute);
            }
        }
        return attribute != null ? (AttributeDescr)attribute.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeDescr booleanAttribute(AttributeSupportBuilder<?> as, String[] key) throws RecognitionException {
        AttributeDescrBuilder attribute = null;
        try {
            StringBuilder builder = new StringBuilder();
            for (String k : key) {
                if ("-".equals(k)) {
                    this.match(this.input, 60, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                } else {
                    this.match(this.input, 67, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                }
                builder.append(k);
            }
            if (this.state.backtracking == 0) {
                attribute = this.helper.start((DescrBuilder)((Object)as), AttributeDescrBuilder.class, builder.toString());
            }
            String value = "true";
            if (this.input.LA(1) == 18) {
                Token bool = this.match(this.input, 18, null, null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
                value = bool.getText();
            }
            if (this.state.backtracking == 0) {
                attribute.value(value);
                attribute.type(AttributeDescr.Type.BOOLEAN);
            }
        }
        finally {
            if (attribute != null) {
                this.helper.end(AttributeDescrBuilder.class, attribute);
            }
        }
        return attribute != null ? (AttributeDescr)attribute.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeDescr stringAttribute(AttributeSupportBuilder<?> as, String[] key) throws RecognitionException {
        AttributeDescrBuilder attribute = null;
        try {
            StringBuilder builder = new StringBuilder();
            for (String k : key) {
                if ("-".equals(k)) {
                    this.match(this.input, 60, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                } else {
                    this.match(this.input, 67, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                }
                builder.append(k);
            }
            if (this.state.backtracking == 0) {
                attribute = this.helper.start((DescrBuilder)((Object)as), AttributeDescrBuilder.class, builder.toString());
            }
            Token value = this.match(this.input, 14, null, null, DroolsEditorType.STRING_CONST);
            if (this.state.failed) {
                AttributeDescr attributeDescr = null;
                return attributeDescr;
            }
            if (this.state.backtracking == 0) {
                attribute.value(StringUtils.unescapeJava(this.safeStripStringDelimiters(value.getText())));
                attribute.type(AttributeDescr.Type.STRING);
            }
        }
        finally {
            if (attribute != null) {
                this.helper.end(AttributeDescrBuilder.class, attribute);
            }
        }
        return attribute != null ? (AttributeDescr)attribute.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeDescr stringListAttribute(AttributeSupportBuilder<?> as, String[] key) throws RecognitionException {
        AttributeDescrBuilder attribute = null;
        try {
            StringBuilder builder = new StringBuilder();
            for (String k : key) {
                if ("-".equals(k)) {
                    this.match(this.input, 60, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                } else {
                    this.match(this.input, 67, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                }
                builder.append(k);
            }
            if (this.state.backtracking == 0) {
                attribute = this.helper.start((DescrBuilder)((Object)as), AttributeDescrBuilder.class, builder.toString());
            }
            builder = new StringBuilder();
            builder.append("[ ");
            Token value = this.match(this.input, 14, null, null, DroolsEditorType.STRING_CONST);
            if (this.state.failed) {
                AttributeDescr attributeDescr = null;
                return attributeDescr;
            }
            builder.append(value.getText());
            while (this.input.LA(1) == 48) {
                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
                builder.append(", ");
                value = this.match(this.input, 14, null, null, DroolsEditorType.STRING_CONST);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
                builder.append(value.getText());
            }
            builder.append(" ]");
            if (this.state.backtracking == 0) {
                attribute.value(builder.toString());
                attribute.type(AttributeDescr.Type.LIST);
            }
        }
        finally {
            if (attribute != null) {
                this.helper.end(AttributeDescrBuilder.class, attribute);
            }
        }
        return attribute != null ? (AttributeDescr)attribute.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeDescr intOrChunkAttribute(AttributeSupportBuilder<?> as, String[] key) throws RecognitionException {
        AttributeDescrBuilder attribute = null;
        try {
            String value;
            StringBuilder builder = new StringBuilder();
            for (String k : key) {
                if ("-".equals(k)) {
                    this.match(this.input, 60, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                } else {
                    this.match(this.input, 67, k, null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                }
                builder.append(k);
            }
            if (this.state.backtracking == 0) {
                attribute = this.helper.start((DescrBuilder)((Object)as), AttributeDescrBuilder.class, builder.toString());
            }
            if (this.input.LA(1) == 42) {
                value = this.chunk(42, 43, -1);
                if (this.state.failed) {
                    AttributeDescr len$ = null;
                    return len$;
                }
                if (this.state.backtracking == 0) {
                    attribute.value(this.safeStripDelimiters(value, "(", ")"));
                    attribute.type(AttributeDescr.Type.EXPRESSION);
                }
            } else {
                value = "";
                if (this.input.LA(1) == 61) {
                    Token sign = this.match(this.input, 61, null, null, DroolsEditorType.NUMERIC_CONST);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                    value = value + sign.getText();
                } else if (this.input.LA(1) == 60) {
                    Token sign = this.match(this.input, 60, null, null, DroolsEditorType.NUMERIC_CONST);
                    if (this.state.failed) {
                        AttributeDescr attributeDescr = null;
                        return attributeDescr;
                    }
                    value = value + sign.getText();
                }
                Token nbr = this.match(this.input, 12, null, null, DroolsEditorType.NUMERIC_CONST);
                if (this.state.failed) {
                    AttributeDescr attributeDescr = null;
                    return attributeDescr;
                }
                value = value + nbr.getText();
                if (this.state.backtracking == 0) {
                    attribute.value(value);
                    attribute.type(AttributeDescr.Type.NUMBER);
                }
            }
        }
        finally {
            if (attribute != null) {
                this.helper.end(AttributeDescrBuilder.class, attribute);
            }
        }
        return attribute != null ? (AttributeDescr)attribute.getDescr() : null;
    }

    private void lhs(RuleDescrBuilder rule) throws RecognitionException {
        this.match(this.input, 67, "when", null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) == 34) {
            this.match(this.input, 34, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
        }
        this.lhsExpression(rule != null ? rule.lhs() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lhsExpression(CEDescrBuilder<?, AndDescr> lhs) throws RecognitionException {
        this.helper.start(lhs, CEDescrBuilder.class, null);
        if (this.state.backtracking == 0) {
            this.helper.emit(1);
        }
        try {
            while (this.input.LA(1) != -1 && !this.helper.validateIdentifierKey("then") && !this.helper.validateIdentifierKey("end")) {
                if (this.state.backtracking == 0) {
                    this.helper.emit(1);
                }
                this.lhsOr(lhs, true);
                if (lhs.getDescr() != null && lhs.getDescr() instanceof ConditionalElementDescr) {
                    ConditionalElementDescr root = (ConditionalElementDescr)lhs.getDescr();
                    BaseDescr[] descrs = root.getDescrs().toArray(new BaseDescr[root.getDescrs().size()]);
                    root.getDescrs().clear();
                    for (int i = 0; i < descrs.length; ++i) {
                        root.addOrMerge(descrs[i]);
                    }
                }
                if (!this.state.failed) continue;
                return;
            }
        }
        finally {
            this.helper.end(CEDescrBuilder.class, lhs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDescr lhsOr(CEDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        BaseDescr result;
        block32: {
            result = null;
            if (allowOr && this.input.LA(1) == 42 && this.helper.validateLT(2, "or")) {
                CEDescrBuilder<CEDescrBuilder<?, ?>, OrDescr> or = null;
                if (this.state.backtracking == 0) {
                    or = ce.or();
                    result = (BaseDescr)or.getDescr();
                    this.helper.start(or, CEDescrBuilder.class, null);
                }
                try {
                    this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    this.match(this.input, 67, "or", null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    if (this.state.backtracking == 0) {
                        this.helper.emit(3);
                    }
                    while (this.input.LA(1) != 43) {
                        this.lhsAnd(or, allowOr);
                        if (!this.state.failed) continue;
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    break block32;
                }
                finally {
                    if (this.state.backtracking == 0) {
                        this.helper.end(CEDescrBuilder.class, or);
                    }
                }
            }
            CEDescrBuilder<CEDescrBuilder<?, ?>, OrDescr> or = null;
            if (this.state.backtracking == 0) {
                or = ce.or();
                result = (BaseDescr)or.getDescr();
                this.helper.start(or, CEDescrBuilder.class, null);
            }
            try {
                this.lhsAnd(or, allowOr);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
                if (allowOr && (this.helper.validateIdentifierKey("or") || this.input.LA(1) == 51)) {
                    while (this.helper.validateIdentifierKey("or") || this.input.LA(1) == 51) {
                        if (this.input.LA(1) == 51) {
                            this.match(this.input, 51, null, null, DroolsEditorType.SYMBOL);
                        } else {
                            this.match(this.input, 67, "or", null, DroolsEditorType.KEYWORD);
                        }
                        if (this.state.failed) {
                            BaseDescr baseDescr = null;
                            return baseDescr;
                        }
                        if (this.state.backtracking == 0) {
                            this.helper.emit(3);
                        }
                        this.lhsAnd(or, allowOr);
                        if (!this.state.failed) continue;
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                } else if (allowOr && this.state.backtracking == 0) {
                    ((ConditionalElementDescr)ce.getDescr()).getDescrs().remove(or.getDescr());
                    for (BaseDescr base : ((OrDescr)or.getDescr()).getDescrs()) {
                        ((ConditionalElementDescr)ce.getDescr()).addDescr(base);
                    }
                    result = (BaseDescr)ce.getDescr();
                }
            }
            finally {
                if (this.state.backtracking == 0) {
                    this.helper.end(CEDescrBuilder.class, or);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDescr lhsAnd(CEDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        BaseDescr result;
        block32: {
            result = null;
            if (this.input.LA(1) == 42 && this.helper.validateLT(2, "and")) {
                CEDescrBuilder<CEDescrBuilder<?, ?>, AndDescr> and = null;
                if (this.state.backtracking == 0) {
                    and = ce.and();
                    result = (BaseDescr)ce.getDescr();
                    this.helper.start(and, CEDescrBuilder.class, null);
                }
                try {
                    this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    this.match(this.input, 67, "and", null, DroolsEditorType.KEYWORD);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    if (this.state.backtracking == 0) {
                        this.helper.emit(3);
                    }
                    while (this.input.LA(1) != 43) {
                        this.lhsUnary(and, allowOr);
                        if (!this.state.failed) continue;
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    break block32;
                }
                finally {
                    if (this.state.backtracking == 0) {
                        this.helper.end(CEDescrBuilder.class, and);
                    }
                }
            }
            CEDescrBuilder<CEDescrBuilder<?, ?>, AndDescr> and = null;
            if (this.state.backtracking == 0) {
                and = ce.and();
                result = (BaseDescr)and.getDescr();
                this.helper.start(and, CEDescrBuilder.class, null);
            }
            try {
                this.lhsUnary(and, allowOr);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
                if (this.helper.validateIdentifierKey("and") || this.input.LA(1) == 50) {
                    while (this.helper.validateIdentifierKey("and") || this.input.LA(1) == 50) {
                        if (this.input.LA(1) == 50) {
                            this.match(this.input, 50, null, null, DroolsEditorType.SYMBOL);
                        } else {
                            this.match(this.input, 67, "and", null, DroolsEditorType.KEYWORD);
                        }
                        if (this.state.failed) {
                            BaseDescr baseDescr = null;
                            return baseDescr;
                        }
                        if (this.state.backtracking == 0) {
                            this.helper.emit(3);
                        }
                        this.lhsUnary(and, allowOr);
                        if (!this.state.failed) continue;
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                } else if (this.state.backtracking == 0) {
                    ((ConditionalElementDescr)ce.getDescr()).getDescrs().remove(and.getDescr());
                    for (BaseDescr base : ((AndDescr)and.getDescr()).getDescrs()) {
                        ((ConditionalElementDescr)ce.getDescr()).addDescr(base);
                    }
                    result = (BaseDescr)ce.getDescr();
                }
            }
            finally {
                if (this.state.backtracking == 0) {
                    this.helper.end(CEDescrBuilder.class, and);
                }
            }
        }
        return result;
    }

    private BaseDescr lhsUnary(CEDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        BaseDescr result = null;
        if (this.helper.validateIdentifierKey("exists")) {
            result = this.lhsExists(ce, allowOr);
        } else if (this.helper.validateIdentifierKey("not")) {
            result = this.lhsNot(ce, allowOr);
        } else if (this.helper.validateIdentifierKey("eval")) {
            result = this.lhsEval(ce);
        } else if (this.helper.validateIdentifierKey("forall")) {
            result = this.lhsForall(ce);
        } else if (this.helper.validateIdentifierKey("accumulate")) {
            result = this.lhsAccumulate(ce);
        } else if (this.input.LA(1) == 42) {
            result = this.lhsParen(ce, allowOr);
        } else if (this.input.LA(1) == 67 || this.input.LA(1) == 52) {
            result = this.lhsPatternBind(ce, allowOr);
        } else {
            this.failMismatchedTokenException();
        }
        if (this.input.LA(1) == 33) {
            this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDescr lhsExists(CEDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        CEDescrBuilder<CEDescrBuilder<?, ?>, ExistsDescr> exists = null;
        if (this.state.backtracking == 0) {
            exists = ce.exists();
            this.helper.start(exists, CEDescrBuilder.class, null);
        }
        try {
            this.match(this.input, 67, "exists", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            if (this.state.backtracking == 0) {
                this.helper.emit(2);
            }
            if (this.input.LA(1) == 42) {
                boolean prefixed;
                boolean bl = prefixed = this.helper.validateLT(2, "and") || this.helper.validateLT(2, "or");
                if (!prefixed) {
                    this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                }
                this.lhsOr(exists, allowOr);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
                if (!prefixed) {
                    this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                }
            } else {
                this.lhsPatternBind(exists, true);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
            }
        }
        finally {
            if (this.state.backtracking == 0) {
                this.helper.end(CEDescrBuilder.class, exists);
            }
        }
        return exists != null ? (ExistsDescr)exists.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDescr lhsNot(CEDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        CEDescrBuilder<CEDescrBuilder<?, ?>, NotDescr> not = null;
        if (this.state.backtracking == 0) {
            not = ce.not();
            this.helper.start(not, CEDescrBuilder.class, null);
        }
        try {
            this.match(this.input, 67, "not", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            if (this.state.backtracking == 0) {
                this.helper.emit(4);
            }
            if (this.input.LA(1) == 42) {
                boolean prefixed;
                boolean bl = prefixed = this.helper.validateLT(2, "and") || this.helper.validateLT(2, "or");
                if (!prefixed) {
                    this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                }
                if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                    this.helper.emit(1);
                }
                this.lhsOr(not, allowOr);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
                if (!prefixed) {
                    this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                }
            } else if (this.input.LA(1) != -1) {
                this.lhsPatternBind(not, true);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
            }
        }
        finally {
            if (this.state.backtracking == 0) {
                this.helper.end(CEDescrBuilder.class, not);
            }
        }
        return not != null ? (NotDescr)not.getDescr() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDescr lhsForall(CEDescrBuilder<?, ?> ce) throws RecognitionException {
        ForallDescrBuilder forall = this.helper.start(ce, ForallDescrBuilder.class, null);
        try {
            this.match(this.input, 67, "forall", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            do {
                this.lhsPatternBind(forall, false);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
                if (this.input.LA(1) != 48) continue;
                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                if (!this.state.failed) continue;
                BaseDescr baseDescr = null;
                return baseDescr;
            } while (this.input.LA(1) != -1 && this.input.LA(1) != 43);
            this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
        }
        finally {
            this.helper.end(ForallDescrBuilder.class, forall);
        }
        return forall != null ? (ForallDescr)forall.getDescr() : null;
    }

    private BaseDescr lhsEval(CEDescrBuilder<?, ?> ce) throws RecognitionException {
        EvalDescrBuilder eval = null;
        try {
            String expr;
            eval = this.helper.start(ce, EvalDescrBuilder.class, null);
            this.match(this.input, 67, "eval", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            if (this.state.backtracking == 0) {
                this.helper.emit(200);
            }
            int idx = this.input.index();
            try {
                expr = this.conditionalExpression();
            }
            catch (RecognitionException e) {
                DroolsToken tempToken = this.helper.getLastTokenOnList(this.helper.getEditorInterface().getLast().getContent());
                if (tempToken != null) {
                    Token token;
                    for (int i = tempToken.getTokenIndex() + 1; i < this.input.size() && (token = this.input.get(i)).getType() != -1; ++i) {
                        this.helper.emit(token, DroolsEditorType.CODE_CHUNK);
                    }
                }
                throw e;
            }
            if (this.state.backtracking == 0) {
                eval.constraint(expr);
            }
            this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                BaseDescr baseDescr = null;
                return baseDescr;
            }
            this.helper.emit(1);
        }
        catch (RecognitionException e) {
            throw e;
        }
        finally {
            this.helper.end(EvalDescrBuilder.class, eval);
        }
        return eval != null ? (EvalDescr)eval.getDescr() : null;
    }

    private BaseDescr lhsParen(CEDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return null;
        }
        if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
            this.helper.emit(1);
        }
        BaseDescr descr = this.lhsOr(ce, allowOr);
        if (this.state.failed) {
            return null;
        }
        this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return null;
        }
        return descr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDescr lhsPatternBind(PatternContainerDescrBuilder<?, ?> ce, boolean allowOr) throws RecognitionException {
        BaseDescr result;
        block30: {
            PatternDescrBuilder pattern = null;
            CEDescrBuilder or = null;
            result = null;
            Token first = this.input.LT(1);
            pattern = this.helper.start((DescrBuilder)((Object)ce), PatternDescrBuilder.class, null);
            if (pattern != null) {
                result = (BaseDescr)pattern.getDescr();
            }
            String label = null;
            boolean isUnification = false;
            if (this.input.LA(1) == 67 && this.input.LA(2) == 34 && !this.helper.validateCEKeyword(1)) {
                label = this.label(DroolsEditorType.IDENTIFIER_PATTERN);
                if (this.state.failed) {
                    return null;
                }
            } else if (this.input.LA(1) == 67 && this.input.LA(2) == 29 && !this.helper.validateCEKeyword(1)) {
                label = this.unif(DroolsEditorType.IDENTIFIER_PATTERN);
                if (this.state.failed) {
                    return null;
                }
                isUnification = true;
            }
            if (this.input.LA(1) == 42) {
                try {
                    this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    if (this.helper.validateCEKeyword(1)) {
                        this.failMismatchedTokenException();
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    this.lhsPattern(pattern, label, isUnification);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    if (allowOr && this.helper.validateIdentifierKey("or") && ce instanceof CEDescrBuilder) {
                        if (this.state.backtracking == 0) {
                            or = ((CEDescrBuilder)ce).or();
                            result = (BaseDescr)or.getDescr();
                            this.helper.end(PatternDescrBuilder.class, pattern);
                            this.helper.start(or, CEDescrBuilder.class, null);
                            this.helper.setStart(or, first);
                            ((ConditionalElementDescr)ce.getDescr()).getDescrs().remove(pattern.getDescr());
                            ((OrDescr)or.getDescr()).addDescr((BaseDescr)pattern.getDescr());
                        }
                        while (this.helper.validateIdentifierKey("or")) {
                            this.match(this.input, 67, "or", null, DroolsEditorType.KEYWORD);
                            if (this.state.failed) {
                                BaseDescr baseDescr = null;
                                return baseDescr;
                            }
                            pattern = this.helper.start(or, PatternDescrBuilder.class, null);
                            this.lhsPattern(pattern, label, isUnification);
                            if (this.state.failed) {
                                BaseDescr baseDescr = null;
                                return baseDescr;
                            }
                            this.helper.end(PatternDescrBuilder.class, pattern);
                        }
                    }
                    this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        BaseDescr baseDescr = null;
                        return baseDescr;
                    }
                    break block30;
                }
                finally {
                    if (or != null) {
                        this.helper.end(CEDescrBuilder.class, or);
                    } else {
                        this.helper.end(PatternDescrBuilder.class, pattern);
                    }
                }
            }
            try {
                this.lhsPattern(pattern, label, isUnification);
                if (this.state.failed) {
                    BaseDescr baseDescr = null;
                    return baseDescr;
                }
            }
            finally {
                this.helper.end(PatternDescrBuilder.class, pattern);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseDescr lhsAccumulate(PatternContainerDescrBuilder<?, ?> ce) throws RecognitionException {
        PatternDescrBuilder pattern = null;
        BaseDescr result = null;
        pattern = this.helper.start((DescrBuilder)((Object)ce), PatternDescrBuilder.class, null);
        if (pattern != null) {
            result = (BaseDescr)pattern.getDescr();
        }
        try {
            if (this.state.backtracking == 0) {
                pattern.type("Object[]");
                pattern.isQuery(false);
            }
            AccumulateDescrBuilder accumulate = this.helper.start(pattern, AccumulateDescrBuilder.class, null);
            if (this.state.backtracking == 0) {
                accumulate.multiFunction(true);
            }
            try {
                BaseDescr baseDescr;
                this.match(this.input, 67, "accumulate", null, DroolsEditorType.KEYWORD);
                if (this.state.failed) {
                    BaseDescr baseDescr2 = null;
                    return baseDescr2;
                }
                if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                    this.helper.emit(302);
                }
                this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    BaseDescr baseDescr3 = null;
                    return baseDescr3;
                }
                CEDescrBuilder source = accumulate.source();
                try {
                    this.helper.start(source, CEDescrBuilder.class, null);
                    this.lhsAnd(source, false);
                    if (this.state.failed) {
                        BaseDescr baseDescr4 = null;
                        return baseDescr4;
                    }
                    if (source.getDescr() != null && source.getDescr() instanceof ConditionalElementDescr) {
                        ConditionalElementDescr root = (ConditionalElementDescr)source.getDescr();
                        BaseDescr[] descrs = root.getDescrs().toArray(new BaseDescr[root.getDescrs().size()]);
                        root.getDescrs().clear();
                        for (int i = 0; i < descrs.length; ++i) {
                            root.addOrMerge(descrs[i]);
                        }
                    }
                }
                finally {
                    this.helper.end(CEDescrBuilder.class, source);
                }
                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    baseDescr = null;
                    return baseDescr;
                }
                this.accumulateFunctionBinding(accumulate);
                if (this.state.failed) {
                    baseDescr = null;
                    return baseDescr;
                }
                while (this.input.LA(1) == 48) {
                    this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        baseDescr = null;
                        return baseDescr;
                    }
                    this.accumulateFunctionBinding(accumulate);
                    if (!this.state.failed) continue;
                    baseDescr = null;
                    return baseDescr;
                }
                this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    baseDescr = null;
                    return baseDescr;
                }
            }
            finally {
                this.helper.end(AccumulateDescrBuilder.class, accumulate);
                if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                    this.helper.emit(1);
                }
            }
        }
        finally {
            this.helper.end(PatternDescrBuilder.class, pattern);
        }
        if (this.input.LA(1) != 33) return result;
        this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
        if (!this.state.failed) return result;
        return null;
    }

    private void failMismatchedTokenException() throws DroolsMismatchedTokenException {
        if (this.state.backtracking <= 0) {
            DroolsMismatchedTokenException mte = new DroolsMismatchedTokenException(this.input.LA(1), this.input.LT(1).getText(), this.input);
            this.input.consume();
            throw mte;
        }
        this.state.failed = true;
    }

    private void failMissingTokenException() throws MissingTokenException {
        if (this.state.backtracking <= 0) {
            throw new MissingTokenException(14, this.input, null);
        }
        this.state.failed = true;
    }

    private void lhsPattern(PatternDescrBuilder<?> pattern, String label, boolean isUnification) throws RecognitionException {
        boolean query = false;
        if (this.input.LA(1) == 52) {
            this.match(this.input, 52, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
            query = true;
        }
        String type = this.qualifiedIdentifier();
        if (this.state.failed) {
            return;
        }
        if (this.state.backtracking == 0) {
            pattern.type(type);
            pattern.isQuery(query);
            if (label != null) {
                pattern.id(label, isUnification);
            }
        }
        this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) != 43 && this.speculatePositionalConstraints()) {
            this.positionalConstraints(pattern);
        }
        if (this.input.LA(1) != 43) {
            this.constraints(pattern);
        }
        this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return;
        }
        if (this.helper.validateIdentifierKey("over")) {
            this.patternFilter(pattern);
        }
        if (this.helper.validateIdentifierKey("from")) {
            this.patternSource(pattern);
        }
        if (this.state.backtracking == 0) {
            this.helper.emit(1);
        }
    }

    private String label(DroolsEditorType edType) throws RecognitionException {
        Token label = this.match(this.input, 67, null, null, edType);
        if (this.state.failed) {
            return null;
        }
        this.match(this.input, 34, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return null;
        }
        return label.getText();
    }

    private String unif(DroolsEditorType edType) throws RecognitionException {
        Token label = this.match(this.input, 67, null, null, edType);
        if (this.state.failed) {
            return null;
        }
        this.match(this.input, 29, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return null;
        }
        return label.getText();
    }

    private boolean speculatePositionalConstraints() {
        ++this.state.backtracking;
        int start = this.input.mark();
        try {
            this.positionalConstraints(null);
        }
        catch (RecognitionException re) {
            System.err.println("impossible: " + re);
            re.printStackTrace();
        }
        boolean success = !this.state.failed;
        this.input.rewind(start);
        --this.state.backtracking;
        this.state.failed = false;
        return success;
    }

    private void positionalConstraints(PatternDescrBuilder<?> pattern) throws RecognitionException {
        this.constraint(pattern, true);
        if (this.state.failed) {
            return;
        }
        while (this.input.LA(1) == 48) {
            this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
            this.constraint(pattern, true);
            if (!this.state.failed) continue;
            return;
        }
        this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return;
        }
    }

    private void constraints(PatternDescrBuilder<?> pattern) throws RecognitionException {
        this.constraint(pattern, false);
        if (this.state.failed) {
            return;
        }
        while (this.input.LA(1) == 48) {
            this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
            this.constraint(pattern, false);
            if (!this.state.failed) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constraint(PatternDescrBuilder<?> pattern, boolean positional) throws RecognitionException {
        int first;
        block26: {
            if (this.state.backtracking == 0) {
                this.helper.emit(100);
            }
            first = this.input.index();
            this.exprParser.getHelper().setHasOperator(false);
            try {
                this.exprParser.conditionalOrExpression();
                Object var5_4 = null;
                if (this.state.backtracking != 0) break block26;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.state.backtracking == 0) {
                    if (this.input.LA(1) == 67 && this.input.LA(2) == -1) {
                        this.helper.emit(102);
                    } else if (this.input.LA(1) != -1) {
                        this.helper.emit(103);
                    } else if (!this.lastTokenWasWhiteSpace()) {
                        int location = this.getCurrentLocation();
                        if (location == 103) {
                            this.helper.emit(102);
                        } else if (this.input.get(this.input.index()).getType() != -1) {
                            this.helper.emit(100);
                        }
                    } else if (this.getCurrentLocation() == 100 && !this.exprParser.getHelper().getHasOperator() && this.lastTokenWasWhiteSpace() && this.input.LA(1) == -1 && this.input.LA(-1) == 67) {
                        this.helper.emit(101);
                    }
                }
                throw throwable;
            }
            if (this.input.LA(1) == 67 && this.input.LA(2) == -1) {
                this.helper.emit(102);
            } else if (this.input.LA(1) != -1) {
                this.helper.emit(103);
            } else if (!this.lastTokenWasWhiteSpace()) {
                int location = this.getCurrentLocation();
                if (location == 103) {
                    this.helper.emit(102);
                } else if (this.input.get(this.input.index()).getType() != -1) {
                    this.helper.emit(100);
                }
            } else if (this.getCurrentLocation() == 100 && !this.exprParser.getHelper().getHasOperator() && this.lastTokenWasWhiteSpace() && this.input.LA(1) == -1 && this.input.LA(-1) == 67) {
                this.helper.emit(101);
            }
        }
        if (this.state.failed) {
            return;
        }
        if (this.state.backtracking == 0 && this.input.index() > first) {
            int last = this.input.LT(-1).getTokenIndex();
            String expr = this.input.toString(first, last);
            pattern.constraint(expr, positional);
            BaseDescr constrDescr = ((PatternDescr)pattern.getDescr()).getDescrs().get(((PatternDescr)pattern.getDescr()).getDescrs().size() - 1);
            constrDescr.setLocation(this.input.get(first).getLine(), this.input.get(first).getCharPositionInLine());
            constrDescr.setEndLocation(this.input.get(last).getLine(), this.input.get(last).getCharPositionInLine());
            constrDescr.setStartCharacter(((CommonToken)this.input.get(first)).getStartIndex());
            constrDescr.setEndCharacter(((CommonToken)this.input.get(last)).getStopIndex());
        }
    }

    private boolean lastTokenWasWhiteSpace() {
        block4: for (int index = this.input.index(); index >= 0; --index) {
            int type = this.input.get(index).getType();
            switch (type) {
                case -1: {
                    continue block4;
                }
                case 5: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private int getCurrentLocation() {
        LinkedList<DroolsSentence> ei = this.helper.getEditorInterface();
        LinkedList content = ei.getLast().getContent();
        ListIterator listIterator = content.listIterator(content.size());
        while (listIterator.hasPrevious()) {
            Object previous = listIterator.previous();
            if (!(previous instanceof Integer)) continue;
            return (Integer)previous;
        }
        return 0;
    }

    private void patternFilter(PatternDescrBuilder<?> pattern) throws RecognitionException {
        this.match(this.input, 67, "over", null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        this.filterDef(pattern);
        if (this.state.failed) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void filterDef(PatternDescrBuilder<?> pattern) throws RecognitionException {
        BehaviorDescrBuilder behavior;
        block9: {
            block8: {
                block7: {
                    behavior = this.helper.start(pattern, BehaviorDescrBuilder.class, null);
                    try {
                        String bName = this.label(DroolsEditorType.IDENTIFIER_PATTERN);
                        if (this.state.failed) {
                            Object var7_4 = null;
                            this.helper.end(BehaviorDescrBuilder.class, behavior);
                            return;
                        }
                        Token subtype = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER_PATTERN);
                        if (this.state.failed) {
                            break block7;
                        }
                        if (this.state.backtracking == 0) {
                            behavior.type(bName, subtype.getText());
                        }
                        List<String> parameters = this.parameters();
                        if (this.state.failed) {
                            break block8;
                        }
                        if (this.state.backtracking == 0) {
                            behavior.parameters(parameters);
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        this.helper.end(BehaviorDescrBuilder.class, behavior);
                        throw throwable;
                    }
                }
                Object var7_5 = null;
                this.helper.end(BehaviorDescrBuilder.class, behavior);
                return;
            }
            Object var7_6 = null;
            this.helper.end(BehaviorDescrBuilder.class, behavior);
            return;
        }
        Object var7_7 = null;
        this.helper.end(BehaviorDescrBuilder.class, behavior);
    }

    private void patternSource(PatternDescrBuilder<?> pattern) throws RecognitionException {
        this.match(this.input, 67, "from", null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        if (this.state.backtracking == 0) {
            this.helper.emit(300);
        }
        if (this.helper.validateIdentifierKey("accumulate")) {
            this.fromAccumulate(pattern);
        } else if (this.helper.validateIdentifierKey("collect")) {
            this.fromCollect(pattern);
        } else if (this.helper.validateIdentifierKey("entry") && this.helper.validateLT(2, "-") && this.helper.validateLT(3, "point")) {
            this.fromEntryPoint(pattern);
            if (this.state.failed) {
                return;
            }
        } else {
            this.fromExpression(pattern);
            if (!this.lastTokenWasWhiteSpace() && this.input.LA(1) == -1) {
                this.helper.emit(300);
                throw new RecognitionException();
            }
            if (this.state.failed) {
                return;
            }
        }
        if (this.input.LA(1) == 33) {
            this.match(this.input, 33, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
        }
    }

    private void fromExpression(PatternDescrBuilder<?> pattern) throws RecognitionException {
        String expr = this.conditionalOrExpression();
        if (this.state.failed) {
            return;
        }
        if (this.state.backtracking == 0) {
            pattern.from().expression(expr);
            if (this.input.LA(1) != -1) {
                this.helper.emit(1);
            }
        }
    }

    private void fromEntryPoint(PatternDescrBuilder<?> pattern) throws RecognitionException {
        String ep = "";
        this.match(this.input, 67, "entry", null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        this.match(this.input, 60, null, null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        this.match(this.input, 67, "point", null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        ep = this.stringId();
        if (this.state.backtracking == 0) {
            pattern.from().entryPoint(ep);
            if (this.input.LA(1) != -1) {
                this.helper.emit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fromCollect(PatternDescrBuilder<?> pattern) throws RecognitionException {
        CollectDescrBuilder collect;
        block9: {
            block10: {
                block8: {
                    block7: {
                        block6: {
                            collect = this.helper.start(pattern, CollectDescrBuilder.class, null);
                            try {
                                this.match(this.input, 67, "collect", null, DroolsEditorType.KEYWORD);
                                if (this.state.failed) {
                                    Object var4_3 = null;
                                    this.helper.end(CollectDescrBuilder.class, collect);
                                    break block6;
                                }
                                if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                                    this.helper.emit(301);
                                }
                                this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                                if (this.state.failed) {
                                    break block7;
                                }
                                this.lhsPatternBind(collect, false);
                                if (this.state.failed) {
                                    break block8;
                                }
                                this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                                if (!this.state.failed) break block9;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var4_8 = null;
                                this.helper.end(CollectDescrBuilder.class, collect);
                                if (this.state.backtracking != 0) throw throwable;
                                if (this.input.LA(1) == -1) throw throwable;
                                this.helper.emit(1);
                                throw throwable;
                            }
                        }
                        if (this.state.backtracking != 0) return;
                        if (this.input.LA(1) == -1) return;
                        this.helper.emit(1);
                        return;
                    }
                    Object var4_4 = null;
                    this.helper.end(CollectDescrBuilder.class, collect);
                    if (this.state.backtracking != 0) return;
                    if (this.input.LA(1) == -1) return;
                    this.helper.emit(1);
                    return;
                }
                Object var4_5 = null;
                this.helper.end(CollectDescrBuilder.class, collect);
                if (this.state.backtracking != 0) return;
                if (this.input.LA(1) == -1) return;
                this.helper.emit(1);
                return;
            }
            Object var4_6 = null;
            this.helper.end(CollectDescrBuilder.class, collect);
            if (this.state.backtracking != 0) return;
            if (this.input.LA(1) == -1) return;
            this.helper.emit(1);
            return;
        }
        Object var4_7 = null;
        this.helper.end(CollectDescrBuilder.class, collect);
        if (this.state.backtracking != 0) return;
        if (this.input.LA(1) == -1) return;
        this.helper.emit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fromAccumulate(PatternDescrBuilder<?> pattern) throws RecognitionException {
        AccumulateDescrBuilder accumulate;
        block56: {
            block57: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                block43: {
                                                                    block42: {
                                                                        block41: {
                                                                            block40: {
                                                                                accumulate = this.helper.start(pattern, AccumulateDescrBuilder.class, null);
                                                                                try {
                                                                                    this.match(this.input, 67, "accumulate", null, DroolsEditorType.KEYWORD);
                                                                                    if (this.state.failed) {
                                                                                        Object var10_3 = null;
                                                                                        this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                                                        break block40;
                                                                                    }
                                                                                    if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                                                                                        this.helper.emit(302);
                                                                                    }
                                                                                    this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
                                                                                    if (this.state.failed) {
                                                                                        break block41;
                                                                                    }
                                                                                    CEDescrBuilder source = accumulate.source();
                                                                                    try {
                                                                                        this.helper.start(source, CEDescrBuilder.class, null);
                                                                                        this.lhsAnd(source, false);
                                                                                        if (this.state.failed) {
                                                                                            Object var8_23 = null;
                                                                                            this.helper.end(CEDescrBuilder.class, source);
                                                                                            break block42;
                                                                                        }
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        Object var8_25 = null;
                                                                                        this.helper.end(CEDescrBuilder.class, source);
                                                                                        throw throwable;
                                                                                    }
                                                                                    {
                                                                                        if (source.getDescr() != null && source.getDescr() instanceof ConditionalElementDescr) {
                                                                                            ConditionalElementDescr root = (ConditionalElementDescr)source.getDescr();
                                                                                            BaseDescr[] descrs = root.getDescrs().toArray(new BaseDescr[root.getDescrs().size()]);
                                                                                            root.getDescrs().clear();
                                                                                            for (int i = 0; i < descrs.length; ++i) {
                                                                                                root.addOrMerge(descrs[i]);
                                                                                            }
                                                                                        }
                                                                                        Object var8_24 = null;
                                                                                        this.helper.end(CEDescrBuilder.class, source);
                                                                                    }
                                                                                    if (this.input.LA(1) == 48) {
                                                                                        this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                                                                                        if (this.state.failed) {
                                                                                            break block43;
                                                                                        }
                                                                                    }
                                                                                    if (this.helper.validateIdentifierKey("init")) {
                                                                                        this.match(this.input, 67, "init", null, DroolsEditorType.KEYWORD);
                                                                                        if (this.state.failed) {
                                                                                            break block44;
                                                                                        }
                                                                                        if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                                                                                            this.helper.emit(303);
                                                                                        }
                                                                                        String init = this.chunk(42, 43, 304);
                                                                                        if (this.state.failed) {
                                                                                            break block45;
                                                                                        }
                                                                                        if (this.state.backtracking == 0) {
                                                                                            accumulate.init(init);
                                                                                        }
                                                                                        if (this.input.LA(1) == 48) {
                                                                                            this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                                                                                            if (this.state.failed) {
                                                                                                break block46;
                                                                                            }
                                                                                        }
                                                                                        this.match(this.input, 67, "action", null, DroolsEditorType.KEYWORD);
                                                                                        if (this.state.failed) {
                                                                                            break block47;
                                                                                        }
                                                                                        if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                                                                                            this.helper.emit(305);
                                                                                        }
                                                                                        String action = this.chunk(42, 43, 306);
                                                                                        if (this.state.failed) {
                                                                                            break block48;
                                                                                        }
                                                                                        if (this.state.backtracking == 0) {
                                                                                            accumulate.action(action);
                                                                                        }
                                                                                        if (this.input.LA(1) == 48) {
                                                                                            this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                                                                                            if (this.state.failed) {
                                                                                                break block49;
                                                                                            }
                                                                                        }
                                                                                        if (this.helper.validateIdentifierKey("reverse")) {
                                                                                            this.match(this.input, 67, "reverse", null, DroolsEditorType.KEYWORD);
                                                                                            if (this.state.failed) {
                                                                                                break block50;
                                                                                            }
                                                                                            if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                                                                                                this.helper.emit(307);
                                                                                            }
                                                                                            String reverse = this.chunk(42, 43, 308);
                                                                                            if (this.state.failed) {
                                                                                                break block51;
                                                                                            }
                                                                                            if (this.state.backtracking == 0) {
                                                                                                accumulate.reverse(reverse);
                                                                                            }
                                                                                            if (this.input.LA(1) == 48) {
                                                                                                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                                                                                                if (this.state.failed) {
                                                                                                    break block52;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        this.match(this.input, 67, "result", null, DroolsEditorType.KEYWORD);
                                                                                        if (this.state.failed) {
                                                                                            break block53;
                                                                                        }
                                                                                        if (this.state.backtracking == 0 && this.input.LA(1) != -1) {
                                                                                            this.helper.emit(309);
                                                                                        }
                                                                                        String result = this.chunk(42, 43, 310);
                                                                                        if (this.state.failed) {
                                                                                            break block54;
                                                                                        }
                                                                                        if (this.state.backtracking == 0) {
                                                                                            accumulate.result(result);
                                                                                        }
                                                                                    } else {
                                                                                        this.accumulateFunction(accumulate, null);
                                                                                        if (this.state.failed) {
                                                                                            break block55;
                                                                                        }
                                                                                    }
                                                                                    this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
                                                                                    if (!this.state.failed) break block56;
                                                                                    break block57;
                                                                                }
                                                                                catch (Throwable throwable) {
                                                                                    Object var10_21 = null;
                                                                                    this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                                                    if (this.state.backtracking != 0) throw throwable;
                                                                                    if (this.input.LA(1) == -1) throw throwable;
                                                                                    this.helper.emit(1);
                                                                                    throw throwable;
                                                                                }
                                                                            }
                                                                            if (this.state.backtracking != 0) return;
                                                                            if (this.input.LA(1) == -1) return;
                                                                            this.helper.emit(1);
                                                                            return;
                                                                        }
                                                                        Object var10_4 = null;
                                                                        this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                                        if (this.state.backtracking != 0) return;
                                                                        if (this.input.LA(1) == -1) return;
                                                                        this.helper.emit(1);
                                                                        return;
                                                                    }
                                                                    Object var10_5 = null;
                                                                    this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                                    if (this.state.backtracking != 0) return;
                                                                    if (this.input.LA(1) == -1) return;
                                                                    this.helper.emit(1);
                                                                    return;
                                                                }
                                                                Object var10_6 = null;
                                                                this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                                if (this.state.backtracking != 0) return;
                                                                if (this.input.LA(1) == -1) return;
                                                                this.helper.emit(1);
                                                                return;
                                                            }
                                                            Object var10_7 = null;
                                                            this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                            if (this.state.backtracking != 0) return;
                                                            if (this.input.LA(1) == -1) return;
                                                            this.helper.emit(1);
                                                            return;
                                                        }
                                                        Object var10_8 = null;
                                                        this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                        if (this.state.backtracking != 0) return;
                                                        if (this.input.LA(1) == -1) return;
                                                        this.helper.emit(1);
                                                        return;
                                                    }
                                                    Object var10_9 = null;
                                                    this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                    if (this.state.backtracking != 0) return;
                                                    if (this.input.LA(1) == -1) return;
                                                    this.helper.emit(1);
                                                    return;
                                                }
                                                Object var10_10 = null;
                                                this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                                if (this.state.backtracking != 0) return;
                                                if (this.input.LA(1) == -1) return;
                                                this.helper.emit(1);
                                                return;
                                            }
                                            Object var10_11 = null;
                                            this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                            if (this.state.backtracking != 0) return;
                                            if (this.input.LA(1) == -1) return;
                                            this.helper.emit(1);
                                            return;
                                        }
                                        Object var10_12 = null;
                                        this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                        if (this.state.backtracking != 0) return;
                                        if (this.input.LA(1) == -1) return;
                                        this.helper.emit(1);
                                        return;
                                    }
                                    Object var10_13 = null;
                                    this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                    if (this.state.backtracking != 0) return;
                                    if (this.input.LA(1) == -1) return;
                                    this.helper.emit(1);
                                    return;
                                }
                                Object var10_14 = null;
                                this.helper.end(AccumulateDescrBuilder.class, accumulate);
                                if (this.state.backtracking != 0) return;
                                if (this.input.LA(1) == -1) return;
                                this.helper.emit(1);
                                return;
                            }
                            Object var10_15 = null;
                            this.helper.end(AccumulateDescrBuilder.class, accumulate);
                            if (this.state.backtracking != 0) return;
                            if (this.input.LA(1) == -1) return;
                            this.helper.emit(1);
                            return;
                        }
                        Object var10_16 = null;
                        this.helper.end(AccumulateDescrBuilder.class, accumulate);
                        if (this.state.backtracking != 0) return;
                        if (this.input.LA(1) == -1) return;
                        this.helper.emit(1);
                        return;
                    }
                    Object var10_17 = null;
                    this.helper.end(AccumulateDescrBuilder.class, accumulate);
                    if (this.state.backtracking != 0) return;
                    if (this.input.LA(1) == -1) return;
                    this.helper.emit(1);
                    return;
                }
                Object var10_18 = null;
                this.helper.end(AccumulateDescrBuilder.class, accumulate);
                if (this.state.backtracking != 0) return;
                if (this.input.LA(1) == -1) return;
                this.helper.emit(1);
                return;
            }
            Object var10_19 = null;
            this.helper.end(AccumulateDescrBuilder.class, accumulate);
            if (this.state.backtracking != 0) return;
            if (this.input.LA(1) == -1) return;
            this.helper.emit(1);
            return;
        }
        Object var10_20 = null;
        this.helper.end(AccumulateDescrBuilder.class, accumulate);
        if (this.state.backtracking != 0) return;
        if (this.input.LA(1) == -1) return;
        this.helper.emit(1);
    }

    private void accumulateFunctionBinding(AccumulateDescrBuilder<?> accumulate) throws RecognitionException {
        String label = this.label(DroolsEditorType.IDENTIFIER_VARIABLE);
        this.accumulateFunction(accumulate, label);
    }

    private void accumulateFunction(AccumulateDescrBuilder<?> accumulate, String label) throws RecognitionException {
        Token function = this.match(this.input, 67, null, null, DroolsEditorType.KEYWORD);
        if (this.state.failed) {
            return;
        }
        List<String> parameters = this.parameters();
        if (this.state.failed) {
            return;
        }
        if (this.state.backtracking == 0) {
            accumulate.function(function.getText(), label, parameters.toArray(new String[parameters.size()]));
        }
    }

    private List<String> parameters() throws RecognitionException {
        this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.input.LA(1) != -1 && this.input.LA(1) != 43) {
            String param = this.conditionalExpression();
            if (this.state.failed) {
                return null;
            }
            parameters.add(param);
            while (this.input.LA(1) == 48) {
                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return null;
                }
                param = this.conditionalExpression();
                if (this.state.failed) {
                    return null;
                }
                parameters.add(param);
            }
        }
        this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
        if (this.state.failed) {
            return null;
        }
        return parameters;
    }

    private void rhs(RuleDescrBuilder rule) throws RecognitionException {
        String chunk = "";
        int first = -1;
        Token last = null;
        try {
            first = this.input.index();
            Token t = this.match(this.input, 67, "then", null, DroolsEditorType.KEYWORD);
            if (this.state.failed) {
                return;
            }
            if (this.state.backtracking == 0) {
                ((RuleDescr)rule.getDescr()).setConsequenceLocation(t.getLine(), t.getCharPositionInLine());
                this.helper.emit(1000);
            }
            while (this.input.LA(1) != -1 && !this.helper.validateIdentifierKey("end")) {
                this.helper.emit(this.input.LT(1), DroolsEditorType.CODE_CHUNK);
                this.input.consume();
            }
            last = this.input.LT(1);
            if (last.getTokenIndex() > first) {
                chunk = this.input.toString(first, last.getTokenIndex());
                if (chunk.endsWith("end")) {
                    chunk = chunk.substring(0, chunk.length() - "end".length());
                }
                chunk = chunk.replaceFirst("^then\\s*\\r?\\n?", "");
            }
            rule.rhs(chunk);
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void annotation(AnnotatedDescrBuilder<?> adb) {
        AnnotationDescrBuilder<?> annotation = null;
        try {
            block11: {
                block12: {
                    Token at = this.match(this.input, 20, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        return;
                    }
                    Token id = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER);
                    if (this.state.failed) {
                        return;
                    }
                    if (this.state.backtracking == 0) {
                        annotation = adb.newAnnotation(id.getText());
                        this.helper.setStart(annotation, at);
                    }
                    try {
                        if (this.input.LA(1) != 42) break block11;
                        if (this.speculateElementValuePairs()) {
                            this.elementValuePairs(annotation);
                            if (this.state.failed) {
                                Object var7_6 = null;
                                if (this.state.backtracking != 0) return;
                                this.helper.setEnd(annotation);
                                return;
                            }
                            break block11;
                        }
                        String value = this.chunk(42, 43, -1).trim();
                        if (this.state.failed) {
                            break block12;
                        }
                        if (this.state.backtracking == 0) {
                            annotation.value(value);
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (this.state.backtracking != 0) throw throwable;
                        this.helper.setEnd(annotation);
                        throw throwable;
                    }
                }
                Object var7_7 = null;
                if (this.state.backtracking != 0) return;
                this.helper.setEnd(annotation);
                return;
            }
            Object var7_8 = null;
            if (this.state.backtracking != 0) return;
            this.helper.setEnd(annotation);
            return;
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
    }

    private boolean speculateElementValuePairs() {
        ++this.state.backtracking;
        int start = this.input.mark();
        try {
            this.elementValuePairs(null);
        }
        catch (RecognitionException re) {
            System.err.println("impossible: " + re);
            re.printStackTrace();
        }
        boolean success = !this.state.failed;
        this.input.rewind(start);
        --this.state.backtracking;
        this.state.failed = false;
        return success;
    }

    private void elementValuePairs(AnnotationDescrBuilder<?> annotation) throws RecognitionException {
        try {
            this.match(this.input, 42, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
            this.elementValuePair(annotation);
            if (this.state.failed) {
                return;
            }
            while (this.input.LA(1) == 48) {
                this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                if (this.state.failed) {
                    return;
                }
                this.elementValuePair(annotation);
                if (!this.state.failed) continue;
                return;
            }
            this.match(this.input, 43, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
    }

    private void elementValuePair(AnnotationDescrBuilder<?> annotation) {
        try {
            Token id = this.match(this.input, 67, null, null, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return;
            }
            String key = id.getText();
            this.match(this.input, 41, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return;
            }
            String value = this.elementValue();
            if (this.state.failed) {
                return;
            }
            if (this.state.backtracking == 0) {
                String actKey = key != null ? key : "value";
                String actVal = ((AnnotationDescr)annotation.getDescr()).getValue(actKey);
                if (actVal != null) {
                    value = "\"" + AnnotationDescr.unquote(actVal) + AnnotationDescr.unquote(value) + "\"";
                }
                annotation.keyValue(actKey, value);
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
    }

    private String elementValue() {
        String value = "";
        try {
            int first = this.input.index();
            if (this.input.LA(1) == 46) {
                this.elementValueArrayInitializer();
                if (this.state.failed) {
                    return value;
                }
            } else {
                this.exprParser.conditionalExpression();
                if (this.state.failed) {
                    return value;
                }
            }
            value = this.input.toString(first, this.input.LT(-1).getTokenIndex());
        }
        catch (Exception re) {
            this.reportError(re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String elementValueArrayInitializer() {
        int first;
        block13: {
            String string;
            String value;
            block14: {
                String string2;
                block12: {
                    String string3;
                    block11: {
                        String string4;
                        block10: {
                            value = "";
                            first = this.input.index();
                            try {
                                try {
                                    this.match(this.input, 46, null, null, DroolsEditorType.SYMBOL);
                                    if (this.state.failed) {
                                        String string5 = value;
                                        Object var5_9 = null;
                                        value = this.input.toString(first, this.input.index());
                                        return string5;
                                    }
                                    if (this.input.LA(1) != 47) {
                                        this.elementValue();
                                        if (this.state.failed) {
                                            string4 = value;
                                            break block10;
                                        }
                                        while (this.input.LA(1) == 48) {
                                            this.match(this.input, 48, null, null, DroolsEditorType.SYMBOL);
                                            if (this.state.failed) {
                                                string3 = value;
                                                break block11;
                                            }
                                            this.elementValue();
                                            if (!this.state.failed) continue;
                                            string2 = value;
                                            break block12;
                                        }
                                    }
                                    this.match(this.input, 47, null, null, DroolsEditorType.SYMBOL);
                                    if (!this.state.failed) break block13;
                                    string = value;
                                    break block14;
                                }
                                catch (RecognitionException re) {
                                    this.reportError(re);
                                    Object var5_15 = null;
                                    return this.input.toString(first, this.input.index());
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_16 = null;
                                value = this.input.toString(first, this.input.index());
                                throw throwable;
                            }
                        }
                        Object var5_10 = null;
                        value = this.input.toString(first, this.input.index());
                        return string4;
                    }
                    Object var5_11 = null;
                    value = this.input.toString(first, this.input.index());
                    return string3;
                }
                Object var5_12 = null;
                value = this.input.toString(first, this.input.index());
                return string2;
            }
            Object var5_13 = null;
            value = this.input.toString(first, this.input.index());
            return string;
        }
        Object var5_14 = null;
        return this.input.toString(first, this.input.index());
    }

    public String type() throws RecognitionException {
        String type = "";
        try {
            int first;
            int last = first = this.input.index();
            this.match(this.input, 67, null, new int[]{49, 40}, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return type;
            }
            if (this.input.LA(1) == 40) {
                this.typeArguments();
                if (this.state.failed) {
                    return type;
                }
            }
            while (this.input.LA(1) == 49 && this.input.LA(2) == 67) {
                this.match(this.input, 49, null, new int[]{67}, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    return type;
                }
                this.match(this.input, 67, null, new int[]{49}, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    return type;
                }
                if (this.input.LA(1) != 40) continue;
                this.typeArguments();
                if (!this.state.failed) continue;
                return type;
            }
            while (this.input.LA(1) == 44 && this.input.LA(2) == 45) {
                this.match(this.input, 44, null, new int[]{45}, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    return type;
                }
                this.match(this.input, 45, null, null, DroolsEditorType.IDENTIFIER);
                if (!this.state.failed) continue;
                return type;
            }
            last = this.input.LT(-1).getTokenIndex();
            type = this.input.toString(first, last);
            type = type.replace(" ", "");
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        return type;
    }

    public String typeArguments() throws RecognitionException {
        String typeArguments = "";
        try {
            int first = this.input.index();
            Token token = this.match(this.input, 40, null, new int[]{52, 67}, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return typeArguments;
            }
            this.typeArgument();
            if (this.state.failed) {
                return typeArguments;
            }
            while (this.input.LA(1) == 48) {
                token = this.match(this.input, 48, null, new int[]{52, 67}, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    return typeArguments;
                }
                this.typeArgument();
                if (!this.state.failed) continue;
                return typeArguments;
            }
            token = this.match(this.input, 39, null, null, DroolsEditorType.SYMBOL);
            if (this.state.failed) {
                return typeArguments;
            }
            typeArguments = this.input.toString(first, token.getTokenIndex());
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        return typeArguments;
    }

    public String typeArgument() throws RecognitionException {
        String typeArgument = "";
        try {
            int first;
            int last = first = this.input.index();
            int next = this.input.LA(1);
            switch (next) {
                case 52: {
                    this.match(this.input, 52, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        return typeArgument;
                    }
                    if (this.helper.validateIdentifierKey("extends")) {
                        this.match(this.input, 67, "extends", null, DroolsEditorType.SYMBOL);
                        if (this.state.failed) {
                            return typeArgument;
                        }
                        this.type();
                        if (!this.state.failed) break;
                        return typeArgument;
                    }
                    if (!this.helper.validateIdentifierKey("super")) break;
                    this.match(this.input, 67, "super", null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        return typeArgument;
                    }
                    this.type();
                    if (!this.state.failed) break;
                    return typeArgument;
                }
                case 67: {
                    this.type();
                    if (!this.state.failed) break;
                    return typeArgument;
                }
            }
            last = this.input.LT(-1).getTokenIndex();
            typeArgument = this.input.toString(first, last);
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        return typeArgument;
    }

    public String qualifiedIdentifier() throws RecognitionException {
        String qi = "";
        try {
            Token first = this.match(this.input, 67, null, new int[]{49}, DroolsEditorType.IDENTIFIER);
            if (this.state.failed) {
                return qi;
            }
            Token last = first;
            while (this.input.LA(1) == 49 && this.input.LA(2) == 67) {
                last = this.match(this.input, 49, null, new int[]{67}, DroolsEditorType.IDENTIFIER);
                if (this.state.failed) {
                    return qi;
                }
                last = this.match(this.input, 67, null, new int[]{49}, DroolsEditorType.IDENTIFIER);
                if (!this.state.failed) continue;
                return qi;
            }
            qi = this.input.toString(first, last);
            qi = qi.replace(" ", "");
        }
        catch (RecognitionException re) {
            this.reportError(re);
        }
        return qi;
    }

    public String conditionalExpression() throws RecognitionException {
        int first = this.input.index();
        this.exprParser.conditionalExpression();
        if (this.state.failed) {
            return null;
        }
        if (this.state.backtracking == 0 && this.input.index() > first) {
            String expr = this.input.toString(first, this.input.LT(-1).getTokenIndex());
            return expr;
        }
        return null;
    }

    public String conditionalOrExpression() throws RecognitionException {
        int first = this.input.index();
        this.exprParser.conditionalOrExpression();
        if (this.state.failed) {
            return null;
        }
        if (this.state.backtracking == 0 && this.input.index() > first) {
            String expr = this.input.toString(first, this.input.LT(-1).getTokenIndex());
            return expr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String chunk(int leftDelimiter, int rightDelimiter, int location) {
        int last;
        int first;
        String chunk;
        block12: {
            String string;
            chunk = "";
            last = first = -1;
            try {
                try {
                    this.match(this.input, leftDelimiter, null, null, DroolsEditorType.SYMBOL);
                    if (this.state.failed) {
                        String string2 = chunk;
                        Object var10_10 = null;
                        if (last < first) return string2;
                        chunk = this.input.toString(first, last);
                        return string2;
                    }
                    if (this.state.backtracking == 0 && location >= 0) {
                        this.helper.emit(location);
                    }
                    int nests = 0;
                    first = this.input.index();
                    while (this.input.LA(1) != -1 && (this.input.LA(1) != rightDelimiter || nests > 0)) {
                        if (this.input.LA(1) == rightDelimiter) {
                            --nests;
                        } else if (this.input.LA(1) == leftDelimiter) {
                            ++nests;
                        }
                        this.input.consume();
                    }
                    last = this.input.LT(-1).getTokenIndex();
                    for (int i = first; i < last + 1; ++i) {
                        this.helper.emit(this.input.get(i), DroolsEditorType.CODE_CHUNK);
                    }
                    this.match(this.input, rightDelimiter, null, null, DroolsEditorType.SYMBOL);
                    if (!this.state.failed) break block12;
                    string = chunk;
                }
                catch (RecognitionException re) {
                    this.reportError(re);
                    Object var10_13 = null;
                    if (last < first) return chunk;
                    return this.input.toString(first, last);
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (last < first) throw throwable;
                chunk = this.input.toString(first, last);
                throw throwable;
            }
            Object var10_11 = null;
            if (last < first) return string;
            chunk = this.input.toString(first, last);
            return string;
        }
        Object var10_12 = null;
        if (last < first) return chunk;
        return this.input.toString(first, last);
    }

    private Token match(TokenStream input, int ttype, String text, int[] follow, DroolsEditorType etype) throws RecognitionException {
        Token matchedSymbol = null;
        matchedSymbol = input.LT(1);
        if (input.LA(1) == ttype && (text == null || text.equals(matchedSymbol.getText()))) {
            input.consume();
            this.state.errorRecovery = false;
            this.state.failed = false;
            this.helper.emit(matchedSymbol, etype);
            return matchedSymbol;
        }
        if (this.state.backtracking > 0) {
            this.state.failed = true;
            return matchedSymbol;
        }
        matchedSymbol = this.recoverFromMismatchedToken(input, ttype, text, follow);
        this.helper.emit(matchedSymbol, etype);
        return matchedSymbol;
    }

    protected Token recoverFromMismatchedToken(TokenStream input, int ttype, String text, int[] follow) throws RecognitionException {
        MismatchedTokenException e = null;
        if (this.mismatchIsUnwantedToken(input, ttype, text)) {
            e = new UnwantedTokenException(ttype, input);
            input.consume();
            this.reportError(e);
            Token matchedSymbol = input.LT(1);
            input.consume();
            return matchedSymbol;
        }
        if (this.mismatchIsMissingToken(input, follow)) {
            e = new MissingTokenException(ttype, input, null);
            this.reportError(e);
            return null;
        }
        e = text != null ? new DroolsMismatchedTokenException(ttype, text, input) : new MismatchedTokenException(ttype, input);
        throw e;
    }

    public boolean mismatchIsUnwantedToken(TokenStream input, int ttype, String text) {
        return input.LA(2) == ttype && (text == null || text.equals(input.LT(2).getText()));
    }

    public boolean mismatchIsMissingToken(TokenStream input, int[] follow) {
        if (follow == null) {
            return false;
        }
        return false;
    }

    private String safeStripDelimiters(String value, String left, String right) {
        if (value != null && (value = value.trim()).length() >= left.length() + right.length() && value.startsWith(left) && value.endsWith(right)) {
            value = value.substring(left.length(), value.length() - right.length());
        }
        return value;
    }

    private String safeStripStringDelimiters(String value) {
        if (value != null && (value = value.trim()).length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

