/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Item {
    static Logger log = LoggerFactory.getLogger(Item.class);
    protected Node node;
    protected RulesRepository rulesRepository;

    public Item(RulesRepository rulesRepository, Node node) {
        this.rulesRepository = rulesRepository;
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() throws RulesRepositoryException {
        try {
            return this.node.getName();
        }
        catch (Exception e) {
            log.error("Caught exception: " + e);
            throw new RulesRepositoryException(e);
        }
    }

    public RulesRepository getRulesRepository() {
        return this.rulesRepository;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Item)) {
            return false;
        }
        Item rhs = (Item)obj;
        try {
            return this.node.isSame(rhs.getNode());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        return this.node.hashCode();
    }
}

