/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.RecognitionException;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.mvel.ActivationPropertyHandler;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.AgendaItem;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.DrlExprParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateFieldExtractor;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.lang.DRLLexer;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RelationalExprDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.AbstractCompositeConstraint;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.From;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.LiteralRestriction;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.SlidingLengthWindow;
import org.drools.rule.SlidingTimeWindow;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.UnificationRestriction;
import org.drools.rule.VariableConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryElementBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;
import org.drools.spi.Restriction;
import org.drools.time.TimeUtils;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
implements RuleConditionBuilder {
    private static final java.util.regex.Pattern evalRegexp = java.util.regex.Pattern.compile("^eval\\s*\\(", 8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        boolean typeSafe = context.isTypesafe();
        try {
            RuleConditionElement ruleConditionElement = this.build(context, descr, null);
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        PropertyHandler handler;
        Pattern pattern;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        ObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                PackageRegistry pkgr = context.getPackageBuilder().getPackageRegistry(ClassUtils.getPackage(userProvidedClass));
                Package pkg = pkgr == null ? context.getPkg() : pkgr.getPackage();
                boolean isEvent = pkg.isEvent(userProvidedClass);
                objectType = new ClassObjectType(userProvidedClass, isEvent);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (objectType == null) {
            RuleConditionElement rce = null;
            if (context.getRule().getName().equals(patternDescr.getObjectType())) {
                QueryElementBuilder qeBuilder = new QueryElementBuilder();
                rce = qeBuilder.build(context, descr, prefixPattern, (Query)context.getRule());
            }
            if (rce == null) {
                Rule rule = context.getPkg().getRule(patternDescr.getObjectType());
                if (rule != null && rule instanceof Query) {
                    QueryElementBuilder qeBuilder = new QueryElementBuilder();
                    rce = qeBuilder.build(context, descr, prefixPattern, (Query)rule);
                }
                for (String importName : context.getDialect().getTypeResolver().getImports()) {
                    int pos = (importName = importName.trim()).indexOf(42);
                    if (pos < 0) continue;
                    String pkgName = importName.substring(0, pos - 1);
                    PackageRegistry pkgReg = context.getPackageBuilder().getPackageRegistry(pkgName);
                    if (pkgReg == null || (rule = pkgReg.getPackage().getRule(patternDescr.getObjectType())) == null || !(rule instanceof Query)) continue;
                    QueryElementBuilder qeBuilder = new QueryElementBuilder();
                    rce = qeBuilder.build(context, descr, prefixPattern, (Query)rule);
                    break;
                }
            }
            if (rce == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
            }
            return rce;
        }
        boolean duplicateBindings = context.getDeclarationResolver().isDuplicated(context.getRule(), patternDescr.getIdentifier());
        if (!StringUtils.isEmpty(patternDescr.getIdentifier()) && !duplicateBindings) {
            pattern = new Pattern(context.getNextPatternId(), 0, objectType, patternDescr.getIdentifier(), patternDescr.isInternalFact());
            if (objectType instanceof ClassObjectType) {
                context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (PatternExtractor)pattern.getDeclaration().getExtractor());
            }
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, objectType, null);
        }
        if (ClassObjectType.Activation_ObjectType.isAssignableFrom(pattern.getObjectType()) && (handler = PropertyHandlerFactory.getPropertyHandler(AgendaItem.class)) == null) {
            MVELCompilationUnit.PropertyHandlerFactoryFixer.getPropertyHandlerClass().put(AgendaItem.class, new ActivationPropertyHandler());
        }
        if (duplicateBindings) {
            if (patternDescr.isUnification()) {
                this.build(context, patternDescr, pattern, patternDescr, "this == " + patternDescr.getIdentifier());
            } else {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate declaration for variable '" + patternDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            }
        }
        if (objectType instanceof ClassObjectType) {
            context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, pattern);
        }
        context.getBuildStack().push(pattern);
        if (pattern.getObjectType() instanceof ClassObjectType) {
            Class<?> cls = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration typeDeclr = context.getPackageBuilder().getTypeDeclaration(cls);
            if (typeDeclr != null) {
                context.setTypesafe(typeDeclr.isTypesafe());
            } else {
                context.setTypesafe(true);
            }
        }
        this.processConstraintsAndBinds(context, patternDescr, pattern);
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(patternDescr.getSource().getClass());
            PatternSource source = (PatternSource)builder.build(context, patternDescr.getSource());
            if (source instanceof From) {
                ((From)source).setResultPattern(pattern);
            }
            pattern.setSource(source);
        }
        for (BehaviorDescr behaviorDescr : patternDescr.getBehaviors()) {
            if (pattern.getObjectType().isEvent()) {
                Behavior window;
                if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                    window = new SlidingTimeWindow(TimeUtils.parseTimeString(behaviorDescr.getParameters().get(0)));
                    pattern.addBehavior(window);
                    continue;
                }
                if (!Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) continue;
                window = new SlidingLengthWindow(Integer.valueOf(behaviorDescr.getParameters().get(0)));
                pattern.addBehavior(window);
                continue;
            }
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "A Sliding Window behavior can only be assigned to patterns declared with @role( event ). The pattern '" + pattern.getObjectType() + "' in the rule '" + context.getRule().getName() + "' is not declared as an Event."));
        }
        context.getBuildStack().pop();
        return pattern;
    }

    private void processConstraintsAndBinds(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        for (BaseDescr baseDescr : patternDescr.getDescrs()) {
            String expression = null;
            boolean isPositional = false;
            if (baseDescr instanceof BindingDescr) {
                BindingDescr bind = (BindingDescr)baseDescr;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
            } else if (baseDescr instanceof ExprConstraintDescr) {
                ExprConstraintDescr descr = (ExprConstraintDescr)baseDescr;
                expression = descr.getExpression();
                isPositional = descr.getType() == ExprConstraintDescr.Type.POSITIONAL;
            } else {
                expression = baseDescr.getText();
            }
            ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, baseDescr, expression);
            if (result == null) {
                return;
            }
            if (result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof BindingDescr) {
                this.buildRuleBindings(context, patternDescr, pattern, (BindingDescr)result.getDescrs().get(0), null);
                continue;
            }
            if (isPositional) {
                this.processPositional(context, patternDescr, pattern, (ExprConstraintDescr)baseDescr);
                continue;
            }
            this.build(context, patternDescr, pattern, result);
        }
    }

    private void processPositional(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, ExprConstraintDescr descr) {
        if (descr.getType() == ExprConstraintDescr.Type.POSITIONAL && pattern.getObjectType() instanceof ClassObjectType) {
            Class<?> klazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration tDecl = context.getPackageBuilder().getTypeDeclaration(klazz);
            if (tDecl == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, klazz, "Unable to find @positional definitions for :" + klazz + "\n"));
                return;
            }
            ClassDefinition clsDef = tDecl.getTypeClassDef();
            if (clsDef == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n"));
                return;
            }
            FieldDefinition field = clsDef.getField(descr.getPosition());
            if (field == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n"));
                return;
            }
            DRLLexer lex = new DRLLexer(new ANTLRStringStream(descr.getExpression()));
            boolean isSimpleIdentifier = false;
            try {
                lex.mID();
                isSimpleIdentifier = lex.getCharIndex() >= descr.getExpression().length();
            }
            catch (RecognitionException e) {
                // empty catch block
            }
            if (isSimpleIdentifier) {
                BindingDescr binder = new BindingDescr();
                binder.setUnification(true);
                binder.setExpression(field.getName());
                binder.setVariable(descr.getExpression());
                this.buildRuleBindings(context, patternDescr, pattern, binder, null);
            } else {
                this.build(context, patternDescr, pattern, descr, field.getName() + " == " + descr.getExpression());
            }
        }
    }

    private void build(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BaseDescr original, String expr) {
        ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, original, expr);
        if (result == null) {
            return;
        }
        result.copyLocation(original);
        this.build(context, patternDescr, pattern, result);
    }

    private void build(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, ConstraintConnectiveDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            d.copyLocation(descr);
            if (d instanceof BindingDescr) {
                this.buildRuleBindings(context, patternDescr, pattern, (BindingDescr)d, null);
                continue;
            }
            boolean simple = false;
            MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
            String expr = new MVELDumper().dump(d, mvelCtx);
            Map<String, OperatorDescr> aliases = mvelCtx.getAliases();
            for (BindingDescr bind : mvelCtx.getBindings()) {
                this.buildRuleBindings(context, patternDescr, pattern, bind, null);
            }
            if (this.processAtomicExpression(context, pattern, d, expr, aliases)) continue;
            RelationalExprDescr relDescr = d instanceof RelationalExprDescr ? (RelationalExprDescr)d : null;
            simple = this.isSimpleExpr(relDescr);
            if (simple && !ClassObjectType.Map_ObjectType.isAssignableFrom(pattern.getObjectType()) && !ClassObjectType.Activation_ObjectType.isAssignableFrom(pattern.getObjectType())) {
                this.buildRelationalExpression(context, patternDescr, pattern, relDescr, expr, aliases);
                continue;
            }
            this.createAndBuildPredicate(context, pattern, d, expr, aliases);
        }
    }

    private void buildRelationalExpression(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, RelationalExprDescr relDescr, String expr, Map<String, OperatorDescr> aliases) {
        BaseDescr rdescr;
        String value1 = null;
        String value2 = null;
        boolean usesThisRef = false;
        if (relDescr.getRight() instanceof AtomicExprDescr) {
            rdescr = (AtomicExprDescr)relDescr.getRight();
            value2 = ((AtomicExprDescr)rdescr).getExpression().trim();
            usesThisRef = "this".equals(value2) || value2.startsWith("this.");
        } else {
            rdescr = (BindingDescr)relDescr.getRight();
            value2 = ((BindingDescr)rdescr).getExpression().trim();
            boolean bl = usesThisRef = "this".equals(value2) || value2.startsWith("this.");
        }
        if (relDescr.getLeft() instanceof AtomicExprDescr) {
            AtomicExprDescr ldescr = (AtomicExprDescr)relDescr.getLeft();
            value1 = ldescr.getExpression();
            usesThisRef = usesThisRef || "this".equals(value1) || value1.startsWith("this.");
        } else {
            value1 = ((BindingDescr)relDescr.getLeft()).getExpression();
            usesThisRef = usesThisRef || "this".equals(value1) || value1.startsWith("this.");
        }
        ExprBindings value1Expr = new ExprBindings();
        this.setInputs(context, value1Expr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value1);
        ExprBindings value2Expr = new ExprBindings();
        this.setInputs(context, value2Expr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value2);
        boolean succeeded = false;
        if (!usesThisRef && value1Expr.isConstant()) {
            this.createAndBuildPredicate(context, pattern, relDescr, expr, aliases);
            return;
        }
        succeeded = this.buildConstraint(context, pattern, relDescr, aliases, value1, value2, value2Expr);
        if (!succeeded) {
            this.createAndBuildPredicate(context, pattern, relDescr, expr, aliases);
        }
    }

    private boolean buildConstraint(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, Map<String, OperatorDescr> aliases, String value1, String value2, ExprBindings value2Expr) {
        Pattern thisPattern;
        InternalReadAccessor extractor;
        String[] parts = value1.split("\\.");
        if (parts.length == 2) {
            if ("this".equals(parts[0].trim())) {
                value1 = parts[1];
            } else if (pattern.getDeclaration() != null && parts[0].trim().equals(pattern.getDeclaration().getIdentifier())) {
                value1 = parts[1];
            }
        }
        if ((extractor = PatternBuilder.getFieldReadAccessor(context, relDescr, pattern.getObjectType(), value1, null, false)) == null) {
            return false;
        }
        String operator = relDescr.getOperator().trim();
        Restriction restriction = null;
        if (value2Expr.isConstant()) {
            restriction = this.buildLiteralRestriction(context, extractor, new LiteralRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParameters(), value2, 3));
        } else {
            int dotPos = value2.lastIndexOf(46);
            if (dotPos >= 0) {
                String mainPart = value2.substring(0, dotPos);
                String lastPart = value2.substring(dotPos + 1);
                try {
                    Class cls = context.getDialect().getTypeResolver().resolveType(mainPart);
                    if (lastPart.indexOf(40) < 0 && lastPart.indexOf(46) < 0 && lastPart.indexOf(91) < 0) {
                        restriction = this.buildLiteralRestriction(context, extractor, new LiteralRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParameters(), value2, 3));
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        if (restriction != null) {
            pattern.addConstraint(new LiteralConstraint(extractor, (LiteralRestriction)restriction));
            return true;
        }
        Declaration declr = null;
        if (value2.indexOf(40) < 0 && value2.indexOf(46) < 0 && value2.indexOf(91) < 0 && (declr = context.getDeclarationResolver().getDeclaration(context.getRule(), value2)) == null && (declr = this.createDeclarationObject(context, value2, thisPattern = (Pattern)context.getBuildStack().peek())) == null) {
            try {
                Class cls = context.getDialect().getTypeResolver().resolveType(value2);
                restriction = this.buildLiteralRestriction(context, extractor, new LiteralRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParameters(), cls.getName(), 3));
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }
        if (declr == null && (parts = value2.split("\\.")).length == 2) {
            if ("this".equals(parts[0].trim())) {
                declr = this.createDeclarationObject(context, parts[1].trim(), (Pattern)context.getBuildStack().peek());
                value2 = parts[1].trim();
            } else {
                declr = context.getDeclarationResolver().getDeclaration(context.getRule(), parts[0].trim());
                if (declr != null) {
                    if (declr.isPatternDeclaration()) {
                        declr = this.createDeclarationObject(context, parts[1].trim(), declr.getPattern());
                        value2 = parts[1].trim();
                    } else {
                        return false;
                    }
                }
            }
        }
        if (declr != null) {
            EvaluatorDefinition.Target right = this.getRightTarget(extractor);
            EvaluatorDefinition.Target left = declr.isPatternDeclaration() && !Date.class.isAssignableFrom(declr.getExtractor().getExtractToClass()) && !Number.class.isAssignableFrom(declr.getExtractor().getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            Evaluator evaluator = this.getEvaluator(context, relDescr, extractor.getValueType(), operator, relDescr.isNegated(), relDescr.getParametersText(), left, right);
            if (evaluator == null) {
                return false;
            }
            restriction = new VariableRestriction(extractor, declr, evaluator);
            if (declr.getPattern().getObjectType().equals(new ClassObjectType(DroolsQuery.class)) && Operator.EQUAL.getOperatorString().equals(operator)) {
                restriction = new UnificationRestriction((VariableRestriction)restriction);
            }
        }
        if (restriction == null) {
            Dialect dialect = context.getDialect();
            if (!value2.startsWith("(")) {
                MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                context.setDialect(mvelDialect);
            }
            restriction = this.buildRestriction(context, (Pattern)context.getBuildStack().peek(), extractor, new ReturnValueRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParametersText(), value2), aliases);
            context.setDialect(dialect);
        }
        if (restriction == null || extractor == null) {
            return false;
        }
        pattern.addConstraint(new VariableConstraint(extractor, restriction));
        return true;
    }

    private boolean processAtomicExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases) {
        Matcher m;
        if (d instanceof AtomicExprDescr && (m = evalRegexp.matcher(((AtomicExprDescr)d).getExpression())).find()) {
            PredicateDescr pdescr = new PredicateDescr(expr);
            pdescr.copyLocation(d);
            this.buildEval(context, pattern, pdescr, null, aliases);
            return true;
        }
        return false;
    }

    private boolean isSimpleExpr(RelationalExprDescr relDescr) {
        boolean simple = false;
        if (relDescr != null && (relDescr.getLeft() instanceof AtomicExprDescr || relDescr.getLeft() instanceof BindingDescr) && (relDescr.getRight() instanceof AtomicExprDescr || relDescr.getRight() instanceof BindingDescr)) {
            simple = true;
        }
        return simple;
    }

    private void createAndBuildPredicate(RuleBuildContext context, Pattern pattern, BaseDescr base, String expr, Map<String, OperatorDescr> aliases) {
        Dialect dialect = context.getDialect();
        MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
        context.setDialect(mvelDialect);
        PredicateDescr pdescr = new PredicateDescr(expr);
        pdescr.copyLocation(base);
        this.buildEval(context, pattern, pdescr, null, aliases);
        context.setDialect(dialect);
    }

    private void setInputs(RuleBuildContext context, ExprBindings descrBranch, Class<?> thisClass, String expr) {
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
        ParserConfiguration conf = data.getParserConfiguration();
        conf.setClassLoader(context.getPackageBuilder().getRootClassLoader());
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(false);
        pctx.setStrongTyping(false);
        pctx.addInput("this", thisClass);
        pctx.addInput("empty", Boolean.TYPE);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        MVEL.analysisCompile(expr, pctx);
        if (!pctx.getInputs().isEmpty()) {
            for (String v : pctx.getInputs().keySet()) {
                if ("this".equals(v) || PropertyTools.getFieldOrAccessor(thisClass, v) != null && expr.matches("(^|.*\\W)empty($|\\W.*)")) {
                    descrBranch.getFieldAccessors().add(v);
                    continue;
                }
                if ("empty".equals(v)) continue;
                if (!context.getPkg().getGlobals().containsKey(v)) {
                    descrBranch.getRuleBindings().add(v);
                    continue;
                }
                descrBranch.getGlobalBindings().add(v);
            }
        }
    }

    private void setConstraintType(Pattern container, MutableTypeConstraint constraint) {
        Declaration[] declarations = constraint.getRequiredDeclarations();
        boolean isAlphaConstraint = true;
        for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
            if (declarations[i].isGlobal() || declarations[i].getPattern() == container) continue;
            isAlphaConstraint = false;
        }
        Constraint.ConstraintType type = isAlphaConstraint ? Constraint.ConstraintType.ALPHA : Constraint.ConstraintType.BETA;
        constraint.setType(type);
    }

    private void buildRuleBindings(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BindingDescr fieldBindingDescr, AbstractCompositeConstraint container) {
        if (context.getDeclarationResolver().isDuplicated(context.getRule(), fieldBindingDescr.getVariable())) {
            if (fieldBindingDescr.isUnification()) {
                this.build(context, patternDescr, pattern, fieldBindingDescr, fieldBindingDescr.getExpression() + " == " + fieldBindingDescr.getVariable());
                return;
            }
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getVariable() + "' in the rule '" + context.getRule().getName() + "'"));
        }
        Declaration declr = pattern.addDeclaration(fieldBindingDescr.getVariable());
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getExpression(), declr, true);
        declr.setReadAccessor(extractor);
    }

    private void buildEval(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, AbstractCompositeConstraint container, Map<String, OperatorDescr> aliases) {
        AnalysisResult analysis;
        Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(predicateDescr, context, true);
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        HashMap<String, EvaluatorWrapper> operators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, OperatorDescr> entry : aliases.entrySet()) {
            Declaration rightDecl;
            OperatorDescr op = entry.getValue();
            String leftStr = op.getLeftString();
            String rightStr = op.getRightString();
            Declaration leftDecl = context.getDeclarationResolver().getDeclaration(context.getRule(), leftStr);
            if (leftDecl == null && "this".equals(leftStr)) {
                leftDecl = this.createDeclarationObject(context, "this", pattern);
            }
            if ((rightDecl = context.getDeclarationResolver().getDeclaration(context.getRule(), rightStr)) == null && "this".equals(rightStr)) {
                rightDecl = this.createDeclarationObject(context, "this", pattern);
            }
            EvaluatorDefinition.Target left = leftDecl != null && leftDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            EvaluatorDefinition.Target right = rightDecl != null && rightDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            op.setLeftIsHandle(left == EvaluatorDefinition.Target.HANDLE);
            op.setRightIsHandle(right == EvaluatorDefinition.Target.HANDLE);
            Evaluator evaluator = this.getEvaluator(context, predicateDescr, ValueType.OBJECT_TYPE, op.getOperator(), false, op.getParametersText(), left, right);
            EvaluatorWrapper wrapper = new EvaluatorWrapper(evaluator, left == EvaluatorDefinition.Target.HANDLE ? leftDecl : null, right == EvaluatorDefinition.Target.HANDLE ? rightDecl : null);
            operators.put(entry.getKey(), wrapper);
        }
        Class<?> thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        if ((analysis = context.getDialect().analyzeExpression(context, predicateDescr, predicateDescr.getContent(), new BoundIdentifiers(declarations, globals, operators, thisClass))) == null) {
            return;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), analysis.getBoundIdentifiers(), factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        String[] requiredOperators = usedIdentifiers.getOperators().keySet().toArray(new String[usedIdentifiers.getOperators().size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals, requiredOperators);
        if (container == null) {
            pattern.addConstraint(predicateConstraint);
        } else {
            if (predicateConstraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                this.setConstraintType(pattern, predicateConstraint);
            }
            container.addConstraint(predicateConstraint);
        }
        PredicateBuilder builder = context.getDialect().getPredicateBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr, analysis);
    }

    private static Map<String, Class<?>> getDeclarationsMap(BaseDescr baseDescr, RuleBuildContext context, boolean reportError) {
        HashMap declarations = new HashMap();
        for (Map.Entry<String, Declaration> entry : context.getDeclarationResolver().getDeclarations(context.getRule()).entrySet()) {
            if (entry.getValue().getExtractor() == null) {
                if (!reportError) continue;
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), baseDescr, null, "Field Reader does not exist for declaration '" + entry.getKey() + "' in '" + baseDescr + "' in the rule '" + context.getRule().getName() + "'"));
                continue;
            }
            declarations.put(entry.getKey(), entry.getValue().getExtractor().getExtractToClass());
        }
        return declarations;
    }

    private void createImplicitBindings(RuleBuildContext context, Pattern pattern, Set<String> unboundIdentifiers, BoundIdentifiers boundIdentifiers, List factDeclarations) {
        Iterator<String> it = unboundIdentifiers.iterator();
        while (it.hasNext()) {
            String identifier = it.next();
            Declaration declaration = this.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
            if (boundIdentifiers.getDeclarations() == null) {
                boundIdentifiers.setDeclarations(new HashMap<String, Declaration>());
            }
            boundIdentifiers.getDeclarations().put(identifier, declaration);
            boundIdentifiers.getDeclrClasses().put(identifier, declaration.getExtractor().getExtractToClass());
            it.remove();
        }
    }

    private Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        return this.createDeclarationObject(context, identifier, identifier, pattern);
    }

    private Declaration createDeclarationObject(RuleBuildContext context, String identifier, String expr, Pattern pattern) {
        BindingDescr implicitBinding = new BindingDescr(identifier, expr);
        Declaration declaration = new Declaration(identifier, null, pattern, true);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getExpression(), declaration, false);
        if (extractor == null) {
            return null;
        }
        declaration.setReadAccessor(extractor);
        return declaration;
    }

    private LiteralRestriction buildLiteralRestriction(RuleBuildContext context, InternalReadAccessor extractor, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        ValueType vtype = extractor.getValueType();
        try {
            String value = literalRestrictionDescr.getText().trim();
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            ParserConfiguration pconf = data.getParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            Object o = MVEL.executeExpression(MVEL.compileExpression(value, pctx));
            if (o != null) {
                if (vtype == null) {
                    vtype = ValueType.determineValueType(o.getClass());
                } else if (vtype.getClassType() == String.class) {
                    o = o.toString();
                }
            }
            field = FieldFactory.getFieldValue(o, vtype, context.getPackageBuilder().getDateFormats());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (field == null) {
            return null;
        }
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, literalRestrictionDescr, vtype, literalRestrictionDescr.getEvaluator(), literalRestrictionDescr.isNegated(), literalRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private EvaluatorDefinition.Target getRightTarget(InternalReadAccessor extractor) {
        EvaluatorDefinition.Target right = extractor.isSelfReference() && !Date.class.isAssignableFrom(extractor.getExtractToClass()) && !Number.class.isAssignableFrom(extractor.getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
        return right;
    }

    private ReturnValueRestriction buildRestriction(RuleBuildContext context, Pattern pattern, InternalReadAccessor extractor, ReturnValueRestrictionDescr returnValueRestrictionDescr, Map<String, OperatorDescr> aliases) {
        Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(returnValueRestrictionDescr, context, true);
        Class<?> thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        AnalysisResult analysis = context.getDialect().analyzeExpression(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent(), new BoundIdentifiers(declarations, globals, null, thisClass));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), usedIdentifiers, factDeclarations);
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, returnValueRestrictionDescr, extractor.getValueType(), returnValueRestrictionDescr.getEvaluator(), returnValueRestrictionDescr.isNegated(), returnValueRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        ReturnValueRestriction returnValueRestriction = new ReturnValueRestriction(extractor, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
        ReturnValueBuilder builder = context.getDialect().getReturnValueBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, returnValueRestriction, returnValueRestrictionDescr, analysis);
        return returnValueRestriction;
    }

    public static void registerReadAccessor(RuleBuildContext context, ObjectType objectType, String fieldName, AcceptsReadAccessor target) {
        if (!ValueType.FACTTEMPLATE_TYPE.equals(objectType.getValueType())) {
            ClassFieldReader reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
        }
    }

    public static InternalReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        InternalReadAccessor reader = null;
        if (ValueType.FACTTEMPLATE_TYPE.equals(objectType.getValueType())) {
            FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
            reader = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
            if (target != null) {
                target.setReadAccessor(reader);
            }
        } else if (fieldName.indexOf(46) > -1 || fieldName.indexOf(91) > -1 || fieldName.indexOf(40) > -1) {
            try {
                Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(descr, context, false);
                Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
                AnalysisResult analysis = context.getDialect().analyzeExpression(context, descr, fieldName, new BoundIdentifiers(declarations, globals, null, ((ClassObjectType)objectType).getClassType()));
                if (analysis == null) {
                    if (reportError) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to analyze expression '" + fieldName + "'"));
                    }
                    return null;
                }
                BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
                if (!usedIdentifiers.getDeclrClasses().isEmpty()) {
                    if (reportError) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Variables can not be used inside bindings. Variable " + usedIdentifiers.getDeclrClasses().keySet() + " is being used in binding '" + fieldName + "'"));
                    }
                    return null;
                }
                reader = context.getPkg().getClassFieldAccessorStore().getMVELReader(context.getPkg().getName(), ((ClassObjectType)objectType).getClassName(), fieldName, context.isTypesafe());
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
                ((MVELCompileable)((Object)reader)).compile(data);
                data.addCompileable((MVELCompileable)((Object)reader));
            }
            catch (Exception e) {
                if (reportError) {
                    DialectUtil.copyErrorLocation(e, descr);
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create reader for '" + fieldName + "':" + e.getMessage()));
                }
                reader = null;
            }
        } else {
            try {
                reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
            }
            catch (Exception e) {
                if (reportError) {
                    DialectUtil.copyErrorLocation(e, descr);
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create Field Extractor for '" + fieldName + "'" + e.getMessage()));
                }
                reader = null;
            }
        }
        return reader;
    }

    private Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString, boolean isNegated, String parameters, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        EvaluatorDefinition def = context.getConfiguration().getEvaluatorRegistry().getEvaluatorDefinition(evaluatorString);
        if (def == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the Evaluator for ID '" + evaluatorString + "'"));
            return null;
        }
        Evaluator evaluator = def.getEvaluator(valueType, evaluatorString, isNegated, parameters, left, right);
        if (evaluator == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Evaluator '" + (isNegated ? "not " : "") + evaluatorString + "' does not support type '" + valueType));
        }
        return evaluator;
    }

    private ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, BaseDescr original, String expression) {
        DrlExprParser parser = new DrlExprParser();
        ConstraintConnectiveDescr result = parser.parse(expression);
        result.copyLocation(original);
        if (result == null || parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return null;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExprBindings {
        private Set<String> globalBindings = new HashSet<String>();
        private Set<String> ruleBindings = new HashSet<String>();
        private Set<String> fieldAccessors = new HashSet<String>();

        public Set<String> getGlobalBindings() {
            return this.globalBindings;
        }

        public Set<String> getRuleBindings() {
            return this.ruleBindings;
        }

        public Set<String> getFieldAccessors() {
            return this.fieldAccessors;
        }

        public boolean isConstant() {
            return this.globalBindings.isEmpty() && this.ruleBindings.isEmpty() && this.fieldAccessors.size() <= 1;
        }
    }
}

