/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.drools.guvnor.importgenerator.example.domain;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.command.CommandFactory;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagentTestApp {
    private boolean changeScannerInitialised = false;
    private Map<String, KnowledgeAgent> cache = new HashMap<String, KnowledgeAgent>();

    public static void main(String[] args) {
        new KagentTestApp().run();
    }

    public void run() {
        this.initChangeScanner();
        HashSet<String> packageNames = new HashSet<String>();
        packageNames.add("ping.test/1.0.0-SNAPSHOT");
        KnowledgeAgent kagent = this.getKnowledgeAgent("ping.test/1.0.0-SNAPSHOT");
        StatelessKnowledgeSession s = kagent.newStatelessKnowledgeSession();
        s.execute(Arrays.asList(CommandFactory.newGetObjects(), CommandFactory.newFireAllRules()));
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
    }

    public void initChangeScanner() {
    }

    public KnowledgeAgentConfiguration getConfig() {
        KnowledgeAgentConfiguration c = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        c.setProperty("drools.agent.scanDirectories", "true");
        c.setProperty("drools.agent.scanResources", "true");
        c.setProperty("drools.agent.newInstance", "true");
        return c;
    }

    public StatelessKnowledgeSession createSession(Set<String> packageNames) {
        return this.getKnowledgeBase(packageNames).newStatelessKnowledgeSession();
    }

    public StatefulKnowledgeSession createStatefulSession(Set<String> packageNames) {
        return this.getKnowledgeBase(packageNames).newStatefulKnowledgeSession();
    }

    private KnowledgeBase getKnowledgeBase(Set<String> packageNames, boolean ignorMissing) {
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        ArrayList kpl = new ArrayList();
        for (String packageName : packageNames) {
            try {
                KnowledgeAgent kagent = this.getKnowledgeAgent(packageName);
                kb.addKnowledgePackages(kagent.getKnowledgeBase().getKnowledgePackages());
            }
            catch (IllegalArgumentException e) {
                if (ignorMissing) continue;
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return kb;
    }

    private KnowledgeBase getKnowledgeBase(Set<String> packageNames) {
        return this.getKnowledgeBase(packageNames, false);
    }

    private KnowledgeAgent getKnowledgeAgent(String packageName) {
        if (this.cache.get(packageName) == null) {
            this.cache.put(packageName, this.createKnowledgeAgent(packageName));
        }
        return this.cache.get(packageName);
    }

    private KnowledgeAgent createKnowledgeAgent(String packageName) {
        this.initChangeScanner();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)("KAgent for " + packageName), (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)this.getConfig());
        kagent.applyChangeSet(ResourceFactory.newReaderResource((Reader)new StringReader(this.getChangeSet(packageName))));
        return kagent;
    }

    private String getChangeSet(String packageName) {
        String url = "http://localhost:8080/brms/org.drools.guvnor.Guvnor/package/";
        KnowledgeResourceType type = KnowledgeResourceType.PKG;
        StringBuffer xml = new StringBuffer();
        xml.append("<change-set xmlns='http://drools.org/drools-5.0/change-set'");
        xml.append("    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'");
        xml.append("    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >");
        xml.append("    <add> ");
        xml.append("        <resource source='" + url + packageName + "' type='" + type.name() + "' />");
        xml.append("    </add> ");
        xml.append("</change-set>");
        return xml.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnowledgeResourceType {
        DRL,
        PKG;

    }
}

